/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.SpringBootPropertyPlaceholderHelper;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class SpringBootUtil {
    public static final String SPRING_BOOT_GROUP_ID = "org.springframework.boot";
    public static final String SPRING_BOOT_DEVTOOLS_ARTIFACT_ID = "spring-boot-devtools";
    public static final String SPRING_BOOT_MAVEN_PLUGIN_ARTIFACT_ID = "spring-boot-maven-plugin";
    public static final String SPRING_BOOT_GRADLE_PLUGIN_ARTIFACT_ID = "org.springframework.boot.gradle.plugin";
    public static final String DEV_TOOLS_REMOTE_SECRET = "spring.devtools.remote.secret";
    public static final String DEV_TOOLS_REMOTE_SECRET_ENV = "SPRING_DEVTOOLS_REMOTE_SECRET";
    private static final String SPRING_WEB_FLUX_ARTIFACT_ID = "spring-boot-starter-webflux";
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String VALUE_SEPARATOR = ":";

    private SpringBootUtil() {
    }

    public static Properties getSpringBootApplicationProperties(URLClassLoader compileClassLoader) {
        return SpringBootUtil.getSpringBootApplicationProperties(null, compileClassLoader);
    }

    public static Properties getSpringBootApplicationProperties(String springActiveProfile, URLClassLoader compileClassLoader) {
        URL ymlResource = compileClassLoader.findResource("application.yml");
        URL propertiesResource = compileClassLoader.findResource("application.properties");
        Properties props = YamlUtil.getPropertiesFromYamlResource(springActiveProfile, ymlResource);
        props.putAll((Map<?, ?>)PropertiesUtil.getPropertiesFromResource(propertiesResource));
        if (ymlResource != null) {
            props.put("jkube.internal.application-config-file.path", ymlResource.toString());
        } else if (propertiesResource != null) {
            props.put("jkube.internal.application-config-file.path", propertiesResource.toString());
        }
        return new SpringBootPropertyPlaceholderHelper(PLACEHOLDER_PREFIX, PLACEHOLDER_SUFFIX, VALUE_SEPARATOR, true).replaceAllPlaceholders(props);
    }

    public static Optional<String> getSpringBootVersion(JavaProject javaProject) {
        return Optional.ofNullable(JKubeProjectUtil.getAnyDependencyVersionWithGroupId(javaProject, SPRING_BOOT_GROUP_ID));
    }

    public static String getSpringBootActiveProfile(JavaProject project) {
        if (project != null && project.getProperties() != null && project.getProperties().get("spring.profiles.active") != null) {
            return project.getProperties().get("spring.profiles.active").toString();
        }
        return null;
    }

    public static Map<String, Object> getSpringBootPluginConfiguration(JavaProject javaProject) {
        Plugin mavenPlugin = JKubeProjectUtil.getPlugin(javaProject, SPRING_BOOT_MAVEN_PLUGIN_ARTIFACT_ID);
        if (mavenPlugin != null) {
            return mavenPlugin.getConfiguration();
        }
        Plugin gradlePlugin = JKubeProjectUtil.getPlugin(javaProject, SPRING_BOOT_GRADLE_PLUGIN_ARTIFACT_ID);
        if (gradlePlugin != null) {
            return gradlePlugin.getConfiguration();
        }
        return Collections.emptyMap();
    }

    public static boolean isSpringBootRepackage(JavaProject project) {
        Plugin plugin = JKubeProjectUtil.getPlugin(project, SPRING_BOOT_MAVEN_PLUGIN_ARTIFACT_ID);
        return Optional.ofNullable(plugin).map(Plugin::getExecutions).map(e -> e.contains("repackage")).orElse(false);
    }

    public static Plugin getNativePlugin(JavaProject project) {
        Plugin plugin = JKubeProjectUtil.getPlugin(project, "org.graalvm.buildtools", "native-maven-plugin");
        if (plugin != null) {
            return plugin;
        }
        return JKubeProjectUtil.getPlugin(project, "org.graalvm.buildtools.native", "org.graalvm.buildtools.native.gradle.plugin");
    }

    public static File findNativeArtifactFile(JavaProject project) {
        File[] nativeExecutableArtifacts = null;
        for (String location : new String[]{"", "native/nativeCompile/"}) {
            nativeExecutableArtifacts = new File(project.getBuildDirectory(), location).listFiles(f -> f.isFile() && f.canExecute());
            if (nativeExecutableArtifacts != null && nativeExecutableArtifacts.length > 0) break;
        }
        if (nativeExecutableArtifacts == null) {
            return null;
        }
        if (nativeExecutableArtifacts.length == 1) {
            return nativeExecutableArtifacts[0];
        }
        List filteredBinaries = Arrays.stream(nativeExecutableArtifacts).filter(f -> !f.getName().endsWith(".so")).collect(Collectors.toList());
        if (filteredBinaries.size() == 1) {
            return (File)filteredBinaries.iterator().next();
        }
        throw new IllegalStateException("More than one native executable file found in " + project.getBuildDirectory().getAbsolutePath());
    }

    public static boolean hasSpringWebFluxDependency(JavaProject javaProject) {
        return JKubeProjectUtil.hasDependency(javaProject, SPRING_BOOT_GROUP_ID, SPRING_WEB_FLUX_ARTIFACT_ID);
    }
}

