/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class ValidationUtil {
    private ValidationUtil() {
    }

    public static String createValidationMessage(Set<ConstraintViolation<?>> constraintViolations) {
        if (constraintViolations.isEmpty()) {
            return "No Constraint Validations!";
        }
        StringBuilder builder = new StringBuilder("Constraint Validations: ");
        for (ConstraintViolation<?> violation : constraintViolations) {
            HasMetadata hasMetadata;
            ObjectMeta metadata;
            Object leafBean;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            if ((leafBean = violation.getLeafBean()) instanceof HasMetadata && (metadata = (hasMetadata = (HasMetadata)leafBean).getMetadata()) != null) {
                leafBean = hasMetadata.getKind() + ": " + metadata;
            }
            builder.append(violation.getPropertyPath()).append(" ").append(violation.getMessage()).append(" on bean: ").append(leafBean);
        }
        return builder.toString();
    }
}

