/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.Serializable;
import java.util.Optional;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyMode;

public class AssemblyConfiguration
implements Serializable {
    private String name;
    private String targetDir;
    private Boolean exportTargetDir;
    private boolean excludeFinalOutputArtifact;
    private PermissionMode permissions;
    private AssemblyMode mode;
    private String user;
    private String tarLongFileMode;
    private Assembly inline;

    public AssemblyMode getMode() {
        return this.mode != null ? this.mode : AssemblyMode.dir;
    }

    public String getModeRaw() {
        return this.mode != null ? this.mode.name() : null;
    }

    public PermissionMode getPermissions() {
        return this.permissions != null ? this.permissions : PermissionMode.keep;
    }

    public String getPermissionsRaw() {
        return this.permissions != null ? this.permissions.name() : null;
    }

    public static AssemblyConfigurationBuilder builder() {
        return new AssemblyConfigurationBuilder();
    }

    public AssemblyConfigurationBuilder toBuilder() {
        return new AssemblyConfigurationBuilder().name(this.name).targetDir(this.targetDir).exportTargetDir(this.exportTargetDir).excludeFinalOutputArtifact(this.excludeFinalOutputArtifact).permissions(this.permissions).mode(this.mode).user(this.user).tarLongFileMode(this.tarLongFileMode).inline(this.inline);
    }

    public AssemblyConfiguration(String name, String targetDir, Boolean exportTargetDir, boolean excludeFinalOutputArtifact, PermissionMode permissions, AssemblyMode mode, String user, String tarLongFileMode, Assembly inline) {
        this.name = name;
        this.targetDir = targetDir;
        this.exportTargetDir = exportTargetDir;
        this.excludeFinalOutputArtifact = excludeFinalOutputArtifact;
        this.permissions = permissions;
        this.mode = mode;
        this.user = user;
        this.tarLongFileMode = tarLongFileMode;
        this.inline = inline;
    }

    public AssemblyConfiguration() {
    }

    public String getName() {
        return this.name;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public Boolean getExportTargetDir() {
        return this.exportTargetDir;
    }

    public boolean isExcludeFinalOutputArtifact() {
        return this.excludeFinalOutputArtifact;
    }

    public String getUser() {
        return this.user;
    }

    public String getTarLongFileMode() {
        return this.tarLongFileMode;
    }

    public Assembly getInline() {
        return this.inline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssemblyConfiguration)) {
            return false;
        }
        AssemblyConfiguration other = (AssemblyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$targetDir = this.getTargetDir();
        String other$targetDir = other.getTargetDir();
        if (this$targetDir == null ? other$targetDir != null : !this$targetDir.equals(other$targetDir)) {
            return false;
        }
        Boolean this$exportTargetDir = this.getExportTargetDir();
        Boolean other$exportTargetDir = other.getExportTargetDir();
        if (this$exportTargetDir == null ? other$exportTargetDir != null : !((Object)this$exportTargetDir).equals(other$exportTargetDir)) {
            return false;
        }
        if (this.isExcludeFinalOutputArtifact() != other.isExcludeFinalOutputArtifact()) {
            return false;
        }
        PermissionMode this$permissions = this.getPermissions();
        PermissionMode other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)((Object)this$permissions)).equals((Object)other$permissions)) {
            return false;
        }
        AssemblyMode this$mode = this.getMode();
        AssemblyMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$tarLongFileMode = this.getTarLongFileMode();
        String other$tarLongFileMode = other.getTarLongFileMode();
        if (this$tarLongFileMode == null ? other$tarLongFileMode != null : !this$tarLongFileMode.equals(other$tarLongFileMode)) {
            return false;
        }
        Assembly this$inline = this.getInline();
        Assembly other$inline = other.getInline();
        return !(this$inline == null ? other$inline != null : !((Object)this$inline).equals(other$inline));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssemblyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $targetDir = this.getTargetDir();
        result = result * 59 + ($targetDir == null ? 43 : $targetDir.hashCode());
        Boolean $exportTargetDir = this.getExportTargetDir();
        result = result * 59 + ($exportTargetDir == null ? 43 : ((Object)$exportTargetDir).hashCode());
        result = result * 59 + (this.isExcludeFinalOutputArtifact() ? 79 : 97);
        PermissionMode $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)((Object)$permissions)).hashCode());
        AssemblyMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $tarLongFileMode = this.getTarLongFileMode();
        result = result * 59 + ($tarLongFileMode == null ? 43 : $tarLongFileMode.hashCode());
        Assembly $inline = this.getInline();
        result = result * 59 + ($inline == null ? 43 : ((Object)$inline).hashCode());
        return result;
    }

    public static enum PermissionMode {
        auto,
        exec,
        keep,
        ignore;

    }

    public static class AssemblyConfigurationBuilder {
        private String name;
        private String targetDir;
        private Boolean exportTargetDir;
        private boolean excludeFinalOutputArtifact;
        private PermissionMode permissions;
        private AssemblyMode mode;
        private String user;
        private String tarLongFileMode;
        private Assembly inline;

        public AssemblyConfigurationBuilder permissionsString(String permissionsString) {
            this.permissions = Optional.ofNullable(permissionsString).map(String::toLowerCase).map(PermissionMode::valueOf).orElse(null);
            return this;
        }

        public AssemblyConfigurationBuilder modeString(String modeString) {
            this.mode = Optional.ofNullable(modeString).map(String::toLowerCase).map(AssemblyMode::valueOf).orElse(null);
            return this;
        }

        AssemblyConfigurationBuilder() {
        }

        public AssemblyConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssemblyConfigurationBuilder targetDir(String targetDir) {
            this.targetDir = targetDir;
            return this;
        }

        public AssemblyConfigurationBuilder exportTargetDir(Boolean exportTargetDir) {
            this.exportTargetDir = exportTargetDir;
            return this;
        }

        public AssemblyConfigurationBuilder excludeFinalOutputArtifact(boolean excludeFinalOutputArtifact) {
            this.excludeFinalOutputArtifact = excludeFinalOutputArtifact;
            return this;
        }

        public AssemblyConfigurationBuilder permissions(PermissionMode permissions) {
            this.permissions = permissions;
            return this;
        }

        public AssemblyConfigurationBuilder mode(AssemblyMode mode) {
            this.mode = mode;
            return this;
        }

        public AssemblyConfigurationBuilder user(String user) {
            this.user = user;
            return this;
        }

        public AssemblyConfigurationBuilder tarLongFileMode(String tarLongFileMode) {
            this.tarLongFileMode = tarLongFileMode;
            return this;
        }

        public AssemblyConfigurationBuilder inline(Assembly inline) {
            this.inline = inline;
            return this;
        }

        public AssemblyConfiguration build() {
            return new AssemblyConfiguration(this.name, this.targetDir, this.exportTargetDir, this.excludeFinalOutputArtifact, this.permissions, this.mode, this.user, this.tarLongFileMode, this.inline);
        }

        public String toString() {
            return "AssemblyConfiguration.AssemblyConfigurationBuilder(name=" + this.name + ", targetDir=" + this.targetDir + ", exportTargetDir=" + this.exportTargetDir + ", excludeFinalOutputArtifact=" + this.excludeFinalOutputArtifact + ", permissions=" + (Object)((Object)this.permissions) + ", mode=" + (Object)((Object)this.mode) + ", user=" + this.user + ", tarLongFileMode=" + this.tarLongFileMode + ", inline=" + this.inline + ")";
        }
    }
}

