/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.MapUtil;

public class YamlUtil {
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)YAML_FACTORY);
    private static final String EMPTY_YAML = "---\n";

    private YamlUtil() {
    }

    public static Properties getPropertiesFromYamlResource(URL resource) {
        return YamlUtil.getPropertiesFromYamlResource(null, resource);
    }

    protected static Properties getPropertiesFromYamlResource(String activeProfile, URL resource) {
        if (resource != null) {
            try {
                Properties properties = new Properties();
                List<String> profiles = YamlUtil.splitYamlResource(resource);
                if (!profiles.isEmpty()) {
                    properties.putAll((Map<?, ?>)YamlUtil.getPropertiesFromYamlString(YamlUtil.getYamlFromYamlList(activeProfile, profiles)));
                }
                return properties;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading Yaml resource from URL " + resource, e);
            }
        }
        return new Properties();
    }

    public static Properties getPropertiesFromYamlString(String yamlString) throws IOException {
        Properties properties = new Properties();
        SortedMap source = (SortedMap)YAML_MAPPER.readValue(Optional.ofNullable(yamlString).filter(StringUtils::isNotBlank).orElse(EMPTY_YAML), new TypeReference<SortedMap<String, ?>>(){});
        if (source != null) {
            properties.putAll(MapUtil.getFlattenedMap(source));
        }
        return properties;
    }

    static List<String> splitYamlResource(URL resource) throws IOException {
        ArrayList<String> serializedYamlList = new ArrayList<String>();
        List parsedList = YAML_MAPPER.readValues((JsonParser)YAML_FACTORY.createParser(resource), new TypeReference<Map<String, ?>>(){}).readAll();
        for (Map listEntry : parsedList) {
            serializedYamlList.add(YAML_MAPPER.writeValueAsString((Object)listEntry));
        }
        return serializedYamlList;
    }

    static String getYamlFromYamlList(String pattern, List<String> yamlAsStringList) {
        if (pattern != null) {
            for (String yamlStr : yamlAsStringList) {
                if (!yamlStr.contains(pattern)) continue;
                return yamlStr;
            }
        }
        return yamlAsStringList.iterator().next();
    }
}

