/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public enum ResourceFileType {
    json("json", "json"){

        @Override
        public ObjectMapper getObjectMapper() {
            return Serialization.jsonMapper();
        }
    }
    ,
    yaml("yml", "yml"){

        @Override
        public ObjectMapper getObjectMapper() {
            return Serialization.yamlMapper();
        }
    };

    private final String extension;
    private String artifactType;

    private ResourceFileType(String extension, String artifactType) {
        this.extension = extension;
        this.artifactType = artifactType;
    }

    public abstract ObjectMapper getObjectMapper();

    public File addExtensionIfMissing(File file) {
        String path = file.getAbsolutePath();
        if (!path.endsWith("." + this.extension)) {
            return new File(path + "." + this.extension);
        }
        return file;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public static ResourceFileType fromExtension(String ext) {
        try {
            return ResourceFileType.valueOf(ext);
        }
        catch (IllegalArgumentException exp) {
            for (ResourceFileType type : ResourceFileType.values()) {
                if (!type.extension.equals(ext)) continue;
                return type;
            }
            throw exp;
        }
    }

    public static ResourceFileType fromFile(File file) {
        String ext = FilenameUtils.getExtension((String)file.getPath());
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            return ResourceFileType.fromExtension(ext);
        }
        throw new IllegalArgumentException(String.format("Unsupported extension '%s' for file %s. Must be one of %s", ext, file, Arrays.asList(ResourceFileType.values())));
    }
}

