/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.archive;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public enum ArchiveCompression {
    none(TarCompressionMethod.none, "tar"),
    gzip(TarCompressionMethod.gzip, "tar.gz"){

        @Override
        public OutputStream wrapOutputStream(OutputStream out) throws IOException {
            return new GZIPOutputStream(out);
        }
    }
    ,
    bzip2(TarCompressionMethod.bzip2, "tar.bz"){

        @Override
        public OutputStream wrapOutputStream(OutputStream out) throws IOException {
            return new BZip2CompressorOutputStream(out);
        }
    };

    private final TarCompressionMethod tarCompressionMethod;
    private final String fileSuffix;

    private ArchiveCompression(TarCompressionMethod tarCompressionMethod, String fileSuffix) {
        this.tarCompressionMethod = tarCompressionMethod;
        this.fileSuffix = fileSuffix;
    }

    public TarCompressionMethod getTarCompressionMethod() {
        return this.tarCompressionMethod;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) throws IOException {
        return outputStream;
    }

    public static ArchiveCompression fromFileName(String filename) {
        if (filename.endsWith(".tar.gz") || filename.endsWith(".tgz")) {
            return gzip;
        }
        if (filename.endsWith(".tar.bz") || filename.endsWith(".tar.bzip2") || filename.endsWith(".tar.bz2")) {
            return bzip2;
        }
        return none;
    }

    private static class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        private GZIPOutputStream(OutputStream out) throws IOException {
            super(out, 65536);
            this.def.setLevel(3);
        }
    }

    public static enum TarCompressionMethod {
        none,
        gzip,
        bzip2,
        snappy,
        xz;

    }
}

