/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SemanticVersionUtil;

public class MicroprofileHealthUtil {
    private static final String MICROPROFILE_HEALTH_DEPENDENCY = "microprofile-health";
    private static final String MICROPROFILE_DEPENDENCY = "microprofile";
    private static final String MICROPROFILE_GROUP = "org.eclipse.microprofile";
    private static final int MICROPROFILE_HEALTH_SUPPORTED_VERSION_MAJOR = 3;
    private static final int MICROPROFILE_HEALTH_SUPPORTED_VERSION_MINOR = 1;
    public static final String DEFAULT_READINESS_PATH = "/health/ready";
    public static final String DEFAULT_LIVENESS_PATH = "/health/live";
    public static final String DEFAULT_STARTUP_PATH = "/health/started";

    private MicroprofileHealthUtil() {
    }

    public static boolean hasMicroProfileHealthDependency(JavaProject javaProject) {
        return JKubeProjectUtil.hasDependency(javaProject, MICROPROFILE_GROUP, MICROPROFILE_HEALTH_DEPENDENCY);
    }

    public static boolean hasMicroProfileDependency(JavaProject javaProject) {
        return JKubeProjectUtil.hasDependency(javaProject, MICROPROFILE_GROUP, MICROPROFILE_DEPENDENCY);
    }

    public static boolean isStartupEndpointSupported(JavaProject javaProject) {
        String microProfileHealthVersion;
        if (MicroprofileHealthUtil.hasMicroProfileDependency(javaProject)) {
            microProfileHealthVersion = MicroprofileHealthUtil.getMicroProfileVersionFromArtifactId(javaProject, MICROPROFILE_DEPENDENCY);
        } else if (MicroprofileHealthUtil.hasMicroProfileHealthDependency(javaProject)) {
            microProfileHealthVersion = MicroprofileHealthUtil.getMicroProfileVersionFromArtifactId(javaProject, MICROPROFILE_HEALTH_DEPENDENCY);
        } else {
            return false;
        }
        return SemanticVersionUtil.isVersionAtLeast(3, 1, microProfileHealthVersion);
    }

    private static String getMicroProfileVersionFromArtifactId(JavaProject javaProject, String artifactId) {
        Dependency microProfileDep = JKubeProjectUtil.getDependency(javaProject, MICROPROFILE_GROUP, artifactId);
        if (microProfileDep != null) {
            return microProfileDep.getVersion();
        }
        return null;
    }
}

