/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

public class LogConfiguration
implements Serializable {
    private static final long serialVersionUID = 6896468158396394236L;
    public static final LogConfiguration DEFAULT = new LogConfiguration(null, null, null, null, null, null, null);
    private boolean enabled;
    private String prefix;
    private String date;
    private String color;
    private String file;
    private LogDriver driver;

    private LogConfiguration(Boolean enabled, String prefix, String color, String date, String file, Map<String, String> logDriverOpts, String driverName) {
        this.enabled = Optional.ofNullable(enabled).orElse(false);
        this.prefix = prefix;
        this.date = date;
        this.color = color;
        this.file = file;
        this.driver = Optional.ofNullable(driverName).map(dn -> new LogDriver((String)dn, logDriverOpts)).orElse(null);
    }

    public boolean isActivated() {
        return this.enabled || !this.isBlank();
    }

    private boolean isBlank() {
        return this.prefix == null && this.date == null && this.color == null && this.file == null && this.driver == null;
    }

    public String getFileLocation() {
        return this.file;
    }

    public static LogConfigurationBuilder builder() {
        return new LogConfigurationBuilder();
    }

    public LogConfiguration() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDate() {
        return this.date;
    }

    public String getColor() {
        return this.color;
    }

    public String getFile() {
        return this.file;
    }

    public LogDriver getDriver() {
        return this.driver;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        LogDriver this$driver = this.getDriver();
        LogDriver other$driver = other.getDriver();
        return !(this$driver == null ? other$driver != null : !this$driver.equals(other$driver));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        LogDriver $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        return result;
    }

    public static class LogConfigurationBuilder {
        private Boolean enabled;
        private String prefix;
        private String color;
        private String date;
        private String file;
        private Map<String, String> logDriverOpts;
        private String driverName;

        LogConfigurationBuilder() {
        }

        public LogConfigurationBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public LogConfigurationBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public LogConfigurationBuilder color(String color) {
            this.color = color;
            return this;
        }

        public LogConfigurationBuilder date(String date) {
            this.date = date;
            return this;
        }

        public LogConfigurationBuilder file(String file) {
            this.file = file;
            return this;
        }

        public LogConfigurationBuilder logDriverOpts(Map<String, String> logDriverOpts) {
            this.logDriverOpts = logDriverOpts;
            return this;
        }

        public LogConfigurationBuilder driverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this.enabled, this.prefix, this.color, this.date, this.file, this.logDriverOpts, this.driverName);
        }

        public String toString() {
            return "LogConfiguration.LogConfigurationBuilder(enabled=" + this.enabled + ", prefix=" + this.prefix + ", color=" + this.color + ", date=" + this.date + ", file=" + this.file + ", logDriverOpts=" + this.logDriverOpts + ", driverName=" + this.driverName + ")";
        }
    }

    public static class LogDriver
    implements Serializable {
        private String name;
        private Map<String, String> opts;

        private LogDriver(String name, Map<String, String> opts) {
            this.name = name;
            this.opts = opts;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getOpts() {
            return this.opts;
        }
    }
}

