/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image.build;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.build.Arguments;
import org.eclipse.jkube.kit.config.image.build.CleanupMode;
import org.eclipse.jkube.kit.config.image.build.HealthCheckConfiguration;

public class BuildConfiguration
implements Serializable {
    private static final long serialVersionUID = 3904939784596208966L;
    public static final String DEFAULT_FILTER = "${*}";
    public static final String DEFAULT_CLEANUP = "try";
    private String contextDir;
    private String dockerFile;
    private String dockerArchive;
    private String filter;
    private String from;
    private Map<String, String> fromExt;
    private String maintainer;
    private List<String> ports;
    private Arguments shell;
    private String imagePullPolicy;
    private List<String> runCmds;
    private String cleanup;
    private Boolean nocache;
    private Boolean optimise;
    private List<String> volumes;
    private List<String> tags;
    private Map<String, String> env;
    private Map<String, String> labels;
    private Map<String, String> args;
    private Arguments entryPoint;
    private String workdir;
    private Arguments cmd;
    private String user;
    private HealthCheckConfiguration healthCheck;
    private AssemblyConfiguration assembly;
    private Boolean skip;
    private ArchiveCompression compression;
    private Map<String, String> buildOptions;
    private File dockerFileFile;
    private File dockerArchiveFile;
    private List<String> cacheFrom;

    public boolean isDockerFileMode() {
        return this.dockerFile != null || this.contextDir != null;
    }

    public File getDockerFile() {
        return this.dockerFileFile;
    }

    public String getDockerFileRaw() {
        return this.dockerFile;
    }

    public File getDockerArchive() {
        return this.dockerArchiveFile;
    }

    public String getDockerArchiveRaw() {
        return this.dockerArchive;
    }

    public File getContextDir() {
        if (this.contextDir != null) {
            return new File(this.contextDir);
        }
        return Optional.ofNullable(this.getDockerFile().getParentFile()).orElse(new File("."));
    }

    public String getContextDirRaw() {
        return this.contextDir;
    }

    public String getFrom() {
        if (this.from == null && this.getFromExt() != null) {
            return this.getFromExt().get("name");
        }
        return this.from;
    }

    public List<String> getPorts() {
        return BuildConfiguration.removeEmptyEntries(this.ports);
    }

    public List<String> getVolumes() {
        return BuildConfiguration.removeEmptyEntries(this.volumes);
    }

    public List<String> getTags() {
        return BuildConfiguration.removeEmptyEntries(this.tags);
    }

    public Boolean getSkip() {
        return Optional.ofNullable(this.skip).orElse(false);
    }

    public ArchiveCompression getCompression() {
        return Optional.ofNullable(this.compression).orElse(ArchiveCompression.none);
    }

    public List<String> getRunCmds() {
        return BuildConfiguration.removeEmptyEntries(this.runCmds);
    }

    public boolean optimise() {
        return Optional.ofNullable(this.optimise).orElse(false);
    }

    public boolean nocache() {
        return Optional.ofNullable(this.nocache).orElse(false);
    }

    public CleanupMode cleanupMode() {
        return CleanupMode.parse(this.cleanup != null ? this.cleanup : DEFAULT_CLEANUP);
    }

    public File getAbsoluteContextDirPath(String sourceDirectory, String projectBaseDir) {
        return EnvUtil.prepareAbsoluteSourceDirPath((String)sourceDirectory, (String)projectBaseDir, (String)this.getContextDir().getPath());
    }

    public File getAbsoluteDockerFilePath(String sourceDirectory, String projectBaseDir) {
        return EnvUtil.prepareAbsoluteSourceDirPath((String)sourceDirectory, (String)projectBaseDir, (String)this.getDockerFile().getPath());
    }

    public File getAbsoluteDockerTarPath(String sourceDirectory, String projectBaseDir) {
        return EnvUtil.prepareAbsoluteSourceDirPath((String)sourceDirectory, (String)projectBaseDir, (String)this.getDockerArchive().getPath());
    }

    public String initAndValidate() {
        if (this.entryPoint != null) {
            this.entryPoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if (this.healthCheck != null) {
            this.healthCheck.validate();
        }
        this.initDockerFileFile();
        if (this.healthCheck != null) {
            return "1.24";
        }
        if (this.args != null && !this.args.isEmpty()) {
            return "1.21";
        }
        return null;
    }

    private void initDockerFileFile() {
        if (this.dockerFile != null && this.dockerArchive != null) {
            throw new IllegalArgumentException("Both <dockerFile> and <dockerArchive> are set. Only one of them can be specified.");
        }
        this.dockerFileFile = this.findDockerFileFile();
        if (this.dockerArchive != null) {
            this.dockerArchiveFile = new File(this.dockerArchive);
        }
    }

    private File findDockerFileFile() {
        if (this.dockerFile != null) {
            File dFile = new File(this.dockerFile);
            if (this.contextDir == null) {
                return dFile;
            }
            if (dFile.isAbsolute()) {
                return dFile;
            }
            return new File(this.contextDir, this.dockerFile);
        }
        if (this.contextDir != null) {
            return new File(this.contextDir, "Dockerfile");
        }
        return null;
    }

    public String validate() {
        if (this.entryPoint != null) {
            this.entryPoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if (this.healthCheck != null) {
            this.healthCheck.validate();
        }
        if ((this.dockerFile != null || this.contextDir != null) && this.dockerArchive != null) {
            throw new IllegalArgumentException("Both <dockerFile> (<contextDir>) and <dockerArchive> are set. Only one of them can be specified.");
        }
        if (this.healthCheck != null) {
            return "1.24";
        }
        if (this.args != null) {
            return "1.21";
        }
        return null;
    }

    public File calculateDockerFilePath() {
        if (this.dockerFile != null) {
            File dFile = new File(this.dockerFile);
            if (this.contextDir == null) {
                return dFile;
            }
            if (dFile.isAbsolute()) {
                return dFile;
            }
            if (EnvUtil.isWindows() && !BuildConfiguration.isValidWindowsFileName(this.dockerFile)) {
                throw new IllegalArgumentException(String.format("Invalid Windows file name %s for <dockerFile>", this.dockerFile));
            }
            return new File(this.contextDir, dFile.getPath());
        }
        if (this.contextDir != null) {
            return new File(this.contextDir, "Dockerfile");
        }
        throw new IllegalArgumentException("Can't calculate a docker file path if neither dockerFile nor contextDir is specified");
    }

    private static List<String> removeEmptyEntries(List<String> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    static boolean isValidWindowsFileName(String filename) {
        Pattern pattern = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F .]    # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);
        Matcher matcher = pattern.matcher(filename);
        return matcher.matches();
    }

    public static BuildConfigurationBuilder builder() {
        return new BuildConfigurationBuilder();
    }

    public BuildConfigurationBuilder toBuilder() {
        BuildConfigurationBuilder builder = new BuildConfigurationBuilder().contextDir(this.contextDir).dockerFile(this.dockerFile).dockerArchive(this.dockerArchive).filter(this.filter).from(this.from).fromExt(this.fromExt).maintainer(this.maintainer).shell(this.shell).imagePullPolicy(this.imagePullPolicy).cleanup(this.cleanup).nocache(this.nocache).optimise(this.optimise).entryPoint(this.entryPoint).workdir(this.workdir).cmd(this.cmd).user(this.user).healthCheck(this.healthCheck).assembly(this.assembly).skip(this.skip).compression(this.compression).buildOptions(this.buildOptions).dockerFileFile(this.dockerFileFile).dockerArchiveFile(this.dockerArchiveFile);
        if (this.ports != null) {
            builder.ports(this.ports);
        }
        if (this.runCmds != null) {
            builder.runCmds(this.runCmds);
        }
        if (this.volumes != null) {
            builder.volumes(this.volumes);
        }
        if (this.tags != null) {
            builder.tags(this.tags);
        }
        if (this.env != null) {
            builder.env(this.env);
        }
        if (this.labels != null) {
            builder.labels(this.labels);
        }
        if (this.args != null) {
            builder.args(this.args);
        }
        if (this.cacheFrom != null) {
            builder.cacheFrom(this.cacheFrom);
        }
        return builder;
    }

    public BuildConfiguration(String contextDir, String dockerFile, String dockerArchive, String filter, String from, Map<String, String> fromExt, String maintainer, List<String> ports, Arguments shell, String imagePullPolicy, List<String> runCmds, String cleanup, Boolean nocache, Boolean optimise, List<String> volumes, List<String> tags, Map<String, String> env, Map<String, String> labels, Map<String, String> args, Arguments entryPoint, String workdir, Arguments cmd, String user, HealthCheckConfiguration healthCheck, AssemblyConfiguration assembly, Boolean skip, ArchiveCompression compression, Map<String, String> buildOptions, File dockerFileFile, File dockerArchiveFile, List<String> cacheFrom) {
        this.contextDir = contextDir;
        this.dockerFile = dockerFile;
        this.dockerArchive = dockerArchive;
        this.filter = filter;
        this.from = from;
        this.fromExt = fromExt;
        this.maintainer = maintainer;
        this.ports = ports;
        this.shell = shell;
        this.imagePullPolicy = imagePullPolicy;
        this.runCmds = runCmds;
        this.cleanup = cleanup;
        this.nocache = nocache;
        this.optimise = optimise;
        this.volumes = volumes;
        this.tags = tags;
        this.env = env;
        this.labels = labels;
        this.args = args;
        this.entryPoint = entryPoint;
        this.workdir = workdir;
        this.cmd = cmd;
        this.user = user;
        this.healthCheck = healthCheck;
        this.assembly = assembly;
        this.skip = skip;
        this.compression = compression;
        this.buildOptions = buildOptions;
        this.dockerFileFile = dockerFileFile;
        this.dockerArchiveFile = dockerArchiveFile;
        this.cacheFrom = cacheFrom;
    }

    public BuildConfiguration() {
    }

    public String getFilter() {
        return this.filter;
    }

    public Map<String, String> getFromExt() {
        return this.fromExt;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public Arguments getShell() {
        return this.shell;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getCleanup() {
        return this.cleanup;
    }

    public Boolean getNocache() {
        return this.nocache;
    }

    public Boolean getOptimise() {
        return this.optimise;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public Arguments getEntryPoint() {
        return this.entryPoint;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    public String getUser() {
        return this.user;
    }

    public HealthCheckConfiguration getHealthCheck() {
        return this.healthCheck;
    }

    public AssemblyConfiguration getAssembly() {
        return this.assembly;
    }

    public Map<String, String> getBuildOptions() {
        return this.buildOptions;
    }

    public File getDockerFileFile() {
        return this.dockerFileFile;
    }

    public File getDockerArchiveFile() {
        return this.dockerArchiveFile;
    }

    public List<String> getCacheFrom() {
        return this.cacheFrom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfiguration)) {
            return false;
        }
        BuildConfiguration other = (BuildConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contextDir = this.contextDir;
        String other$contextDir = other.contextDir;
        if (this$contextDir == null ? other$contextDir != null : !this$contextDir.equals(other$contextDir)) {
            return false;
        }
        String this$dockerFile = this.dockerFile;
        String other$dockerFile = other.dockerFile;
        if (this$dockerFile == null ? other$dockerFile != null : !this$dockerFile.equals(other$dockerFile)) {
            return false;
        }
        String this$dockerArchive = this.dockerArchive;
        String other$dockerArchive = other.dockerArchive;
        if (this$dockerArchive == null ? other$dockerArchive != null : !this$dockerArchive.equals(other$dockerArchive)) {
            return false;
        }
        String this$filter = this.filter;
        String other$filter = other.filter;
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        String this$from = this.from;
        String other$from = other.from;
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Map<String, String> this$fromExt = this.fromExt;
        Map<String, String> other$fromExt = other.fromExt;
        if (this$fromExt == null ? other$fromExt != null : !((Object)this$fromExt).equals(other$fromExt)) {
            return false;
        }
        String this$maintainer = this.maintainer;
        String other$maintainer = other.maintainer;
        if (this$maintainer == null ? other$maintainer != null : !this$maintainer.equals(other$maintainer)) {
            return false;
        }
        List<String> this$ports = this.ports;
        List<String> other$ports = other.ports;
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        Arguments this$shell = this.shell;
        Arguments other$shell = other.shell;
        if (this$shell == null ? other$shell != null : !((Object)this$shell).equals(other$shell)) {
            return false;
        }
        String this$imagePullPolicy = this.imagePullPolicy;
        String other$imagePullPolicy = other.imagePullPolicy;
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        List<String> this$runCmds = this.runCmds;
        List<String> other$runCmds = other.runCmds;
        if (this$runCmds == null ? other$runCmds != null : !((Object)this$runCmds).equals(other$runCmds)) {
            return false;
        }
        String this$cleanup = this.cleanup;
        String other$cleanup = other.cleanup;
        if (this$cleanup == null ? other$cleanup != null : !this$cleanup.equals(other$cleanup)) {
            return false;
        }
        Boolean this$nocache = this.nocache;
        Boolean other$nocache = other.nocache;
        if (this$nocache == null ? other$nocache != null : !((Object)this$nocache).equals(other$nocache)) {
            return false;
        }
        Boolean this$optimise = this.optimise;
        Boolean other$optimise = other.optimise;
        if (this$optimise == null ? other$optimise != null : !((Object)this$optimise).equals(other$optimise)) {
            return false;
        }
        List<String> this$volumes = this.volumes;
        List<String> other$volumes = other.volumes;
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        List<String> this$tags = this.tags;
        List<String> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Map<String, String> this$env = this.env;
        Map<String, String> other$env = other.env;
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        Map<String, String> this$labels = this.labels;
        Map<String, String> other$labels = other.labels;
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$args = this.args;
        Map<String, String> other$args = other.args;
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        Arguments this$entryPoint = this.entryPoint;
        Arguments other$entryPoint = other.entryPoint;
        if (this$entryPoint == null ? other$entryPoint != null : !((Object)this$entryPoint).equals(other$entryPoint)) {
            return false;
        }
        String this$workdir = this.workdir;
        String other$workdir = other.workdir;
        if (this$workdir == null ? other$workdir != null : !this$workdir.equals(other$workdir)) {
            return false;
        }
        Arguments this$cmd = this.cmd;
        Arguments other$cmd = other.cmd;
        if (this$cmd == null ? other$cmd != null : !((Object)this$cmd).equals(other$cmd)) {
            return false;
        }
        String this$user = this.user;
        String other$user = other.user;
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        HealthCheckConfiguration this$healthCheck = this.healthCheck;
        HealthCheckConfiguration other$healthCheck = other.healthCheck;
        if (this$healthCheck == null ? other$healthCheck != null : !((Object)this$healthCheck).equals(other$healthCheck)) {
            return false;
        }
        AssemblyConfiguration this$assembly = this.assembly;
        AssemblyConfiguration other$assembly = other.assembly;
        if (this$assembly == null ? other$assembly != null : !this$assembly.equals(other$assembly)) {
            return false;
        }
        Boolean this$skip = this.skip;
        Boolean other$skip = other.skip;
        if (this$skip == null ? other$skip != null : !((Object)this$skip).equals(other$skip)) {
            return false;
        }
        ArchiveCompression this$compression = this.compression;
        ArchiveCompression other$compression = other.compression;
        if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
            return false;
        }
        Map<String, String> this$buildOptions = this.buildOptions;
        Map<String, String> other$buildOptions = other.buildOptions;
        if (this$buildOptions == null ? other$buildOptions != null : !((Object)this$buildOptions).equals(other$buildOptions)) {
            return false;
        }
        File this$dockerFileFile = this.dockerFileFile;
        File other$dockerFileFile = other.dockerFileFile;
        if (this$dockerFileFile == null ? other$dockerFileFile != null : !((Object)this$dockerFileFile).equals(other$dockerFileFile)) {
            return false;
        }
        File this$dockerArchiveFile = this.dockerArchiveFile;
        File other$dockerArchiveFile = other.dockerArchiveFile;
        if (this$dockerArchiveFile == null ? other$dockerArchiveFile != null : !((Object)this$dockerArchiveFile).equals(other$dockerArchiveFile)) {
            return false;
        }
        List<String> this$cacheFrom = this.cacheFrom;
        List<String> other$cacheFrom = other.cacheFrom;
        return !(this$cacheFrom == null ? other$cacheFrom != null : !((Object)this$cacheFrom).equals(other$cacheFrom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contextDir = this.contextDir;
        result = result * 59 + ($contextDir == null ? 43 : $contextDir.hashCode());
        String $dockerFile = this.dockerFile;
        result = result * 59 + ($dockerFile == null ? 43 : $dockerFile.hashCode());
        String $dockerArchive = this.dockerArchive;
        result = result * 59 + ($dockerArchive == null ? 43 : $dockerArchive.hashCode());
        String $filter = this.filter;
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        String $from = this.from;
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Map<String, String> $fromExt = this.fromExt;
        result = result * 59 + ($fromExt == null ? 43 : ((Object)$fromExt).hashCode());
        String $maintainer = this.maintainer;
        result = result * 59 + ($maintainer == null ? 43 : $maintainer.hashCode());
        List<String> $ports = this.ports;
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        Arguments $shell = this.shell;
        result = result * 59 + ($shell == null ? 43 : ((Object)$shell).hashCode());
        String $imagePullPolicy = this.imagePullPolicy;
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        List<String> $runCmds = this.runCmds;
        result = result * 59 + ($runCmds == null ? 43 : ((Object)$runCmds).hashCode());
        String $cleanup = this.cleanup;
        result = result * 59 + ($cleanup == null ? 43 : $cleanup.hashCode());
        Boolean $nocache = this.nocache;
        result = result * 59 + ($nocache == null ? 43 : ((Object)$nocache).hashCode());
        Boolean $optimise = this.optimise;
        result = result * 59 + ($optimise == null ? 43 : ((Object)$optimise).hashCode());
        List<String> $volumes = this.volumes;
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        List<String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Map<String, String> $env = this.env;
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        Map<String, String> $labels = this.labels;
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $args = this.args;
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        Arguments $entryPoint = this.entryPoint;
        result = result * 59 + ($entryPoint == null ? 43 : ((Object)$entryPoint).hashCode());
        String $workdir = this.workdir;
        result = result * 59 + ($workdir == null ? 43 : $workdir.hashCode());
        Arguments $cmd = this.cmd;
        result = result * 59 + ($cmd == null ? 43 : ((Object)$cmd).hashCode());
        String $user = this.user;
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        HealthCheckConfiguration $healthCheck = this.healthCheck;
        result = result * 59 + ($healthCheck == null ? 43 : ((Object)$healthCheck).hashCode());
        AssemblyConfiguration $assembly = this.assembly;
        result = result * 59 + ($assembly == null ? 43 : $assembly.hashCode());
        Boolean $skip = this.skip;
        result = result * 59 + ($skip == null ? 43 : ((Object)$skip).hashCode());
        ArchiveCompression $compression = this.compression;
        result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
        Map<String, String> $buildOptions = this.buildOptions;
        result = result * 59 + ($buildOptions == null ? 43 : ((Object)$buildOptions).hashCode());
        File $dockerFileFile = this.dockerFileFile;
        result = result * 59 + ($dockerFileFile == null ? 43 : ((Object)$dockerFileFile).hashCode());
        File $dockerArchiveFile = this.dockerArchiveFile;
        result = result * 59 + ($dockerArchiveFile == null ? 43 : ((Object)$dockerArchiveFile).hashCode());
        List<String> $cacheFrom = this.cacheFrom;
        result = result * 59 + ($cacheFrom == null ? 43 : ((Object)$cacheFrom).hashCode());
        return result;
    }

    private void setDockerFileFile(File dockerFileFile) {
        this.dockerFileFile = dockerFileFile;
    }

    private void setDockerArchiveFile(File dockerArchiveFile) {
        this.dockerArchiveFile = dockerArchiveFile;
    }

    public static class BuildConfigurationBuilder {
        private String contextDir;
        private String dockerFile;
        private String dockerArchive;
        private String filter;
        private String from;
        private Map<String, String> fromExt;
        private String maintainer;
        private ArrayList<String> ports;
        private Arguments shell;
        private String imagePullPolicy;
        private ArrayList<String> runCmds;
        private String cleanup;
        private Boolean nocache;
        private Boolean optimise;
        private ArrayList<String> volumes;
        private ArrayList<String> tags;
        private ArrayList<String> env$key;
        private ArrayList<String> env$value;
        private ArrayList<String> labels$key;
        private ArrayList<String> labels$value;
        private ArrayList<String> args$key;
        private ArrayList<String> args$value;
        private Arguments entryPoint;
        private String workdir;
        private Arguments cmd;
        private String user;
        private HealthCheckConfiguration healthCheck;
        private AssemblyConfiguration assembly;
        private Boolean skip;
        private ArchiveCompression compression;
        private Map<String, String> buildOptions;
        private File dockerFileFile;
        private File dockerArchiveFile;
        private ArrayList<String> cacheFrom;

        public BuildConfigurationBuilder compressionString(String compressionString) {
            this.compression = Optional.ofNullable(compressionString).map(ArchiveCompression::valueOf).orElse(null);
            return this;
        }

        BuildConfigurationBuilder() {
        }

        public BuildConfigurationBuilder contextDir(String contextDir) {
            this.contextDir = contextDir;
            return this;
        }

        public BuildConfigurationBuilder dockerFile(String dockerFile) {
            this.dockerFile = dockerFile;
            return this;
        }

        public BuildConfigurationBuilder dockerArchive(String dockerArchive) {
            this.dockerArchive = dockerArchive;
            return this;
        }

        public BuildConfigurationBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public BuildConfigurationBuilder from(String from) {
            this.from = from;
            return this;
        }

        public BuildConfigurationBuilder fromExt(Map<String, String> fromExt) {
            this.fromExt = fromExt;
            return this;
        }

        public BuildConfigurationBuilder maintainer(String maintainer) {
            this.maintainer = maintainer;
            return this;
        }

        public BuildConfigurationBuilder port(String port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public BuildConfigurationBuilder ports(Collection<? extends String> ports) {
            if (ports == null) {
                throw new NullPointerException("ports cannot be null");
            }
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public BuildConfigurationBuilder clearPorts() {
            if (this.ports != null) {
                this.ports.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder shell(Arguments shell) {
            this.shell = shell;
            return this;
        }

        public BuildConfigurationBuilder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public BuildConfigurationBuilder runCmd(String runCmd) {
            if (this.runCmds == null) {
                this.runCmds = new ArrayList();
            }
            this.runCmds.add(runCmd);
            return this;
        }

        public BuildConfigurationBuilder runCmds(Collection<? extends String> runCmds) {
            if (runCmds == null) {
                throw new NullPointerException("runCmds cannot be null");
            }
            if (this.runCmds == null) {
                this.runCmds = new ArrayList();
            }
            this.runCmds.addAll(runCmds);
            return this;
        }

        public BuildConfigurationBuilder clearRunCmds() {
            if (this.runCmds != null) {
                this.runCmds.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder cleanup(String cleanup) {
            this.cleanup = cleanup;
            return this;
        }

        public BuildConfigurationBuilder nocache(Boolean nocache) {
            this.nocache = nocache;
            return this;
        }

        public BuildConfigurationBuilder optimise(Boolean optimise) {
            this.optimise = optimise;
            return this;
        }

        public BuildConfigurationBuilder volume(String volume) {
            if (this.volumes == null) {
                this.volumes = new ArrayList();
            }
            this.volumes.add(volume);
            return this;
        }

        public BuildConfigurationBuilder volumes(Collection<? extends String> volumes) {
            if (volumes == null) {
                throw new NullPointerException("volumes cannot be null");
            }
            if (this.volumes == null) {
                this.volumes = new ArrayList();
            }
            this.volumes.addAll(volumes);
            return this;
        }

        public BuildConfigurationBuilder clearVolumes() {
            if (this.volumes != null) {
                this.volumes.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public BuildConfigurationBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public BuildConfigurationBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder putEnv(String putEnvKey, String putEnvValue) {
            if (this.env$key == null) {
                this.env$key = new ArrayList();
                this.env$value = new ArrayList();
            }
            this.env$key.add(putEnvKey);
            this.env$value.add(putEnvValue);
            return this;
        }

        public BuildConfigurationBuilder env(Map<? extends String, ? extends String> env) {
            if (env == null) {
                throw new NullPointerException("env cannot be null");
            }
            if (this.env$key == null) {
                this.env$key = new ArrayList();
                this.env$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : env.entrySet()) {
                this.env$key.add($lombokEntry.getKey());
                this.env$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public BuildConfigurationBuilder clearEnv() {
            if (this.env$key != null) {
                this.env$key.clear();
                this.env$value.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder label(String labelKey, String labelValue) {
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            this.labels$key.add(labelKey);
            this.labels$value.add(labelValue);
            return this;
        }

        public BuildConfigurationBuilder labels(Map<? extends String, ? extends String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels cannot be null");
            }
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : labels.entrySet()) {
                this.labels$key.add($lombokEntry.getKey());
                this.labels$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public BuildConfigurationBuilder clearLabels() {
            if (this.labels$key != null) {
                this.labels$key.clear();
                this.labels$value.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder arg(String argKey, String argValue) {
            if (this.args$key == null) {
                this.args$key = new ArrayList();
                this.args$value = new ArrayList();
            }
            this.args$key.add(argKey);
            this.args$value.add(argValue);
            return this;
        }

        public BuildConfigurationBuilder args(Map<? extends String, ? extends String> args) {
            if (args == null) {
                throw new NullPointerException("args cannot be null");
            }
            if (this.args$key == null) {
                this.args$key = new ArrayList();
                this.args$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : args.entrySet()) {
                this.args$key.add($lombokEntry.getKey());
                this.args$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public BuildConfigurationBuilder clearArgs() {
            if (this.args$key != null) {
                this.args$key.clear();
                this.args$value.clear();
            }
            return this;
        }

        public BuildConfigurationBuilder entryPoint(Arguments entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public BuildConfigurationBuilder workdir(String workdir) {
            this.workdir = workdir;
            return this;
        }

        public BuildConfigurationBuilder cmd(Arguments cmd) {
            this.cmd = cmd;
            return this;
        }

        public BuildConfigurationBuilder user(String user) {
            this.user = user;
            return this;
        }

        public BuildConfigurationBuilder healthCheck(HealthCheckConfiguration healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public BuildConfigurationBuilder assembly(AssemblyConfiguration assembly) {
            this.assembly = assembly;
            return this;
        }

        public BuildConfigurationBuilder skip(Boolean skip) {
            this.skip = skip;
            return this;
        }

        public BuildConfigurationBuilder compression(ArchiveCompression compression) {
            this.compression = compression;
            return this;
        }

        public BuildConfigurationBuilder buildOptions(Map<String, String> buildOptions) {
            this.buildOptions = buildOptions;
            return this;
        }

        public BuildConfigurationBuilder dockerFileFile(File dockerFileFile) {
            this.dockerFileFile = dockerFileFile;
            return this;
        }

        public BuildConfigurationBuilder dockerArchiveFile(File dockerArchiveFile) {
            this.dockerArchiveFile = dockerArchiveFile;
            return this;
        }

        public BuildConfigurationBuilder addCacheFrom(String addCacheFrom) {
            if (this.cacheFrom == null) {
                this.cacheFrom = new ArrayList();
            }
            this.cacheFrom.add(addCacheFrom);
            return this;
        }

        public BuildConfigurationBuilder cacheFrom(Collection<? extends String> cacheFrom) {
            if (cacheFrom == null) {
                throw new NullPointerException("cacheFrom cannot be null");
            }
            if (this.cacheFrom == null) {
                this.cacheFrom = new ArrayList();
            }
            this.cacheFrom.addAll(cacheFrom);
            return this;
        }

        public BuildConfigurationBuilder clearCacheFrom() {
            if (this.cacheFrom != null) {
                this.cacheFrom.clear();
            }
            return this;
        }

        public BuildConfiguration build() {
            List<String> cacheFrom;
            Map<Object, Object> args;
            Map<Object, Object> labels;
            Map<Object, Object> env;
            List<String> tags;
            List<String> volumes;
            List<String> runCmds;
            List<String> ports;
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<String>(this.ports));
                }
            }
            switch (this.runCmds == null ? 0 : this.runCmds.size()) {
                case 0: {
                    runCmds = Collections.emptyList();
                    break;
                }
                case 1: {
                    runCmds = Collections.singletonList(this.runCmds.get(0));
                    break;
                }
                default: {
                    runCmds = Collections.unmodifiableList(new ArrayList<String>(this.runCmds));
                }
            }
            switch (this.volumes == null ? 0 : this.volumes.size()) {
                case 0: {
                    volumes = Collections.emptyList();
                    break;
                }
                case 1: {
                    volumes = Collections.singletonList(this.volumes.get(0));
                    break;
                }
                default: {
                    volumes = Collections.unmodifiableList(new ArrayList<String>(this.volumes));
                }
            }
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            switch (this.env$key == null ? 0 : this.env$key.size()) {
                case 0: {
                    env = Collections.emptyMap();
                    break;
                }
                case 1: {
                    env = Collections.singletonMap(this.env$key.get(0), this.env$value.get(0));
                    break;
                }
                default: {
                    env = new LinkedHashMap(this.env$key.size() < 0x40000000 ? 1 + this.env$key.size() + (this.env$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.env$key.size(); ++$i) {
                        env.put(this.env$key.get($i), this.env$value.get($i));
                    }
                    env = Collections.unmodifiableMap(env);
                }
            }
            switch (this.labels$key == null ? 0 : this.labels$key.size()) {
                case 0: {
                    labels = Collections.emptyMap();
                    break;
                }
                case 1: {
                    labels = Collections.singletonMap(this.labels$key.get(0), this.labels$value.get(0));
                    break;
                }
                default: {
                    labels = new LinkedHashMap(this.labels$key.size() < 0x40000000 ? 1 + this.labels$key.size() + (this.labels$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.labels$key.size(); ++$i) {
                        labels.put(this.labels$key.get($i), this.labels$value.get($i));
                    }
                    labels = Collections.unmodifiableMap(labels);
                }
            }
            switch (this.args$key == null ? 0 : this.args$key.size()) {
                case 0: {
                    args = Collections.emptyMap();
                    break;
                }
                case 1: {
                    args = Collections.singletonMap(this.args$key.get(0), this.args$value.get(0));
                    break;
                }
                default: {
                    args = new LinkedHashMap(this.args$key.size() < 0x40000000 ? 1 + this.args$key.size() + (this.args$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.args$key.size(); ++$i) {
                        args.put(this.args$key.get($i), this.args$value.get($i));
                    }
                    args = Collections.unmodifiableMap(args);
                }
            }
            switch (this.cacheFrom == null ? 0 : this.cacheFrom.size()) {
                case 0: {
                    cacheFrom = Collections.emptyList();
                    break;
                }
                case 1: {
                    cacheFrom = Collections.singletonList(this.cacheFrom.get(0));
                    break;
                }
                default: {
                    cacheFrom = Collections.unmodifiableList(new ArrayList<String>(this.cacheFrom));
                }
            }
            return new BuildConfiguration(this.contextDir, this.dockerFile, this.dockerArchive, this.filter, this.from, this.fromExt, this.maintainer, ports, this.shell, this.imagePullPolicy, runCmds, this.cleanup, this.nocache, this.optimise, volumes, tags, env, labels, args, this.entryPoint, this.workdir, this.cmd, this.user, this.healthCheck, this.assembly, this.skip, this.compression, this.buildOptions, this.dockerFileFile, this.dockerArchiveFile, cacheFrom);
        }

        public String toString() {
            return "BuildConfiguration.BuildConfigurationBuilder(contextDir=" + this.contextDir + ", dockerFile=" + this.dockerFile + ", dockerArchive=" + this.dockerArchive + ", filter=" + this.filter + ", from=" + this.from + ", fromExt=" + this.fromExt + ", maintainer=" + this.maintainer + ", ports=" + this.ports + ", shell=" + this.shell + ", imagePullPolicy=" + this.imagePullPolicy + ", runCmds=" + this.runCmds + ", cleanup=" + this.cleanup + ", nocache=" + this.nocache + ", optimise=" + this.optimise + ", volumes=" + this.volumes + ", tags=" + this.tags + ", env$key=" + this.env$key + ", env$value=" + this.env$value + ", labels$key=" + this.labels$key + ", labels$value=" + this.labels$value + ", args$key=" + this.args$key + ", args$value=" + this.args$value + ", entryPoint=" + this.entryPoint + ", workdir=" + this.workdir + ", cmd=" + this.cmd + ", user=" + this.user + ", healthCheck=" + this.healthCheck + ", assembly=" + this.assembly + ", skip=" + this.skip + ", compression=" + this.compression + ", buildOptions=" + this.buildOptions + ", dockerFileFile=" + this.dockerFileFile + ", dockerArchiveFile=" + this.dockerArchiveFile + ", cacheFrom=" + this.cacheFrom + ")";
        }
    }
}

