/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.access;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.UnknownHostException;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.access.ClusterConfiguration;

public class ClusterAccess {
    private final KitLogger kitLogger;
    private final ClusterConfiguration clusterConfiguration;

    public ClusterAccess(KitLogger kitLogger, ClusterConfiguration clusterConfiguration) {
        this.kitLogger = kitLogger;
        this.clusterConfiguration = clusterConfiguration == null ? ClusterConfiguration.builder().build() : clusterConfiguration;
    }

    public <T extends KubernetesClient> T createDefaultClient() {
        if (this.isOpenShift()) {
            return (T)this.createOpenShiftClient();
        }
        return (T)this.createKubernetesClient();
    }

    private KubernetesClient createKubernetesClient() {
        return new KubernetesClientBuilder().withConfig(this.createDefaultConfig()).build();
    }

    private OpenShiftClient createOpenShiftClient() {
        return (OpenShiftClient)this.createKubernetesClient().adapt(OpenShiftClient.class);
    }

    private Config createDefaultConfig() {
        return this.clusterConfiguration.getConfig();
    }

    public String getNamespace() {
        return this.clusterConfiguration.getNamespace();
    }

    public boolean isOpenShiftImageStream() {
        if (this.isOpenShift()) {
            try (OpenShiftClient client = this.createOpenShiftClient();){
                boolean bl = client.supportsOpenShiftAPIGroup("image.openshift.io");
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOpenShift() {
        try (KubernetesClient client = this.createKubernetesClient();){
            boolean throwable3 = OpenshiftHelper.isOpenShift((KubernetesClient)client);
            return throwable3;
        }
        catch (KubernetesClientException exp) {
            Throwable cause = exp.getCause();
            String prefix = cause instanceof UnknownHostException ? "Unknown host " : "";
            this.kitLogger.warn("Cannot access cluster for detecting mode: %s%s", new Object[]{prefix, cause != null ? cause.getMessage() : exp.getMessage()});
            return false;
        }
    }
}

