/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;

public class ResourceVersioning {
    private static final Map<String, Function<ResourceVersioning, String>> KIND_API_VERSION_MAPPINGS = new HashMap<String, Function<ResourceVersioning, String>>();
    private String coreVersion;
    private String extensionsVersion;
    private String appsVersion;
    private String networkingVersion;
    private String jobVersion;
    private String openshiftV1version;
    private String rbacVersion;
    private String cronJobVersion;
    private String apiExtensionsVersion;

    public String getForKind(String kind) {
        return KIND_API_VERSION_MAPPINGS.getOrDefault(kind, ResourceVersioning::getCoreVersion).apply(this);
    }

    @Generated
    public static ResourceVersioningBuilder builder() {
        return new ResourceVersioningBuilder();
    }

    @Generated
    public ResourceVersioning(String coreVersion, String extensionsVersion, String appsVersion, String networkingVersion, String jobVersion, String openshiftV1version, String rbacVersion, String cronJobVersion, String apiExtensionsVersion) {
        this.coreVersion = coreVersion;
        this.extensionsVersion = extensionsVersion;
        this.appsVersion = appsVersion;
        this.networkingVersion = networkingVersion;
        this.jobVersion = jobVersion;
        this.openshiftV1version = openshiftV1version;
        this.rbacVersion = rbacVersion;
        this.cronJobVersion = cronJobVersion;
        this.apiExtensionsVersion = apiExtensionsVersion;
    }

    @Generated
    public ResourceVersioning() {
    }

    @Generated
    public String getCoreVersion() {
        return this.coreVersion;
    }

    @Generated
    public String getExtensionsVersion() {
        return this.extensionsVersion;
    }

    @Generated
    public String getAppsVersion() {
        return this.appsVersion;
    }

    @Generated
    public String getNetworkingVersion() {
        return this.networkingVersion;
    }

    @Generated
    public String getJobVersion() {
        return this.jobVersion;
    }

    @Generated
    public String getOpenshiftV1version() {
        return this.openshiftV1version;
    }

    @Generated
    public String getRbacVersion() {
        return this.rbacVersion;
    }

    @Generated
    public String getCronJobVersion() {
        return this.cronJobVersion;
    }

    @Generated
    public String getApiExtensionsVersion() {
        return this.apiExtensionsVersion;
    }

    @Generated
    public void setCoreVersion(String coreVersion) {
        this.coreVersion = coreVersion;
    }

    @Generated
    public void setExtensionsVersion(String extensionsVersion) {
        this.extensionsVersion = extensionsVersion;
    }

    @Generated
    public void setAppsVersion(String appsVersion) {
        this.appsVersion = appsVersion;
    }

    @Generated
    public void setNetworkingVersion(String networkingVersion) {
        this.networkingVersion = networkingVersion;
    }

    @Generated
    public void setJobVersion(String jobVersion) {
        this.jobVersion = jobVersion;
    }

    @Generated
    public void setOpenshiftV1version(String openshiftV1version) {
        this.openshiftV1version = openshiftV1version;
    }

    @Generated
    public void setRbacVersion(String rbacVersion) {
        this.rbacVersion = rbacVersion;
    }

    @Generated
    public void setCronJobVersion(String cronJobVersion) {
        this.cronJobVersion = cronJobVersion;
    }

    @Generated
    public void setApiExtensionsVersion(String apiExtensionsVersion) {
        this.apiExtensionsVersion = apiExtensionsVersion;
    }

    @Generated
    public String toString() {
        return "ResourceVersioning(coreVersion=" + this.getCoreVersion() + ", extensionsVersion=" + this.getExtensionsVersion() + ", appsVersion=" + this.getAppsVersion() + ", networkingVersion=" + this.getNetworkingVersion() + ", jobVersion=" + this.getJobVersion() + ", openshiftV1version=" + this.getOpenshiftV1version() + ", rbacVersion=" + this.getRbacVersion() + ", cronJobVersion=" + this.getCronJobVersion() + ", apiExtensionsVersion=" + this.getApiExtensionsVersion() + ")";
    }

    static {
        KIND_API_VERSION_MAPPINGS.put("Ingress", ResourceVersioning::getExtensionsVersion);
        KIND_API_VERSION_MAPPINGS.put("StatefulSet", ResourceVersioning::getAppsVersion);
        KIND_API_VERSION_MAPPINGS.put("Deployment", ResourceVersioning::getAppsVersion);
        KIND_API_VERSION_MAPPINGS.put("NetworkPolicy", ResourceVersioning::getNetworkingVersion);
        KIND_API_VERSION_MAPPINGS.put("Job", ResourceVersioning::getJobVersion);
        KIND_API_VERSION_MAPPINGS.put("DeploymentConfig", ResourceVersioning::getOpenshiftV1version);
        KIND_API_VERSION_MAPPINGS.put("CronJob", ResourceVersioning::getCronJobVersion);
        KIND_API_VERSION_MAPPINGS.put("CustomResourceDefinition", ResourceVersioning::getApiExtensionsVersion);
        KIND_API_VERSION_MAPPINGS.put("ClusterRole", ResourceVersioning::getRbacVersion);
        KIND_API_VERSION_MAPPINGS.put("ClusterRoleBinding", ResourceVersioning::getRbacVersion);
        KIND_API_VERSION_MAPPINGS.put("Role", ResourceVersioning::getRbacVersion);
        KIND_API_VERSION_MAPPINGS.put("RoleBinding", ResourceVersioning::getRbacVersion);
    }

    @Generated
    public static class ResourceVersioningBuilder {
        @Generated
        private String coreVersion;
        @Generated
        private String extensionsVersion;
        @Generated
        private String appsVersion;
        @Generated
        private String networkingVersion;
        @Generated
        private String jobVersion;
        @Generated
        private String openshiftV1version;
        @Generated
        private String rbacVersion;
        @Generated
        private String cronJobVersion;
        @Generated
        private String apiExtensionsVersion;

        @Generated
        ResourceVersioningBuilder() {
        }

        @Generated
        public ResourceVersioningBuilder withCoreVersion(String coreVersion) {
            this.coreVersion = coreVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withExtensionsVersion(String extensionsVersion) {
            this.extensionsVersion = extensionsVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withAppsVersion(String appsVersion) {
            this.appsVersion = appsVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withNetworkingVersion(String networkingVersion) {
            this.networkingVersion = networkingVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withJobVersion(String jobVersion) {
            this.jobVersion = jobVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withOpenshiftV1version(String openshiftV1version) {
            this.openshiftV1version = openshiftV1version;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withRbacVersion(String rbacVersion) {
            this.rbacVersion = rbacVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withCronJobVersion(String cronJobVersion) {
            this.cronJobVersion = cronJobVersion;
            return this;
        }

        @Generated
        public ResourceVersioningBuilder withApiExtensionsVersion(String apiExtensionsVersion) {
            this.apiExtensionsVersion = apiExtensionsVersion;
            return this;
        }

        @Generated
        public ResourceVersioning build() {
            return new ResourceVersioning(this.coreVersion, this.extensionsVersion, this.appsVersion, this.networkingVersion, this.jobVersion, this.openshiftV1version, this.rbacVersion, this.cronJobVersion, this.apiExtensionsVersion);
        }

        @Generated
        public String toString() {
            return "ResourceVersioning.ResourceVersioningBuilder(coreVersion=" + this.coreVersion + ", extensionsVersion=" + this.extensionsVersion + ", appsVersion=" + this.appsVersion + ", networkingVersion=" + this.networkingVersion + ", jobVersion=" + this.jobVersion + ", openshiftV1version=" + this.openshiftV1version + ", rbacVersion=" + this.rbacVersion + ", cronJobVersion=" + this.cronJobVersion + ", apiExtensionsVersion=" + this.apiExtensionsVersion + ")";
        }
    }
}

