/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.Named;

public class ProcessorConfig {
    public static final ProcessorConfig EMPTY = new ProcessorConfig();
    private List<String> includes;
    private Set<String> excludes;
    private Map<String, Map<String, Object>> config;

    public ProcessorConfig() {
        this(null, null, null);
    }

    public ProcessorConfig(List<String> includes, Set<String> excludes, Map<String, Map<String, Object>> config) {
        this.includes = includes != null ? includes : new ArrayList();
        this.excludes = excludes != null ? excludes : new HashSet();
        this.config = config != null ? config : new HashMap();
    }

    public void setConfig(Map<String, TreeMap> config) {
        this.config = new HashMap<String, Map<String, Object>>();
        config.forEach((key, value) -> this.config.put((String)key, (Map<String, Object>)value));
    }

    public <T extends Named> List<T> prepareProcessors(List<T> namedList, String type) {
        ArrayList<Named> ret = new ArrayList<Named>();
        HashMap<String, Named> lookup = new HashMap<String, Named>();
        for (Named named : namedList) {
            lookup.put(named.getName(), named);
        }
        for (String inc : this.includes) {
            if (!this.use(inc)) continue;
            Named named = (Named)lookup.get(inc);
            if (named == null) {
                ArrayList keys = new ArrayList(lookup.keySet());
                keys.sort(Comparator.naturalOrder());
                throw new IllegalArgumentException("No " + type + " with name '" + inc + "' found to include. Please check spelling in your profile / config and your project dependencies. Included " + type + "s: " + StringUtils.join(keys, (String)", "));
            }
            ret.add(named);
        }
        return ret;
    }

    public boolean use(String inc) {
        return !this.excludes.contains(inc) && this.includes.contains(inc);
    }

    public static ProcessorConfig cloneProcessorConfig(ProcessorConfig processorConfig) {
        return ProcessorConfig.mergeProcessorConfigs(processorConfig);
    }

    public static String getConfigValue(ProcessorConfig config, String configName, String propertyPrefix, Properties properties, Configs.Config key, String defaultValue) {
        Object configValue;
        Object object = configValue = config != null ? config.getConfig(configName, key) : null;
        if (configValue != null) {
            return configValue.toString();
        }
        String fullKey = String.format("%s.%s.%s", propertyPrefix, configName, key.getKey());
        String valueInProperties = Configs.getFromSystemPropertyWithPropertiesAsFallback((Properties)properties, (String)fullKey);
        if (valueInProperties != null) {
            return valueInProperties;
        }
        return defaultValue != null ? defaultValue : key.getDefaultValue();
    }

    private Object getConfig(String configName, Configs.Config key) {
        return Optional.ofNullable(this.config).map(c -> (Map)c.get(configName)).map(entries -> entries.get(key.getKey())).orElse(null);
    }

    public static ProcessorConfig mergeProcessorConfigs(ProcessorConfig ... processorConfigs) {
        Map<String, Map<String, Object>> configs = ProcessorConfig.mergeConfig(processorConfigs);
        Set<String> excludes = ProcessorConfig.mergeExcludes(processorConfigs);
        List<String> includes = ProcessorConfig.mergeIncludes(processorConfigs);
        return new ProcessorConfig(includes, excludes, configs);
    }

    private static Set<String> mergeExcludes(ProcessorConfig ... configs) {
        return Stream.of(configs).filter(Objects::nonNull).map(ProcessorConfig::getExcludes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static List<String> mergeIncludes(ProcessorConfig ... configs) {
        return Stream.of(configs).filter(Objects::nonNull).map(ProcessorConfig::getIncludes).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @Nonnull
    private static Map<String, Map<String, Object>> mergeConfig(ProcessorConfig ... processorConfigs) {
        HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>();
        Predicate<Map.Entry> nonNullEntry = e -> e.getKey() != null && e.getValue() != null;
        IntStream.rangeClosed(1, processorConfigs.length).mapToObj(i -> processorConfigs[processorConfigs.length - i]).filter(Objects::nonNull).map(ProcessorConfig::getConfig).map(Map::entrySet).flatMap(Collection::stream).filter(nonNullEntry).forEach(configEntry -> {
            Map existingConfigEntry = ret.computeIfAbsent((String)configEntry.getKey(), k -> new HashMap());
            ((Map)configEntry.getValue()).entrySet().stream().filter(nonNullEntry).forEach(e -> existingConfigEntry.put(e.getKey(), e.getValue()));
        });
        return ret;
    }

    @Generated
    public List<String> getIncludes() {
        return this.includes;
    }

    @Generated
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Generated
    public Map<String, Map<String, Object>> getConfig() {
        return this.config;
    }

    @Generated
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Generated
    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessorConfig)) {
            return false;
        }
        ProcessorConfig other = (ProcessorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$includes = this.getIncludes();
        List<String> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        Set<String> this$excludes = this.getExcludes();
        Set<String> other$excludes = other.getExcludes();
        if (this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes)) {
            return false;
        }
        Map<String, Map<String, Object>> this$config = this.getConfig();
        Map<String, Map<String, Object>> other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        Set<String> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        Map<String, Map<String, Object>> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }
}

