/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

import java.io.File;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.ResourceService;

public class ResourceServiceConfig {
    private JavaProject project;
    private File resourceDir;
    private File targetDir;
    private ResourceFileType resourceFileType;
    private ResourceConfig resourceConfig;
    private ResourceService.ResourceFileProcessor resourceFilesProcessor;
    private boolean interpolateTemplateParameters;

    public static ResourceServiceConfigBuilder builder() {
        return new ResourceServiceConfigBuilder();
    }

    public ResourceServiceConfigBuilder toBuilder() {
        return new ResourceServiceConfigBuilder().project(this.project).resourceDir(this.resourceDir).targetDir(this.targetDir).resourceFileType(this.resourceFileType).resourceConfig(this.resourceConfig).resourceFilesProcessor(this.resourceFilesProcessor).interpolateTemplateParameters(this.interpolateTemplateParameters);
    }

    public ResourceServiceConfig(JavaProject project, File resourceDir, File targetDir, ResourceFileType resourceFileType, ResourceConfig resourceConfig, ResourceService.ResourceFileProcessor resourceFilesProcessor, boolean interpolateTemplateParameters) {
        this.project = project;
        this.resourceDir = resourceDir;
        this.targetDir = targetDir;
        this.resourceFileType = resourceFileType;
        this.resourceConfig = resourceConfig;
        this.resourceFilesProcessor = resourceFilesProcessor;
        this.interpolateTemplateParameters = interpolateTemplateParameters;
    }

    public ResourceServiceConfig() {
    }

    public JavaProject getProject() {
        return this.project;
    }

    public File getResourceDir() {
        return this.resourceDir;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public ResourceFileType getResourceFileType() {
        return this.resourceFileType;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public ResourceService.ResourceFileProcessor getResourceFilesProcessor() {
        return this.resourceFilesProcessor;
    }

    public boolean isInterpolateTemplateParameters() {
        return this.interpolateTemplateParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceServiceConfig)) {
            return false;
        }
        ResourceServiceConfig other = (ResourceServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInterpolateTemplateParameters() != other.isInterpolateTemplateParameters()) {
            return false;
        }
        JavaProject this$project = this.getProject();
        JavaProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        File this$resourceDir = this.getResourceDir();
        File other$resourceDir = other.getResourceDir();
        if (this$resourceDir == null ? other$resourceDir != null : !((Object)this$resourceDir).equals(other$resourceDir)) {
            return false;
        }
        File this$targetDir = this.getTargetDir();
        File other$targetDir = other.getTargetDir();
        if (this$targetDir == null ? other$targetDir != null : !((Object)this$targetDir).equals(other$targetDir)) {
            return false;
        }
        ResourceFileType this$resourceFileType = this.getResourceFileType();
        ResourceFileType other$resourceFileType = other.getResourceFileType();
        if (this$resourceFileType == null ? other$resourceFileType != null : !this$resourceFileType.equals(other$resourceFileType)) {
            return false;
        }
        ResourceConfig this$resourceConfig = this.getResourceConfig();
        ResourceConfig other$resourceConfig = other.getResourceConfig();
        if (this$resourceConfig == null ? other$resourceConfig != null : !((Object)this$resourceConfig).equals(other$resourceConfig)) {
            return false;
        }
        ResourceService.ResourceFileProcessor this$resourceFilesProcessor = this.getResourceFilesProcessor();
        ResourceService.ResourceFileProcessor other$resourceFilesProcessor = other.getResourceFilesProcessor();
        return !(this$resourceFilesProcessor == null ? other$resourceFilesProcessor != null : !this$resourceFilesProcessor.equals(other$resourceFilesProcessor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInterpolateTemplateParameters() ? 79 : 97);
        JavaProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        File $resourceDir = this.getResourceDir();
        result = result * 59 + ($resourceDir == null ? 43 : ((Object)$resourceDir).hashCode());
        File $targetDir = this.getTargetDir();
        result = result * 59 + ($targetDir == null ? 43 : ((Object)$targetDir).hashCode());
        ResourceFileType $resourceFileType = this.getResourceFileType();
        result = result * 59 + ($resourceFileType == null ? 43 : $resourceFileType.hashCode());
        ResourceConfig $resourceConfig = this.getResourceConfig();
        result = result * 59 + ($resourceConfig == null ? 43 : ((Object)$resourceConfig).hashCode());
        ResourceService.ResourceFileProcessor $resourceFilesProcessor = this.getResourceFilesProcessor();
        result = result * 59 + ($resourceFilesProcessor == null ? 43 : $resourceFilesProcessor.hashCode());
        return result;
    }

    public static class ResourceServiceConfigBuilder {
        private JavaProject project;
        private File resourceDir;
        private File targetDir;
        private ResourceFileType resourceFileType;
        private ResourceConfig resourceConfig;
        private ResourceService.ResourceFileProcessor resourceFilesProcessor;
        private boolean interpolateTemplateParameters;

        ResourceServiceConfigBuilder() {
        }

        public ResourceServiceConfigBuilder project(JavaProject project) {
            this.project = project;
            return this;
        }

        public ResourceServiceConfigBuilder resourceDir(File resourceDir) {
            this.resourceDir = resourceDir;
            return this;
        }

        public ResourceServiceConfigBuilder targetDir(File targetDir) {
            this.targetDir = targetDir;
            return this;
        }

        public ResourceServiceConfigBuilder resourceFileType(ResourceFileType resourceFileType) {
            this.resourceFileType = resourceFileType;
            return this;
        }

        public ResourceServiceConfigBuilder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public ResourceServiceConfigBuilder resourceFilesProcessor(ResourceService.ResourceFileProcessor resourceFilesProcessor) {
            this.resourceFilesProcessor = resourceFilesProcessor;
            return this;
        }

        public ResourceServiceConfigBuilder interpolateTemplateParameters(boolean interpolateTemplateParameters) {
            this.interpolateTemplateParameters = interpolateTemplateParameters;
            return this;
        }

        public ResourceServiceConfig build() {
            return new ResourceServiceConfig(this.project, this.resourceDir, this.targetDir, this.resourceFileType, this.resourceConfig, this.resourceFilesProcessor, this.interpolateTemplateParameters);
        }

        public String toString() {
            return "ResourceServiceConfig.ResourceServiceConfigBuilder(project=" + this.project + ", resourceDir=" + this.resourceDir + ", targetDir=" + this.targetDir + ", resourceFileType=" + this.resourceFileType + ", resourceConfig=" + this.resourceConfig + ", resourceFilesProcessor=" + this.resourceFilesProcessor + ", interpolateTemplateParameters=" + this.interpolateTemplateParameters + ")";
        }
    }
}

