/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.service.ArtifactResolverService;
import org.eclipse.jkube.kit.common.service.MigrateService;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.access.ClusterConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeArtifactResolverService;
import org.eclipse.jkube.kit.config.service.kubernetes.DockerBuildService;
import org.eclipse.jkube.kit.config.service.kubernetes.JibBuildService;
import org.eclipse.jkube.kit.config.service.openshift.OpenshiftBuildService;

public class JKubeServiceHub
implements Closeable {
    private JKubeConfiguration configuration;
    private ClusterAccess clusterAccess;
    private RuntimeMode platformMode;
    private KitLogger log;
    private ServiceHub dockerServiceHub;
    private BuildServiceConfig buildServiceConfig;
    private KubernetesClient client;
    private LazyBuilder<ArtifactResolverService> artifactResolverService;
    private LazyBuilder<BuildService> buildService;
    private LazyBuilder<ApplyService> applyService;
    private LazyBuilder<MigrateService> migrateService;

    public JKubeServiceHub(ClusterAccess clusterAccess, RuntimeMode platformMode, KitLogger log, ServiceHub dockerServiceHub, JKubeConfiguration configuration, BuildServiceConfig buildServiceConfig) {
        this.clusterAccess = clusterAccess;
        this.platformMode = platformMode;
        this.log = log;
        this.dockerServiceHub = dockerServiceHub;
        this.configuration = configuration;
        this.buildServiceConfig = buildServiceConfig;
        this.init();
    }

    private void init() {
        Objects.requireNonNull(this.configuration, "JKubeKitConfiguration is required");
        Objects.requireNonNull(this.log, "log is a required parameter");
        Objects.requireNonNull(this.platformMode, "platformMode is a required parameter");
        if (this.clusterAccess == null) {
            this.clusterAccess = new ClusterAccess(this.log, ClusterConfiguration.from((Properties[])new Properties[]{System.getProperties(), this.configuration.getProject().getProperties()}).build());
        }
        this.client = this.clusterAccess.createDefaultClient();
        this.applyService = new LazyBuilder(() -> new ApplyService(this.client, this.log));
        this.buildService = new LazyBuilder(() -> {
            BuildService ret;
            String jkubeBuildStrategy = (String)this.configuration.getProperties().get("jkube.build.strategy");
            if (jkubeBuildStrategy != null && jkubeBuildStrategy.equalsIgnoreCase(JKubeBuildStrategy.jib.getLabel())) {
                return new JibBuildService(this, this.log);
            }
            if (this.platformMode == RuntimeMode.OPENSHIFT) {
                if (!(this.client instanceof OpenShiftClient)) {
                    throw new IllegalStateException("OpenShift platform has been specified but OpenShift has not been detected!");
                }
                ret = new OpenshiftBuildService((OpenShiftClient)this.client, this.log, this);
            } else {
                ret = new DockerBuildService(this);
            }
            return ret;
        });
        this.artifactResolverService = new LazyBuilder(() -> new JKubeArtifactResolverService(this.configuration.getProject()));
        this.migrateService = new LazyBuilder(() -> new MigrateService(this.getConfiguration().getBasedir(), this.log));
    }

    @Override
    public void close() {
        Optional.ofNullable(this.client).ifPresent(Client::close);
        Optional.ofNullable(this.dockerServiceHub).map(ServiceHub::getDockerAccess).ifPresent(DockerAccess::shutdown);
    }

    public RuntimeMode getRuntimeMode() {
        return this.platformMode;
    }

    public ArtifactResolverService getArtifactResolverService() {
        return (ArtifactResolverService)this.artifactResolverService.get();
    }

    public BuildService getBuildService() {
        return (BuildService)this.buildService.get();
    }

    public ApplyService getApplyService() {
        return (ApplyService)this.applyService.get();
    }

    public MigrateService getMigrateService() {
        return (MigrateService)this.migrateService.get();
    }

    public static JKubeServiceHubBuilder builder() {
        return new JKubeServiceHubBuilder();
    }

    public JKubeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ClusterAccess getClusterAccess() {
        return this.clusterAccess;
    }

    public RuntimeMode getPlatformMode() {
        return this.platformMode;
    }

    public void setPlatformMode(RuntimeMode platformMode) {
        this.platformMode = platformMode;
    }

    public ServiceHub getDockerServiceHub() {
        return this.dockerServiceHub;
    }

    public BuildServiceConfig getBuildServiceConfig() {
        return this.buildServiceConfig;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public static class JKubeServiceHubBuilder {
        private ClusterAccess clusterAccess;
        private RuntimeMode platformMode;
        private KitLogger log;
        private ServiceHub dockerServiceHub;
        private JKubeConfiguration configuration;
        private BuildServiceConfig buildServiceConfig;

        JKubeServiceHubBuilder() {
        }

        public JKubeServiceHubBuilder clusterAccess(ClusterAccess clusterAccess) {
            this.clusterAccess = clusterAccess;
            return this;
        }

        public JKubeServiceHubBuilder platformMode(RuntimeMode platformMode) {
            this.platformMode = platformMode;
            return this;
        }

        public JKubeServiceHubBuilder log(KitLogger log) {
            this.log = log;
            return this;
        }

        public JKubeServiceHubBuilder dockerServiceHub(ServiceHub dockerServiceHub) {
            this.dockerServiceHub = dockerServiceHub;
            return this;
        }

        public JKubeServiceHubBuilder configuration(JKubeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public JKubeServiceHubBuilder buildServiceConfig(BuildServiceConfig buildServiceConfig) {
            this.buildServiceConfig = buildServiceConfig;
            return this;
        }

        public JKubeServiceHub build() {
            return new JKubeServiceHub(this.clusterAccess, this.platformMode, this.log, this.dockerServiceHub, this.configuration, this.buildServiceConfig);
        }

        public String toString() {
            return "JKubeServiceHub.JKubeServiceHubBuilder(clusterAccess=" + this.clusterAccess + ", platformMode=" + this.platformMode + ", log=" + this.log + ", dockerServiceHub=" + this.dockerServiceHub + ", configuration=" + this.configuration + ", buildServiceConfig=" + this.buildServiceConfig + ")";
        }
    }
}

