/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.PodHelper;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.config.service.PortForwardService;
import org.eclipse.jkube.kit.config.service.portforward.PortForwardPodWatcher;

public class DebugService {
    public static final String DEBUG_ENV_VARS_UPDATE_MESSAGE = "Updating %s %s with Debug variables in containers";
    private final KitLogger log;
    private final KubernetesClient kubernetesClient;
    private final PortForwardService portForwardService;
    private final ApplyService applyService;
    private String debugSuspendValue;
    private String remoteDebugPort = "5005";

    public DebugService(KitLogger log, KubernetesClient kubernetesClient, PortForwardService portForwardService, ApplyService applyService) {
        this.log = log;
        this.kubernetesClient = kubernetesClient;
        this.portForwardService = portForwardService;
        this.applyService = applyService;
    }

    public void debug(String namespace, String fileName, Set<HasMetadata> entities, String localDebugPort, boolean debugSuspend, KitLogger podWaitLog) {
        if (!this.isDebugApplicable(entities)) {
            this.log.error("Unable to proceed with Debug. No application resource found running in the cluster", new Object[0]);
            return;
        }
        LabelSelector firstSelector = null;
        for (HasMetadata entity : entities) {
            if (firstSelector == null) {
                firstSelector = KubernetesHelper.extractPodLabelSelector((HasMetadata)entity);
            }
            this.enableDebugging(entity, fileName, debugSuspend);
        }
        if (firstSelector == null) {
            this.log.error("Debug is not applicable for the currently generated resources", new Object[0]);
            return;
        }
        this.startPortForward(firstSelector, namespace, debugSuspend, localDebugPort, podWaitLog);
    }

    private boolean isDebugApplicable(Set<HasMetadata> entities) {
        boolean controllersApplied = !entities.isEmpty();
        for (HasMetadata h : entities) {
            if (!KubernetesHelper.isControllerResource((HasMetadata)h)) continue;
            boolean isApplied = this.applyService.isAlreadyApplied(h);
            if (!isApplied) {
                this.log.warn("%s %s not applied, Did you forget to deploy your application?", new Object[]{h.getKind(), h.getMetadata().getName()});
            }
            controllersApplied &= this.applyService.isAlreadyApplied(h);
        }
        return controllersApplied;
    }

    private void startPortForward(LabelSelector firstSelector, String namespace, boolean debugSuspend, String localDebugPort, KitLogger podWaitLog) {
        if (firstSelector != null) {
            Map<String, String> envVars = this.initDebugEnvVarsMap(debugSuspend);
            String podName = this.waitForRunningPodWithEnvVar(namespace, firstSelector, envVars, podWaitLog);
            this.portForwardService.startPortForward(podName, namespace, this.portToInt(this.remoteDebugPort, "remoteDebugPort"), this.portToInt(localDebugPort, "localDebugPort"));
        }
    }

    Map<String, String> initDebugEnvVarsMap(boolean debugSuspend) {
        TreeMap<String, String> envVars = new TreeMap<String, String>();
        envVars.put("JAVA_ENABLE_DEBUG", "true");
        envVars.put("JAVA_DEBUG_SUSPEND", String.valueOf(debugSuspend));
        if (this.debugSuspendValue != null) {
            envVars.put("JAVA_DEBUG_SESSION", this.debugSuspendValue);
        }
        return envVars;
    }

    void enableDebugging(HasMetadata entity, String fileName, boolean debugSuspend) {
        if (entity instanceof Deployment) {
            this.enableDebugging((Deployment)entity, fileName, debugSuspend);
        } else if (entity instanceof ReplicaSet) {
            this.enableDebugging((ReplicaSet)entity, fileName, debugSuspend);
        } else if (entity instanceof ReplicationController) {
            this.enableDebugging((ReplicationController)entity, fileName, debugSuspend);
        } else if (entity instanceof DeploymentConfig) {
            this.enableDebugging((DeploymentConfig)entity, fileName, debugSuspend);
        }
    }

    private Consumer<PodTemplateSpec> applyEntity(HasMetadata entity, String fileName) {
        return template -> {
            this.log.info(DEBUG_ENV_VARS_UPDATE_MESSAGE, new Object[]{entity.getKind(), entity.getMetadata().getName()});
            this.applyService.apply(entity, fileName);
        };
    }

    private Predicate<PodTemplateSpec> enableDebuggingFilterFunc(HasMetadata entity, boolean debugSuspend) {
        return pts -> this.enableDebugging(entity, (PodTemplateSpec)pts, debugSuspend);
    }

    private boolean isDebugAlreadyEnabled(ReplicationController entity, boolean debugSuspend) {
        return PodHelper.firstContainerHasEnvVars((List)((ReplicationController)((Gettable)this.kubernetesClient.resource((HasMetadata)entity).fromServer()).get()).getSpec().getTemplate().getSpec().getContainers(), this.initDebugEnvVarsMap(debugSuspend));
    }

    private boolean isDebugAlreadyEnabled(DeploymentConfig entity, boolean debugSuspend) {
        return PodHelper.firstContainerHasEnvVars((List)((DeploymentConfig)((Gettable)this.kubernetesClient.resource((HasMetadata)entity).fromServer()).get()).getSpec().getTemplate().getSpec().getContainers(), this.initDebugEnvVarsMap(debugSuspend));
    }

    private void enableDebugging(ReplicationController entity, String fileName, boolean debugSuspend) {
        Optional.ofNullable(entity).map(ReplicationController::getSpec).map(ReplicationControllerSpec::getTemplate).filter(this.enableDebuggingFilterFunc((HasMetadata)entity, debugSuspend)).filter(pts -> !this.isDebugAlreadyEnabled(entity, debugSuspend)).ifPresent(this.applyEntity((HasMetadata)entity, fileName));
    }

    private void enableDebugging(ReplicaSet entity, String fileName, boolean debugSuspend) {
        Optional.ofNullable(entity).map(ReplicaSet::getSpec).map(ReplicaSetSpec::getTemplate).filter(this.enableDebuggingFilterFunc((HasMetadata)entity, debugSuspend)).ifPresent(this.applyEntity((HasMetadata)entity, fileName));
    }

    private void enableDebugging(Deployment entity, String fileName, boolean debugSuspend) {
        Optional.ofNullable(entity).map(Deployment::getSpec).map(DeploymentSpec::getTemplate).filter(this.enableDebuggingFilterFunc((HasMetadata)entity, debugSuspend)).ifPresent(this.applyEntity((HasMetadata)entity, fileName));
    }

    private void enableDebugging(DeploymentConfig entity, String fileName, boolean debugSuspend) {
        Optional.ofNullable(entity).map(DeploymentConfig::getSpec).map(DeploymentConfigSpec::getTemplate).filter(this.enableDebuggingFilterFunc((HasMetadata)entity, debugSuspend)).filter(pts -> !this.isDebugAlreadyEnabled(entity, debugSuspend)).ifPresent(this.applyEntity((HasMetadata)entity, fileName));
    }

    private String waitForRunningPodWithEnvVar(String namespace, LabelSelector selector, Map<String, String> envVars, KitLogger podWaitLog) {
        Pod latestPod;
        FilterWatchListDeletable pods = KubernetesHelper.withSelector((NonNamespaceOperation)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)), (LabelSelector)selector, (KitLogger)this.log);
        PodList list = (PodList)pods.list();
        if (list != null && (latestPod = KubernetesHelper.getNewestPod((Collection)list.getItems())) != null && PodHelper.firstContainerHasEnvVars((Pod)latestPod, envVars) && KubernetesHelper.isPodRunning((Pod)latestPod)) {
            this.log.info("Debug Pod ready: %s", new Object[]{latestPod.getMetadata().getName()});
            return KubernetesHelper.getName((HasMetadata)latestPod);
        }
        PortForwardPodWatcher portForwardPodWatcher = new PortForwardPodWatcher(podWaitLog, envVars);
        this.log.info("No Active debug pod with provided selector and environment variables found! Waiting for pod to be ready...", new Object[0]);
        this.log.info("Waiting for debug pod with selector " + selector + " and environment variables " + envVars, new Object[0]);
        pods.watch((Object)portForwardPodWatcher);
        while (portForwardPodWatcher.getPodReadyLatch().getCount() > 0L) {
            try {
                portForwardPodWatcher.getPodReadyLatch().await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (portForwardPodWatcher.getFoundPod() == null) continue;
            return KubernetesHelper.getName((HasMetadata)portForwardPodWatcher.getFoundPod());
        }
        throw new IllegalStateException("Could not find a running pod with environment variables " + envVars);
    }

    private boolean enableDebugging(HasMetadata entity, PodTemplateSpec template, boolean debugSuspend) {
        PodSpec podSpec;
        if (template != null && (podSpec = template.getSpec()) != null) {
            List containers = podSpec.getContainers();
            boolean enabled = false;
            for (Container container : containers) {
                enabled |= this.setDebugEnvVar(container, debugSuspend);
                enabled |= this.addDebugContainerPort(container);
                enabled |= this.handleDebugSuspendEnvVar(container, debugSuspend, entity);
            }
            if (enabled) {
                this.log.info("Enabling debug on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
                return true;
            }
        }
        return false;
    }

    private boolean addDebugContainerPort(Container container) {
        ContainerPort port;
        ArrayList<ContainerPort> ports = container.getPorts();
        boolean enabled = false;
        if (ports == null) {
            ports = new ArrayList<ContainerPort>();
        }
        if (!KubernetesHelper.containsPort(ports, (String)this.remoteDebugPort) && (port = KubernetesHelper.addPort((String)this.remoteDebugPort, (String)"debug", (KitLogger)this.log)) != null) {
            ports.add(port);
            container.setPorts(ports);
            enabled = true;
        }
        return enabled;
    }

    private boolean setDebugEnvVar(Container container, boolean debugSuspend) {
        ArrayList env = container.getEnv();
        boolean enabled = false;
        if (env == null) {
            env = new ArrayList();
        }
        this.remoteDebugPort = KubernetesHelper.getEnvVar(env, (String)"JAVA_DEBUG_PORT", (String)"5005");
        if (KubernetesHelper.setEnvVar(env, (String)"JAVA_ENABLE_DEBUG", (String)"true")) {
            container.setEnv(env);
            enabled = true;
        }
        if (KubernetesHelper.setEnvVar(env, (String)"JAVA_DEBUG_SUSPEND", (String)String.valueOf(debugSuspend))) {
            container.setEnv(env);
            enabled = true;
        }
        return enabled;
    }

    private boolean handleDebugSuspendEnvVar(Container container, boolean debugSuspend, HasMetadata entity) {
        List env = container.getEnv();
        if (debugSuspend) {
            this.debugSuspendValue = String.valueOf(new SecureRandom().nextLong());
            KubernetesHelper.setEnvVar((List)env, (String)"JAVA_DEBUG_SESSION", (String)this.debugSuspendValue);
            container.setEnv(env);
            if (container.getReadinessProbe() != null) {
                this.log.info("Readiness probe will be disabled on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " to allow attaching a remote debugger during suspension", new Object[0]);
                container.setReadinessProbe(null);
            }
            return true;
        }
        if (KubernetesHelper.removeEnvVar((List)env, (String)"JAVA_DEBUG_SESSION")) {
            container.setEnv(env);
            return true;
        }
        return false;
    }

    private int portToInt(String port, String name) {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid port value: " + name + "=" + port);
        }
    }
}

