/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.RegistryConfig;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;

public class DockerBuildService
implements BuildService {
    private JKubeServiceHub jKubeServiceHub;

    public DockerBuildService(JKubeServiceHub jKubeServiceHub) {
        Objects.requireNonNull(jKubeServiceHub.getDockerServiceHub(), "dockerServiceHub");
        Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.jKubeServiceHub = jKubeServiceHub;
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws JKubeServiceException {
        try {
            this.jKubeServiceHub.getDockerServiceHub().getBuildService().buildImage(imageConfig, this.jKubeServiceHub.getBuildServiceConfig().getImagePullManager(), this.jKubeServiceHub.getConfiguration());
            this.jKubeServiceHub.getDockerServiceHub().getBuildService().tagImage(imageConfig.getName(), imageConfig);
        }
        catch (IOException ex) {
            throw new JKubeServiceException("Error while trying to build the image: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void push(Collection<ImageConfiguration> imageConfigs, int retries, RegistryConfig registryConfig, boolean skipTag) throws JKubeServiceException {
        try {
            this.jKubeServiceHub.getDockerServiceHub().getRegistryService().pushImages(imageConfigs, retries, registryConfig, skipTag);
        }
        catch (IOException ex) {
            throw new JKubeServiceException("Error while trying to push the image: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void postProcess(BuildServiceConfig config) {
    }
}

