/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.openshift;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.assembly.ArchiverCustomizer;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.RegistryConfig;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.image.build.JKubeConfiguration;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.openshift.ImageStreamService;

public class OpenshiftBuildService
implements BuildService {
    private static final String DEFAULT_S2I_BUILD_SUFFIX = "-s2i";
    public static final String DEFAULT_S2I_SOURCE_TYPE = "Binary";
    public static final String REQUESTS = "requests";
    public static final String LIMITS = "limits";
    private final OpenShiftClient client;
    private final KitLogger log;
    private final JKubeServiceHub jKubeServiceHub;
    private final BuildServiceConfig config;
    private AuthConfigFactory authConfigFactory;

    public OpenshiftBuildService(OpenShiftClient client, KitLogger log, JKubeServiceHub jKubeServiceHub) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(log, "log");
        Objects.requireNonNull(jKubeServiceHub.getConfiguration(), "JKubeConfiguration");
        Objects.requireNonNull(jKubeServiceHub.getDockerServiceHub(), "dockerServiceHub");
        Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "config");
        this.client = client;
        this.log = log;
        this.jKubeServiceHub = jKubeServiceHub;
        this.config = jKubeServiceHub.getBuildServiceConfig();
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws JKubeServiceException {
        String buildName = null;
        try {
            ImageName imageName = new ImageName(imageConfig.getName());
            File dockerTar = this.createBuildArchive(imageConfig);
            KubernetesListBuilder builder = new KubernetesListBuilder();
            String openshiftPullSecret = this.config.getOpenshiftPullSecret();
            boolean usePullSecret = this.checkOrCreatePullSecret(this.client, builder, openshiftPullSecret, imageConfig);
            buildName = usePullSecret ? this.updateOrCreateBuildConfig(this.config, this.client, builder, imageConfig, openshiftPullSecret) : this.updateOrCreateBuildConfig(this.config, this.client, builder, imageConfig, null);
            this.checkOrCreateImageStream(this.config, this.client, builder, this.getImageStreamName(imageName));
            this.applyResourceObjects(this.config, this.client, builder);
            Build build = this.startBuild(this.client, dockerTar, buildName);
            this.waitForOpenShiftBuildToComplete(this.client, build);
            this.addImageStreamToFile(this.getImageStreamFile(), imageName, this.client);
        }
        catch (JKubeServiceException e) {
            throw e;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IOException) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, ex.getCause().getMessage()});
                this.logBuildFailure(this.client, buildName);
            }
            throw new JKubeServiceException("Unable to build the image using the OpenShift build service", ex);
        }
    }

    @Override
    public void push(Collection<ImageConfiguration> imageConfigs, int retries, RegistryConfig registryConfig, boolean skipTag) throws JKubeServiceException {
        this.log.warn("Image is pushed to OpenShift's internal registry during oc:build goal. Skipping...", new Object[0]);
    }

    protected File createBuildArchive(ImageConfiguration imageConfig) throws JKubeServiceException {
        ArchiverCustomizer customizer = this.getS2ICustomizer(imageConfig);
        try {
            return this.jKubeServiceHub.getDockerServiceHub().getArchiveService().createDockerBuildArchive(imageConfig, this.jKubeServiceHub.getConfiguration(), customizer);
        }
        catch (IOException e) {
            throw new JKubeServiceException("Unable to create the build archive", e);
        }
    }

    private ArchiverCustomizer getS2ICustomizer(ImageConfiguration imageConfiguration) throws JKubeServiceException {
        try {
            if (imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getEnv() != null) {
                String fileName = IoUtil.sanitizeFileName((String)("s2i-env-" + imageConfiguration.getName()));
                File environmentFile = new File(this.config.getBuildDirectory(), fileName);
                try (PrintWriter out = new PrintWriter(new FileWriter(environmentFile));){
                    for (Map.Entry e : imageConfiguration.getBuildConfiguration().getEnv().entrySet()) {
                        out.println((String)e.getKey() + "=" + (String)e.getValue());
                    }
                }
                return tarArchiver -> {
                    tarArchiver.includeFile(environmentFile, ".s2i/environment");
                    return tarArchiver;
                };
            }
            return null;
        }
        catch (IOException e) {
            throw new JKubeServiceException("Unable to add environment variables to the S2I build archive", e);
        }
    }

    private File getImageStreamFile() {
        return ResourceFileType.yaml.addExtensionIfMissing(new File(this.config.getBuildDirectory(), String.format("%s-is", this.jKubeServiceHub.getConfiguration().getProject().getArtifactId())));
    }

    @Override
    public void postProcess(BuildServiceConfig config) {
        config.attachArtifact("is", this.getImageStreamFile());
    }

    protected String updateOrCreateBuildConfig(BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig, String openshiftPullSecret) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = this.getS2IBuildName(config, imageName);
        String imageStreamName = this.getImageStreamName(imageName);
        String outputImageStreamTag = imageStreamName + ":" + (imageName.getTag() != null ? imageName.getTag() : "latest");
        BuildStrategy buildStrategyResource = this.createBuildStrategy(imageConfig, config.getJKubeBuildStrategy(), openshiftPullSecret);
        BuildOutput buildOutput = ((BuildOutputBuilder)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)new BuildOutputBuilder().withNewTo().withKind("ImageStreamTag")).withName(outputImageStreamTag)).endTo()).build();
        BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).get();
        if (buildConfig != null) {
            BuildConfigSpec spec = this.getBuildConfigSpec(buildConfig);
            this.validateSourceType(buildName, spec);
            if (config.getBuildRecreateMode().isBuildConfig()) {
                ((BuildConfigResource)client.buildConfigs().withName(buildName)).delete();
                return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
            }
            return this.updateBuildConfig(client, buildName, buildStrategyResource, buildOutput, spec);
        }
        return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
    }

    private void validateSourceType(String buildName, BuildConfigSpec spec) {
        String sourceType;
        BuildSource source = spec.getSource();
        if (source != null && !Objects.equals(DEFAULT_S2I_SOURCE_TYPE, sourceType = source.getType())) {
            this.log.warn("BuildServiceConfig %s is not of type: 'Binary' but is '%s' !", new Object[]{buildName, sourceType});
        }
    }

    private BuildConfigSpec getBuildConfigSpec(BuildConfig buildConfig) {
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        return spec;
    }

    private BuildConfigSpec getBuildConfigSpec(BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        Map<String, Map<String, Quantity>> requestsLimitsMap;
        BuildConfigSpecBuilder specBuilder = null;
        File buildConfigResourceFragment = KubernetesHelper.getResourceFragmentFromSource((File)this.config.getResourceDir(), (List)(this.config.getResourceConfig() != null ? this.config.getResourceConfig().getRemotes() : null), (String)"buildconfig.yml", (KitLogger)this.log);
        if (buildConfigResourceFragment != null) {
            BuildConfig buildConfigFragment = (BuildConfig)((BuildConfigResource)this.client.buildConfigs().load(buildConfigResourceFragment)).get();
            specBuilder = new BuildConfigSpecBuilder(buildConfigFragment.getSpec());
        } else {
            specBuilder = new BuildConfigSpecBuilder();
        }
        if (specBuilder.buildSource() == null) {
            ((BuildConfigSpecFluent.SourceNested)specBuilder.withNewSource().withType(DEFAULT_S2I_SOURCE_TYPE)).endSource();
        }
        if (specBuilder.buildStrategy() == null) {
            specBuilder.withStrategy(buildStrategyResource);
        }
        if (specBuilder.buildOutput() == null) {
            specBuilder.withOutput(buildOutput);
        }
        if ((requestsLimitsMap = this.getRequestsAndLimits()).containsKey(REQUESTS)) {
            ((BuildConfigSpecFluent.ResourcesNested)specBuilder.editOrNewResources().addToRequests(requestsLimitsMap.get(REQUESTS))).endResources();
        }
        if (requestsLimitsMap.containsKey(LIMITS)) {
            ((BuildConfigSpecFluent.ResourcesNested)specBuilder.editOrNewResources().addToLimits(requestsLimitsMap.get(LIMITS))).endResources();
        }
        return specBuilder.build();
    }

    private String createBuildConfig(KubernetesListBuilder builder, String buildName, BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        this.log.info("Creating BuildServiceConfig %s for %s build", new Object[]{buildName, buildStrategyResource.getType()});
        builder.addToItems(new HasMetadata[]{((BuildConfigBuilder)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(buildName)).endMetadata()).withSpec(this.getBuildConfigSpec(buildStrategyResource, buildOutput))).build()});
        return buildName;
    }

    private String updateBuildConfig(OpenShiftClient client, String buildName, BuildStrategy buildStrategy, BuildOutput buildOutput, BuildConfigSpec spec) {
        if (!Objects.equals(buildStrategy, spec.getStrategy()) || !Objects.equals(buildOutput, spec.getOutput())) {
            ((BuildConfigResource)client.buildConfigs().withName(buildName)).edit(bc -> ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)new BuildConfigBuilder(bc).editSpec().withStrategy(buildStrategy)).withOutput(buildOutput)).endSpec()).build());
            this.log.info("Updating BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        } else {
            this.log.info("Using BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        }
        return buildName;
    }

    private BuildStrategy createBuildStrategy(ImageConfiguration imageConfig, JKubeBuildStrategy osBuildStrategy, String openshiftPullSecret) {
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        Map fromExt = buildConfig.getFromExt();
        String fromName = buildConfig.isDockerFileMode() ? this.extractBaseFromDockerfile(buildConfig, this.jKubeServiceHub.getConfiguration()) : this.getMapValueWithDefault((Map<String, String>)fromExt, JKubeBuildStrategy.SourceStrategy.name, buildConfig.getFrom());
        String fromKind = this.getMapValueWithDefault((Map<String, String>)fromExt, JKubeBuildStrategy.SourceStrategy.kind, "DockerImage");
        String fromNamespace = this.getMapValueWithDefault((Map<String, String>)fromExt, JKubeBuildStrategy.SourceStrategy.namespace, "ImageStreamTag".equals(fromKind) ? "openshift" : null);
        if (osBuildStrategy == JKubeBuildStrategy.docker) {
            BuildStrategy buildStrategy = ((BuildStrategyBuilder)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).withNewDockerStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).withEnv(this.checkForEnv(imageConfig))).withNoCache(this.checkForNocache(imageConfig))).endDockerStrategy()).build();
            if (openshiftPullSecret != null) {
                buildStrategy.getDockerStrategy().setPullSecret(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(openshiftPullSecret)).build());
            }
            return buildStrategy;
        }
        if (osBuildStrategy == JKubeBuildStrategy.s2i) {
            BuildStrategy buildStrategy = ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).withForcePull(Boolean.valueOf(this.config.isForcePull()))).endSourceStrategy()).build();
            if (openshiftPullSecret != null) {
                buildStrategy.getSourceStrategy().setPullSecret(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(openshiftPullSecret)).build());
            }
            return buildStrategy;
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + osBuildStrategy);
    }

    private Boolean checkForNocache(ImageConfiguration imageConfig) {
        String nocache = System.getProperty("docker.nocache");
        if (nocache != null) {
            return nocache.length() == 0 || Boolean.parseBoolean(nocache);
        }
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        return buildConfig.nocache();
    }

    private List<EnvVar> checkForEnv(ImageConfiguration imageConfiguration) {
        BuildConfiguration buildImageConfiguration = imageConfiguration.getBuildConfiguration();
        if (buildImageConfiguration.getArgs() != null) {
            return KubernetesHelper.convertToEnvVarList((Map)buildImageConfiguration.getArgs());
        }
        return Collections.emptyList();
    }

    private boolean checkOrCreatePullSecret(OpenShiftClient client, KubernetesListBuilder builder, String pullSecretName, ImageConfiguration imageConfig) throws Exception {
        JKubeConfiguration configuration = this.jKubeServiceHub.getConfiguration();
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String fromImage = buildConfig.isDockerFileMode() ? this.extractBaseFromDockerfile(buildConfig, configuration) : this.extractBaseFromConfiguration(buildConfig);
        String pullRegistry = EnvUtil.firstRegistryOf((String[])new String[]{new ImageName(fromImage).getRegistry(), configuration.getRegistryConfig().getRegistry(), configuration.getRegistryConfig().getRegistry()});
        if (pullRegistry != null) {
            RegistryConfig registryConfig = configuration.getRegistryConfig();
            AuthConfig authConfig = new AuthConfigFactory(this.log).createAuthConfig(false, registryConfig.isSkipExtendedAuth(), registryConfig.getAuthConfig(), registryConfig.getSettings(), null, pullRegistry, registryConfig.getPasswordDecryptionMethod());
            Secret secret = Optional.ofNullable(pullSecretName).map(psn -> (Secret)((Resource)client.secrets().withName(psn)).get()).orElse(null);
            if (secret != null) {
                this.log.info("Adding to Secret %s", new Object[]{pullSecretName});
                return this.updateSecret(client, pullSecretName, secret.getData());
            }
            if (authConfig != null) {
                JsonObject auths = new JsonObject();
                JsonObject auth = new JsonObject();
                JsonObject item = new JsonObject();
                String authString = authConfig.getUsername() + ":" + authConfig.getPassword();
                item.add("auth", (JsonElement)new JsonPrimitive(Base64.encodeBase64String((byte[])authString.getBytes(StandardCharsets.UTF_8))));
                auth.add(pullRegistry, (JsonElement)item);
                auths.add("auths", (JsonElement)auth);
                String credentials = Base64.encodeBase64String((byte[])auths.toString().getBytes(StandardCharsets.UTF_8));
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(".dockerconfigjson", credentials);
                this.log.info("Creating Secret", new Object[0]);
                ((BaseKubernetesListFluent.SecretItemsNested)((BaseKubernetesListFluent.SecretItemsNested)((BaseKubernetesListFluent.SecretItemsNested)((SecretFluent.MetadataNested)builder.addNewSecretItem().withNewMetadata().withName(pullSecretName)).endMetadata()).withData(data)).withType("kubernetes.io/dockerconfigjson")).endSecretItem();
                return true;
            }
        }
        return false;
    }

    private boolean updateSecret(OpenShiftClient client, String pullSecretName, Map<String, String> data) {
        if (!Objects.equals(data, ((Secret)((Resource)client.secrets().withName(pullSecretName)).get()).getData())) {
            ((Resource)client.secrets().withName(pullSecretName)).edit(s -> ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder(s).editMetadata().withName(pullSecretName)).endMetadata()).withData(data)).withType("kubernetes.io/dockerconfigjson")).build());
            this.log.info("Updating Secret %s", new Object[]{pullSecretName});
        } else {
            this.log.info("Using Secret %s", new Object[]{pullSecretName});
        }
        return true;
    }

    private String extractBaseFromConfiguration(BuildConfiguration buildConfig) {
        AssemblyConfiguration assemblyConfig;
        String fromImage = buildConfig.getFrom();
        if (fromImage == null && (assemblyConfig = buildConfig.getAssembly()) == null) {
            fromImage = "busybox:latest";
        }
        return fromImage;
    }

    private String extractBaseFromDockerfile(BuildConfiguration buildConfig, JKubeConfiguration configuration) {
        String fromImage;
        try {
            File fullDockerFilePath = buildConfig.getAbsoluteDockerFilePath(configuration.getSourceDirectory(), (String)Optional.ofNullable(configuration.getProject().getBaseDirectory()).map(File::toString).orElse(null));
            fromImage = DockerFileUtil.extractBaseImages((File)fullDockerFilePath, (Properties)configuration.getProperties(), (String)buildConfig.getFilter(), (Map)buildConfig.getArgs()).stream().findFirst().orElse(null);
        }
        catch (IOException e) {
            fromImage = null;
        }
        return fromImage;
    }

    private void checkOrCreateImageStream(BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((Resource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && config.getBuildRecreateMode().isImageStream()) {
            ((Resource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            builder.addToItems(new HasMetadata[]{((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.LookupPolicyNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(imageStreamName)).endMetadata()).withNewSpec().withNewLookupPolicy().withLocal(Boolean.valueOf(config.isS2iImageStreamLookupPolicyLocal()))).endLookupPolicy()).endSpec()).build()});
        } else {
            this.log.info("Adding to ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private void applyResourceObjects(BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder) throws Exception {
        if (config.getEnricherTask() != null) {
            config.getEnricherTask().execute((Object)builder);
        }
        if (builder.hasItems().booleanValue()) {
            KubernetesList k8sList = builder.build();
            client.lists().create((Object)k8sList);
        }
    }

    private Build startBuild(OpenShiftClient client, File dockerTar, String buildName) {
        this.log.info("Starting Build %s", new Object[]{buildName});
        try {
            return (Build)((BuildConfigResource)client.buildConfigs().withName(buildName)).instantiateBinary().fromFile(dockerTar);
        }
        catch (KubernetesClientException exp) {
            Status status = exp.getStatus();
            if (status != null) {
                this.log.error("OpenShift Error: [%d %s] [%s] %s", new Object[]{status.getCode(), status.getStatus(), status.getReason(), status.getMessage()});
            }
            if (exp.getCause() instanceof IOException && exp.getCause().getMessage().contains("Stream Closed")) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, exp.getCause().getMessage()});
                this.logBuildFailedDetails(client, buildName);
            }
            throw exp;
        }
    }

    private void waitForOpenShiftBuildToComplete(OpenShiftClient client, Build build) throws IOException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch logTerminateLatch = new CountDownLatch(1);
        String buildName = KubernetesHelper.getName((HasMetadata)build);
        AtomicReference<Build> buildHolder = new AtomicReference<Build>();
        this.waitUntilPodIsReady(buildName + "-build", 120, this.log);
        this.log.info("Waiting for build " + buildName + " to complete...", new Object[0]);
        try (LogWatch logWatch = (LogWatch)((PodResource)client.pods().withName(buildName + "-build")).watchLog();){
            KubernetesHelper.printLogsAsync((LogWatch)logWatch, (String)"Failed to tail build log", (CountDownLatch)logTerminateLatch, (KitLogger)this.log);
            Watcher<Build> buildWatcher = this.getBuildWatcher(latch, buildName, buildHolder);
            try (Watch watcher = ((BuildResource)client.builds().withName(buildName)).watch(buildWatcher);){
                String status;
                Build lastBuild = (Build)((BuildResource)client.builds().withName(buildName)).get();
                if (OpenshiftHelper.isFinished((String)KubernetesHelper.getBuildStatusPhase((Build)lastBuild))) {
                    this.log.debug("Build %s is already finished", new Object[]{buildName});
                    buildHolder.set(lastBuild);
                    latch.countDown();
                }
                this.waitUntilBuildFinished(latch);
                logTerminateLatch.countDown();
                build = buildHolder.get();
                if (build == null) {
                    this.log.debug("Build watcher on %s was closed prematurely", new Object[]{buildName});
                    build = (Build)((BuildResource)client.builds().withName(buildName)).get();
                }
                if (OpenshiftHelper.isFailed((String)(status = KubernetesHelper.getBuildStatusPhase((Build)build))) || OpenshiftHelper.isCancelled((String)status)) {
                    throw new IOException("OpenShift Build " + buildName + " failed: " + KubernetesHelper.getBuildStatusReason((Build)build));
                }
                if (!OpenshiftHelper.isFinished((String)status)) {
                    this.log.warn("Could not wait for the completion of build %s. It may be  may be still running (status=%s)", new Object[]{buildName, status});
                } else {
                    this.log.info("Build %s in status %s", new Object[]{buildName, status});
                }
            }
        }
    }

    private void waitUntilPodIsReady(String podName, int nAwaitTimeout, KitLogger log) {
        final CountDownLatch readyLatch = new CountDownLatch(1);
        try (Watch watch = ((PodResource)this.client.pods().withName(podName)).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod aPod) {
                if (KubernetesHelper.isPodReady((Pod)aPod)) {
                    readyLatch.countDown();
                }
            }

            public void onClose(WatcherException e) {
            }
        });){
            readyLatch.await(nAwaitTimeout, TimeUnit.SECONDS);
        }
        catch (KubernetesClientException e) {
            log.error("Could not watch pod", new Object[]{e});
        }
        catch (InterruptedException e) {
            log.error("Could not watch pod (Thread interrupted)", new Object[]{e});
            Thread.currentThread().interrupt();
        }
    }

    private void waitUntilBuildFinished(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Watcher<Build> getBuildWatcher(final CountDownLatch latch, final String buildName, final AtomicReference<Build> buildHolder) {
        return new Watcher<Build>(){
            String lastStatus = "";

            public void eventReceived(Watcher.Action action, Build build) {
                buildHolder.set(build);
                String status = KubernetesHelper.getBuildStatusPhase((Build)build);
                OpenshiftBuildService.this.log.verbose("BuildWatch: Received event %s , build status: %s", new Object[]{action, build.getStatus()});
                if (!this.lastStatus.equals(status)) {
                    this.lastStatus = status;
                    OpenshiftBuildService.this.log.verbose("Build %s status: %s", new Object[]{buildName, status});
                }
                if (OpenshiftHelper.isFinished((String)status)) {
                    latch.countDown();
                }
            }

            public void onClose(WatcherException cause) {
                if (cause != null) {
                    OpenshiftBuildService.this.log.error("Error while watching for build to finish: %s ", new Object[]{cause.getMessage()});
                }
                latch.countDown();
            }
        };
    }

    private void logBuildFailedDetails(OpenShiftClient client, String buildName) {
        try {
            BuildConfig build = (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).get();
            ObjectReference ref = build.getSpec().getStrategy().getSourceStrategy().getFrom();
            String kind = ref.getKind();
            String name = ref.getName();
            if ("DockerImage".equals(kind)) {
                this.log.error("Please, ensure that the Docker image '%s' exists and is accessible by OpenShift", new Object[]{name});
            } else if ("ImageStreamTag".equals(kind)) {
                String namespace = ref.getNamespace();
                String namespaceInfo = "current";
                String namespaceParams = "";
                if (namespace != null && !namespace.isEmpty()) {
                    namespaceInfo = "'" + namespace + "'";
                    namespaceParams = " -n " + namespace;
                }
                this.log.error("Please, ensure that the ImageStream Tag '%s' exists in the %s namespace (with 'oc get is%s')", new Object[]{name, namespaceInfo, namespaceParams});
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to get detailed information from the BuildServiceConfig: " + ex.getMessage(), new Object[0]);
        }
    }

    private void logBuildFailure(OpenShiftClient client, String buildName) throws JKubeServiceException {
        block3: {
            try {
                List builds = ((BuildList)((NonNamespaceOperation)client.builds().inNamespace(client.getNamespace())).list()).getItems();
                for (Build build : builds) {
                    if (!build.getMetadata().getName().contains(buildName)) continue;
                    this.log.error(build.getMetadata().getName() + "\t\t" + build.getStatus().getReason() + "\t" + build.getStatus().getMessage(), new Object[0]);
                    throw new JKubeServiceException("Unable to build the image using the OpenShift build service", new KubernetesClientException(build.getStatus().getReason() + " " + build.getStatus().getMessage()));
                }
                this.log.error("Also, check cluster events via `oc get events` to see what could have possibly gone wrong", new Object[0]);
            }
            catch (KubernetesClientException clientException) {
                Status status = clientException.getStatus();
                if (status == null) break block3;
                this.log.error("OpenShift Error: [%d] %s", new Object[]{status.getCode(), status.getMessage()});
            }
        }
    }

    private void addImageStreamToFile(File imageStreamFile, ImageName imageName, OpenShiftClient client) throws IOException {
        ImageStreamService imageStreamHandler = new ImageStreamService(client, this.log);
        imageStreamHandler.appendImageStreamResource(imageName, imageStreamFile);
    }

    private String getS2IBuildName(BuildServiceConfig config, ImageName imageName) {
        StringBuilder s2IBuildName = new StringBuilder(imageName.getSimpleName());
        if (!StringUtils.isEmpty((CharSequence)config.getS2iBuildNameSuffix())) {
            s2IBuildName.append(config.getS2iBuildNameSuffix());
        } else if (config.getJKubeBuildStrategy() == JKubeBuildStrategy.s2i) {
            s2IBuildName.append(DEFAULT_S2I_BUILD_SUFFIX);
        }
        return s2IBuildName.toString();
    }

    private String getImageStreamName(ImageName name) {
        return name.getSimpleName();
    }

    private String getMapValueWithDefault(Map<String, String> map, JKubeBuildStrategy.SourceStrategy strategy, String defaultValue) {
        return this.getMapValueWithDefault(map, strategy.key(), defaultValue);
    }

    private String getMapValueWithDefault(Map<String, String> map, String field, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(field);
        return value != null ? value : defaultValue;
    }

    private Map<String, Map<String, Quantity>> getRequestsAndLimits() {
        HashMap<String, Map<String, Quantity>> keyToQuantityMap = new HashMap<String, Map<String, Quantity>>();
        if (this.config.getResourceConfig() != null && this.config.getResourceConfig().getOpenshiftBuildConfig() != null) {
            Map requests;
            Map limits = KubernetesHelper.getQuantityFromString((Map)this.config.getResourceConfig().getOpenshiftBuildConfig().getLimits());
            if (!limits.isEmpty()) {
                keyToQuantityMap.put(LIMITS, limits);
            }
            if (!(requests = KubernetesHelper.getQuantityFromString((Map)this.config.getResourceConfig().getOpenshiftBuildConfig().getRequests())).isEmpty()) {
                keyToQuantityMap.put(REQUESTS, requests);
            }
        }
        return keyToQuantityMap;
    }
}

