/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;

public class KubernetesClientUtil {
    private KubernetesClientUtil() {
    }

    public static void resizeApp(NamespacedKubernetesClient kubernetes, Collection<HasMetadata> entities, int replicas, KitLogger log) {
        for (HasMetadata entity : entities) {
            String name = KubernetesHelper.getName((HasMetadata)entity);
            ScalableResource scalable = null;
            if (entity instanceof Deployment) {
                scalable = (ScalableResource)kubernetes.apps().deployments().withName(name);
            } else if (entity instanceof ReplicaSet) {
                scalable = (ScalableResource)kubernetes.apps().replicaSets().withName(name);
            } else if (entity instanceof ReplicationController) {
                scalable = (ScalableResource)kubernetes.replicationControllers().withName(name);
            } else if (entity instanceof DeploymentConfig) {
                OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kubernetes);
                if (openshiftClient == null) {
                    log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
                    continue;
                }
                scalable = (ScalableResource)openshiftClient.deploymentConfigs().withName(name);
            }
            if (scalable == null) continue;
            log.info("Scaling " + KubernetesHelper.getKind((HasMetadata)entity) + " " + kubernetes.getNamespace() + "/" + name + " to replicas: " + replicas, new Object[0]);
            scalable.scale(replicas, true);
        }
    }

    public static void deleteEntities(NamespacedKubernetesClient kc, Collection<HasMetadata> entities, KitLogger log) {
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>(entities);
        Collections.reverse(list);
        for (HasMetadata entity : list) {
            log.info("Deleting resource " + KubernetesHelper.getKind((HasMetadata)entity) + " " + kc.getNamespace() + "/" + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            ((GracePeriodConfigurable)kc.resource(entity).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        }
    }

    public static void deleteOpenShiftEntities(NamespacedKubernetesClient kc, Collection<HasMetadata> entities, String s2iBuildNameSuffix, KitLogger log) {
        OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kc);
        if (openshiftClient == null) {
            return;
        }
        for (HasMetadata entity : entities) {
            if (!"ImageStream".equals(KubernetesHelper.getKind((HasMetadata)entity))) continue;
            ImageName imageName = new ImageName(entity.getMetadata().getName());
            String buildName = KubernetesClientUtil.getS2IBuildName(imageName, s2iBuildNameSuffix);
            log.info("Deleting resource BuildConfig %s/%s and Builds", new Object[]{kc.getNamespace(), buildName});
            ((FilterWatchListDeletable)openshiftClient.builds().withLabel("buildconfig", buildName)).delete();
            ((BuildConfigResource)openshiftClient.buildConfigs().withName(buildName)).delete();
        }
    }

    private static String getS2IBuildName(ImageName imageName, String s2iBuildNameSuffix) {
        return imageName.getSimpleName() + s2iBuildNameSuffix;
    }

    public static String getPodStatusDescription(Pod pod) {
        return KubernetesHelper.getPodPhase((Pod)pod) + " " + KubernetesClientUtil.getPodCondition(pod);
    }

    public static String getPodStatusMessagePostfix(Watcher.Action action) {
        String message = "";
        switch (action) {
            case DELETED: {
                message = ": Pod Deleted";
                break;
            }
            case ERROR: {
                message = ": Error";
            }
        }
        return message;
    }

    protected static String getPodCondition(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return "";
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return "";
        }
        for (PodCondition condition : conditions) {
            String statusText;
            String type = condition.getType();
            if (!StringUtils.isNotBlank((CharSequence)type) || !"ready".equalsIgnoreCase(type) || !StringUtils.isNotBlank((CharSequence)(statusText = condition.getStatus())) || !Boolean.parseBoolean(statusText)) continue;
            return type;
        }
        return "";
    }

    public static GenericKubernetesResource doGetCustomResource(KubernetesClient kubernetesClient, GenericKubernetesResource resource, String namespace) {
        try {
            return (GenericKubernetesResource)((Resource)((NonNamespaceOperation)kubernetesClient.genericKubernetesResources(resource.getApiVersion(), resource.getKind()).inNamespace(namespace)).withName(resource.getMetadata().getName())).get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void doDeleteAndWait(KubernetesClient kubernetesClient, GenericKubernetesResource resource, String namespace, long seconds) {
        Resource crClient = (Resource)((NonNamespaceOperation)kubernetesClient.genericKubernetesResources(resource.getApiVersion(), resource.getKind()).inNamespace(namespace)).withName(resource.getMetadata().getName());
        crClient.delete();
        crClient.waitUntilCondition(Objects::isNull, seconds, TimeUnit.SECONDS);
    }

    public static String applicableNamespace(HasMetadata resource, String namespace, ResourceConfig resourceConfig, ClusterAccess clusterAccess) {
        return KubernetesClientUtil.applicableNamespace(resource, namespace, KubernetesClientUtil.resolveFallbackNamespace(resourceConfig, clusterAccess));
    }

    public static String applicableNamespace(HasMetadata resource, String namespace, String fallbackNamespace) {
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            return namespace;
        }
        if (resource != null && StringUtils.isNotBlank((CharSequence)KubernetesHelper.getNamespace((HasMetadata)resource))) {
            return KubernetesHelper.getNamespace((HasMetadata)resource);
        }
        return StringUtils.isNotBlank((CharSequence)fallbackNamespace) ? fallbackNamespace : KubernetesHelper.getDefaultNamespace();
    }

    public static String resolveFallbackNamespace(ResourceConfig resourceConfig, ClusterAccess clusterAccess) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getNamespace).orElse(Optional.ofNullable(clusterAccess).map(ClusterAccess::getNamespace).orElse(null));
    }

    public static ResourceConfig updateResourceConfigNamespace(String namespaceProvidedViaProperty, ResourceConfig resourceConfig) {
        String resolvedNamespace = Optional.ofNullable(namespaceProvidedViaProperty).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
        if (resourceConfig == null) {
            resourceConfig = ResourceConfig.builder().namespace(resolvedNamespace).build();
        } else if (resolvedNamespace != null) {
            resourceConfig = ResourceConfig.toBuilder((ResourceConfig)resourceConfig).namespace(resolvedNamespace).build();
        }
        return resourceConfig;
    }
}

