/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.image.ImageName;

public class ImageStreamService {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final int IMAGE_STREAM_TAG_RETRIES = 15;
    private static final long IMAGE_STREAM_TAG_RETRY_TIMEOUT_IN_MILLIS = 1000L;
    private final OpenShiftClient client;
    private final String namespace;
    private final KitLogger log;

    public ImageStreamService(OpenShiftClient client, String namespace, KitLogger log) {
        this.client = client;
        this.namespace = namespace;
        this.log = log;
    }

    public void appendImageStreamResource(ImageName imageName, File target) throws IOException {
        String tag = StringUtils.isBlank((CharSequence)imageName.getTag()) ? "latest" : imageName.getTag();
        try {
            ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((TagReferenceFluent.FromNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(ImageStreamService.resolveImageStreamName(imageName))).endMetadata()).withNewSpec().addNewTag().withName(tag)).withNewFrom().withKind("ImageStreamImage")).endFrom()).endTag()).endSpec()).build();
            this.createOrUpdateImageStreamTag(this.client, imageName, is);
            this.appendImageStreamToFile(is, target);
            this.log.info("ImageStream %s written to %s", new Object[]{ImageStreamService.resolveImageStreamName(imageName), target});
        }
        catch (KubernetesClientException e) {
            KubernetesHelper.handleKubernetesClientException((KubernetesClientException)e, (KitLogger)this.log);
        }
        catch (IOException e) {
            throw new IOException(String.format("Cannot write ImageStream descriptor for %s to %s : %s", imageName.getFullName(), target.getAbsoluteFile(), e.getMessage()), e);
        }
    }

    private void appendImageStreamToFile(ImageStream is, File target) throws IOException {
        Map<String, ImageStream> imageStreams = this.readAlreadyExtractedImageStreams(target);
        imageStreams.put(is.getMetadata().getName(), is);
        KubernetesList isList = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<ImageStream>(imageStreams.values()))).build();
        ResourceUtil.save((File)target, (Object)isList);
    }

    private Map<String, ImageStream> readAlreadyExtractedImageStreams(File target) throws IOException {
        HashMap<String, ImageStream> imageStreams = new HashMap<String, ImageStream>();
        if (target.length() > 0L) {
            for (HasMetadata entity : KubernetesHelper.loadResources((File)target)) {
                if (!"ImageStream".equals(KubernetesHelper.getKind((HasMetadata)entity))) continue;
                imageStreams.put(entity.getMetadata().getName(), (ImageStream)entity);
            }
        }
        return imageStreams;
    }

    private void createOrUpdateImageStreamTag(OpenShiftClient client, ImageName image, ImageStream is) {
        String tagSha = this.findTagSha(client, ImageStreamService.resolveImageStreamName(image), this.namespace);
        String name = ImageStreamService.resolveImageStreamName(image) + "@" + tagSha;
        TagReference tag = this.extractTag(is);
        ObjectReference from = this.extractFrom(tag);
        if (!Objects.equals(image.getTag(), tag.getName())) {
            tag.setName(image.getTag());
        }
        if (!Objects.equals("ImageStreamImage", from.getKind())) {
            from.setKind("ImageStreamImage");
        }
        if (!Objects.equals(this.namespace, from.getNamespace())) {
            from.setNamespace(this.namespace);
        }
        if (!Objects.equals(name, from.getName())) {
            from.setName(name);
        }
    }

    private ObjectReference extractFrom(TagReference tag) {
        ObjectReference from = tag.getFrom();
        if (from == null) {
            from = new ObjectReference();
            tag.setFrom(from);
        }
        return from;
    }

    private TagReference extractTag(ImageStream is) {
        ArrayList<TagReference> tags;
        ImageStreamSpec spec = is.getSpec();
        if (spec == null) {
            spec = new ImageStreamSpec();
            is.setSpec(spec);
        }
        if ((tags = spec.getTags()) == null) {
            tags = new ArrayList<TagReference>();
            spec.setTags(tags);
        }
        TagReference tag = null;
        if (tags.isEmpty()) {
            tag = new TagReference();
            tags.add(tag);
        } else {
            tag = (TagReference)tags.get(tags.size() - 1);
        }
        return tag;
    }

    private String findTagSha(OpenShiftClient client, String imageStreamName, String namespace) {
        ImageStream currentImageStream = null;
        for (int i = 0; i < 15; ++i) {
            List tags;
            ImageStreamStatus status;
            if (i > 0) {
                this.log.info("Retrying to find tag on ImageStream %s", new Object[]{imageStreamName});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.debug("interrupted", new Object[]{e});
                    Thread.currentThread().interrupt();
                }
            }
            if ((currentImageStream = (ImageStream)((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(namespace)).withName(imageStreamName)).get()) == null || (status = currentImageStream.getStatus()) == null || (tags = status.getTags()) == null || tags.isEmpty()) continue;
            TagEvent latestTag = null;
            for (NamedTagEventList list : tags) {
                List items = list.getItems();
                if (items == null || items.isEmpty()) continue;
                for (TagEvent tag : items) {
                    latestTag = latestTag == null ? tag : this.newerTag(tag, latestTag);
                }
            }
            if (latestTag == null || !StringUtils.isNotBlank((CharSequence)latestTag.getImage())) continue;
            String image = latestTag.getImage();
            this.log.info("Found tag on ImageStream " + imageStreamName + " tag: " + image, new Object[0]);
            return image;
        }
        if (currentImageStream == null) {
            throw new IllegalStateException("Could not find a current ImageStream with name " + imageStreamName + " in namespace " + namespace);
        }
        throw new IllegalStateException("Could not find a tag in the ImageStream " + imageStreamName);
    }

    public TagEvent newerTag(TagEvent tag1, TagEvent tag2) {
        Date tag1Date = this.extractDate(tag1);
        Date tag2Date = this.extractDate(tag2);
        if (tag1Date == null) {
            return tag2;
        }
        if (tag2Date == null) {
            return tag1;
        }
        return tag1Date.compareTo(tag2Date) > 0 ? tag1 : tag2;
    }

    private Date extractDate(TagEvent tag) {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(tag.getCreated());
        }
        catch (ParseException e) {
            this.log.error("parsing date error : " + e.getMessage(), new Object[]{e});
            return null;
        }
        catch (NullPointerException e) {
            this.log.error("tag date is null : " + e.getMessage(), new Object[]{e});
            return null;
        }
    }

    protected static String resolveImageStreamName(ImageName name) {
        return name.getSimpleName().replace("/", "-");
    }

    protected static String resolveImageStreamTagName(ImageName name) {
        return ImageStreamService.resolveImageStreamName(name) + ":" + (StringUtils.isBlank((CharSequence)name.getTag()) ? "latest" : name.getTag());
    }
}

