/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.openshift;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.helper.BuildUtil;
import org.eclipse.jkube.kit.build.api.helper.RegistryUtil;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.AbstractImageBuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.openshift.ImageStreamService;
import org.eclipse.jkube.kit.config.service.openshift.OpenShiftBuildServiceUtils;

public class OpenshiftBuildService
extends AbstractImageBuildService {
    protected static final String DEFAULT_S2I_BUILD_SUFFIX = "-s2i";
    public static final String DEFAULT_S2I_SOURCE_TYPE = "Binary";
    protected static final String IMAGE_STREAM_TAG = "ImageStreamTag";
    protected static final String DOCKER_IMAGE = "DockerImage";
    protected static final String DEFAULT_BUILD_OUTPUT_KIND = "ImageStreamTag";
    public static final String REQUESTS = "requests";
    public static final String LIMITS = "limits";
    private final JKubeServiceHub jKubeServiceHub;
    private final KitLogger log;
    private final BuildServiceConfig buildServiceConfig;
    private final JKubeConfiguration jKubeConfiguration;
    private OpenShiftClient client;
    private String applicableOpenShiftNamespace;

    public OpenshiftBuildService(JKubeServiceHub jKubeServiceHub) {
        super(jKubeServiceHub);
        this.jKubeServiceHub = Objects.requireNonNull(jKubeServiceHub, "JKube Service Hub is required");
        this.log = Objects.requireNonNull(jKubeServiceHub.getLog(), "Log is required");
        this.buildServiceConfig = Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.jKubeConfiguration = Objects.requireNonNull(jKubeServiceHub.getConfiguration(), "JKubeConfiguration is required");
        Objects.requireNonNull(jKubeServiceHub.getDockerServiceHub(), "Docker Service Hub is required");
        Objects.requireNonNull(jKubeServiceHub.getDockerServiceHub().getArchiveService(), "Docker Archive Service is required");
    }

    @Override
    public boolean isApplicable() {
        return this.jKubeServiceHub.getRuntimeMode() == RuntimeMode.OPENSHIFT;
    }

    @Override
    public void buildSingleImage(ImageConfiguration imageConfig) throws JKubeServiceException {
        this.initClient();
        String buildName = null;
        try {
            ImageConfiguration applicableImageConfig = this.getApplicableImageConfiguration(imageConfig, this.jKubeConfiguration.getRegistryConfig());
            ImageName imageName = new ImageName(applicableImageConfig.getName());
            File dockerTar = OpenShiftBuildServiceUtils.createBuildArchive(this.jKubeServiceHub, applicableImageConfig);
            KubernetesListBuilder builder = new KubernetesListBuilder();
            String openshiftPullSecret = this.buildServiceConfig.getOpenshiftPullSecret();
            boolean usePullSecret = this.checkOrCreatePullSecret(this.client, builder, openshiftPullSecret, applicableImageConfig);
            buildName = usePullSecret ? this.updateOrCreateBuildConfig(this.buildServiceConfig, this.client, builder, applicableImageConfig, openshiftPullSecret) : this.updateOrCreateBuildConfig(this.buildServiceConfig, this.client, builder, applicableImageConfig, null);
            if (this.buildServiceConfig.getBuildOutputKind() == null || "ImageStreamTag".equals(this.buildServiceConfig.getBuildOutputKind())) {
                this.checkOrCreateImageStream(this.buildServiceConfig, this.client, builder, ImageStreamService.resolveImageStreamName(imageName));
                this.applyBuild(buildName, dockerTar, builder);
                this.addImageStreamToFile(this.getImageStreamFile(), imageName, this.client);
                this.createAdditionalTags(imageConfig, imageName);
            } else {
                this.applyBuild(buildName, dockerTar, builder);
            }
        }
        catch (JKubeServiceException e) {
            throw e;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IOException) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, ex.getCause().getMessage()});
                this.logBuildFailure(this.client, buildName);
            }
            throw new JKubeServiceException("Unable to build the image using the OpenShift build service", ex);
        }
    }

    @Override
    protected void pushSingleImage(ImageConfiguration imageConfiguration, int retries, RegistryConfig registryConfig, boolean skipTag) {
        this.log.warn("Image is pushed to OpenShift's internal registry during oc:build goal. Skipping...", new Object[0]);
    }

    private void applyBuild(String buildName, File dockerTar, KubernetesListBuilder builder) throws Exception {
        this.applyResourceObjects(this.buildServiceConfig, this.client, builder);
        Build build = this.startBuild(this.client, dockerTar, buildName);
        this.waitForOpenShiftBuildToComplete(this.client, build);
    }

    private File getImageStreamFile() {
        return ResourceFileType.yaml.addExtensionIfMissing(new File(this.buildServiceConfig.getBuildDirectory(), String.format("%s-is", this.jKubeConfiguration.getProject().getArtifactId())));
    }

    @Override
    public void postProcess() {
        this.buildServiceConfig.attachArtifact("is", this.getImageStreamFile());
    }

    protected String updateOrCreateBuildConfig(BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig, String openshiftPullSecret) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = OpenShiftBuildServiceUtils.computeS2IBuildName(config, imageName);
        BuildStrategy buildStrategyResource = OpenShiftBuildServiceUtils.createBuildStrategy(this.jKubeServiceHub, imageConfig, openshiftPullSecret);
        BuildOutput buildOutput = OpenShiftBuildServiceUtils.createBuildOutput(config, imageName);
        BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).get();
        if (buildConfig != null) {
            BuildConfigSpec spec = OpenShiftBuildServiceUtils.getBuildConfigSpec(buildConfig);
            this.validateSourceType(buildName, spec);
            if (config.getBuildRecreateMode().isBuildConfig()) {
                ((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).delete();
                return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
            }
            return this.updateBuildConfig(client, buildName, buildStrategyResource, buildOutput, spec);
        }
        return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
    }

    ImageConfiguration getApplicableImageConfiguration(ImageConfiguration imageConfig, RegistryConfig registryConfig) {
        ImageConfiguration.ImageConfigurationBuilder applicableImageConfigBuilder = imageConfig.toBuilder();
        if (imageConfig.getBuildConfiguration() != null && !imageConfig.getBuildConfiguration().isDockerFileMode() && imageConfig.getBuildConfiguration().getAssembly() != null) {
            applicableImageConfigBuilder.build(imageConfig.getBuild().toBuilder().assembly(imageConfig.getBuildConfiguration().getAssembly().getFlattenedClone(this.jKubeServiceHub.getConfiguration())).build());
        }
        if (this.buildServiceConfig.getBuildOutputKind() != null && this.buildServiceConfig.getBuildOutputKind().equals(DOCKER_IMAGE)) {
            String applicableRegistry = RegistryUtil.getApplicablePushRegistryFrom((ImageConfiguration)imageConfig, (RegistryConfig)registryConfig);
            applicableImageConfigBuilder.name(new ImageName(imageConfig.getName()).getFullName(applicableRegistry));
        }
        return applicableImageConfigBuilder.build();
    }

    private void initClient() {
        KubernetesClient k8sClient = this.jKubeServiceHub.getClient();
        if (!OpenshiftHelper.isOpenShift((KubernetesClient)k8sClient)) {
            throw new IllegalStateException("OpenShift platform has been specified but OpenShift has not been detected!");
        }
        this.client = OpenshiftHelper.asOpenShiftClient((KubernetesClient)k8sClient);
        this.applicableOpenShiftNamespace = this.buildServiceConfig.getResourceConfig() != null && this.buildServiceConfig.getResourceConfig().getNamespace() != null ? this.buildServiceConfig.getResourceConfig().getNamespace() : this.jKubeServiceHub.getClusterAccess().getNamespace();
    }

    private void validateSourceType(String buildName, BuildConfigSpec spec) {
        String sourceType;
        BuildSource source = spec.getSource();
        if (source != null && !Objects.equals(DEFAULT_S2I_SOURCE_TYPE, sourceType = source.getType())) {
            this.log.warn("BuildServiceConfig %s is not of type: 'Binary' but is '%s' !", new Object[]{buildName, sourceType});
        }
    }

    private BuildConfigSpec getBuildConfigSpec(BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        Map<String, Map<String, Quantity>> requestsLimitsMap;
        BuildConfigSpecBuilder specBuilder = null;
        File buildConfigResourceFragment = KubernetesHelper.getResourceFragmentFromSource((File)this.buildServiceConfig.getResourceDir(), (List)(this.buildServiceConfig.getResourceConfig() != null ? this.buildServiceConfig.getResourceConfig().getRemotes() : null), (String)"buildconfig.yml", (KitLogger)this.log);
        if (buildConfigResourceFragment != null) {
            BuildConfig buildConfigFragment = (BuildConfig)((BuildConfigResource)this.client.buildConfigs().load(buildConfigResourceFragment)).get();
            specBuilder = new BuildConfigSpecBuilder(buildConfigFragment.getSpec());
        } else {
            specBuilder = new BuildConfigSpecBuilder();
        }
        if (specBuilder.buildSource() == null) {
            ((BuildConfigSpecFluent.SourceNested)specBuilder.withNewSource().withType(DEFAULT_S2I_SOURCE_TYPE)).endSource();
        }
        if (specBuilder.buildStrategy() == null) {
            specBuilder.withStrategy(buildStrategyResource);
        }
        if (specBuilder.buildOutput() == null) {
            specBuilder.withOutput(buildOutput);
        }
        if ((requestsLimitsMap = this.getRequestsAndLimits()).containsKey(REQUESTS)) {
            ((BuildConfigSpecFluent.ResourcesNested)specBuilder.editOrNewResources().addToRequests(requestsLimitsMap.get(REQUESTS))).endResources();
        }
        if (requestsLimitsMap.containsKey(LIMITS)) {
            ((BuildConfigSpecFluent.ResourcesNested)specBuilder.editOrNewResources().addToLimits(requestsLimitsMap.get(LIMITS))).endResources();
        }
        return specBuilder.build();
    }

    private String createBuildConfig(KubernetesListBuilder builder, String buildName, BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        this.log.info("Creating BuildServiceConfig %s for %s build", new Object[]{buildName, buildStrategyResource.getType()});
        builder.addToItems(new HasMetadata[]{((BuildConfigBuilder)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(buildName)).endMetadata()).withSpec(this.getBuildConfigSpec(buildStrategyResource, buildOutput))).build()});
        return buildName;
    }

    private String updateBuildConfig(OpenShiftClient client, String buildName, BuildStrategy buildStrategy, BuildOutput buildOutput, BuildConfigSpec spec) {
        if (!Objects.equals(buildStrategy, spec.getStrategy()) || !Objects.equals(buildOutput, spec.getOutput())) {
            ((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).edit(bc -> ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)new BuildConfigBuilder(bc).editSpec().withStrategy(buildStrategy)).withOutput(buildOutput)).endSpec()).build());
            this.log.info("Updating BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        } else {
            this.log.info("Using BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        }
        return buildName;
    }

    private boolean checkOrCreatePullSecret(OpenShiftClient client, KubernetesListBuilder builder, String pullSecretName, ImageConfiguration imageConfig) throws Exception {
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String fromImage = buildConfig.isDockerFileMode() ? BuildUtil.extractBaseFromDockerfile((JKubeConfiguration)this.jKubeConfiguration, (BuildConfiguration)buildConfig) : BuildUtil.extractBaseFromConfiguration((BuildConfiguration)buildConfig);
        String pullRegistry = RegistryUtil.getApplicablePullRegistryFrom((String)fromImage, (RegistryConfig)this.jKubeConfiguration.getRegistryConfig());
        if (pullRegistry != null) {
            RegistryConfig registryConfig = this.jKubeConfiguration.getRegistryConfig();
            AuthConfig authConfig = new AuthConfigFactory(this.log).createAuthConfig(false, registryConfig.isSkipExtendedAuth(), registryConfig.getAuthConfig(), registryConfig.getSettings(), null, pullRegistry, registryConfig.getPasswordDecryptionMethod());
            Secret secret = Optional.ofNullable(pullSecretName).map(psn -> (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(this.applicableOpenShiftNamespace)).withName(psn)).get()).orElse(null);
            if (secret != null) {
                this.log.info("Adding to Secret %s", new Object[]{pullSecretName});
                return this.updateSecret(client, pullSecretName, secret.getData());
            }
            if (authConfig != null) {
                JsonObject auths = new JsonObject();
                JsonObject auth = new JsonObject();
                JsonObject item = new JsonObject();
                String authString = authConfig.getUsername() + ":" + authConfig.getPassword();
                item.add("auth", (JsonElement)new JsonPrimitive(Base64.encodeBase64String((byte[])authString.getBytes(StandardCharsets.UTF_8))));
                auth.add(pullRegistry, (JsonElement)item);
                auths.add("auths", (JsonElement)auth);
                String credentials = Base64.encodeBase64String((byte[])auths.toString().getBytes(StandardCharsets.UTF_8));
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(".dockerconfigjson", credentials);
                this.log.info("Creating Secret", new Object[0]);
                ((KubernetesListFluent.SecretItemsNested)((KubernetesListFluent.SecretItemsNested)((KubernetesListFluent.SecretItemsNested)((SecretFluent.MetadataNested)builder.addNewSecretItem().withNewMetadata().withName(pullSecretName)).endMetadata()).withData(data)).withType("kubernetes.io/dockerconfigjson")).endSecretItem();
                return true;
            }
        }
        return false;
    }

    private boolean updateSecret(OpenShiftClient client, String pullSecretName, Map<String, String> data) {
        if (!Objects.equals(data, ((Secret)((Resource)client.secrets().withName(pullSecretName)).get()).getData())) {
            ((Resource)((NonNamespaceOperation)client.secrets().inNamespace(this.applicableOpenShiftNamespace)).withName(pullSecretName)).edit(s -> ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder(s).editMetadata().withName(pullSecretName)).endMetadata()).withData(data)).withType("kubernetes.io/dockerconfigjson")).build());
            this.log.info("Updating Secret %s", new Object[]{pullSecretName});
        } else {
            this.log.info("Using Secret %s", new Object[]{pullSecretName});
        }
        return true;
    }

    private void checkOrCreateImageStream(BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(this.applicableOpenShiftNamespace)).withName(imageStreamName)).get() != null;
        if (hasImageStream && config.getBuildRecreateMode().isImageStream()) {
            ((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(this.applicableOpenShiftNamespace)).withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            builder.addToItems(new HasMetadata[]{((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.LookupPolicyNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(imageStreamName)).endMetadata()).withNewSpec().withNewLookupPolicy().withLocal(Boolean.valueOf(config.isS2iImageStreamLookupPolicyLocal()))).endLookupPolicy()).endSpec()).build()});
        } else {
            this.log.info("Adding to ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private void applyResourceObjects(BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder) throws Exception {
        if (config.getEnricherTask() != null) {
            config.getEnricherTask().execute((Object)builder);
        }
        if (builder.hasItems()) {
            KubernetesList k8sList = builder.build();
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.resourceList((KubernetesResourceList)k8sList).inNamespace(this.applicableOpenShiftNamespace)).create();
        }
    }

    private Build startBuild(OpenShiftClient client, File dockerTar, String buildName) {
        this.log.info("Starting Build %s", new Object[]{buildName});
        try {
            return (Build)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).instantiateBinary().fromFile(dockerTar);
        }
        catch (KubernetesClientException exp) {
            Status status = exp.getStatus();
            if (status != null) {
                this.log.error("OpenShift Error: [%d %s] [%s] %s", new Object[]{status.getCode(), status.getStatus(), status.getReason(), status.getMessage()});
            }
            if (exp.getCause() instanceof IOException && exp.getCause().getMessage().contains("Stream Closed")) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, exp.getCause().getMessage()});
                this.logBuildFailedDetails(client, buildName);
            }
            throw exp;
        }
    }

    private void waitForOpenShiftBuildToComplete(OpenShiftClient client, Build build) throws IOException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch logTerminateLatch = new CountDownLatch(1);
        String buildName = KubernetesHelper.getName((HasMetadata)build);
        AtomicReference<Build> buildHolder = new AtomicReference<Build>();
        this.waitUntilPodIsReady(buildName + "-build", 120, this.log);
        this.log.info("Waiting for build " + buildName + " to complete...", new Object[0]);
        try (LogWatch logWatch = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName + "-build")).watchLog();){
            KubernetesHelper.printLogsAsync((LogWatch)logWatch, (String)"Failed to tail build log", (CountDownLatch)logTerminateLatch, (KitLogger)this.log);
            Watcher<Build> buildWatcher = this.getBuildWatcher(latch, buildName, buildHolder);
            try (Watch watcher = ((BuildResource)((NonNamespaceOperation)client.builds().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).watch(buildWatcher);){
                String status;
                Build lastBuild = (Build)((BuildResource)((NonNamespaceOperation)client.builds().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).get();
                if (OpenshiftHelper.isFinished((String)KubernetesHelper.getBuildStatusPhase((Build)lastBuild))) {
                    this.log.debug("Build %s is already finished", new Object[]{buildName});
                    buildHolder.set(lastBuild);
                    latch.countDown();
                }
                this.waitUntilBuildFinished(latch);
                logTerminateLatch.countDown();
                build = buildHolder.get();
                if (build == null) {
                    this.log.debug("Build watcher on %s was closed prematurely", new Object[]{buildName});
                    build = (Build)((BuildResource)((NonNamespaceOperation)client.builds().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).get();
                }
                if (OpenshiftHelper.isFailed((String)(status = KubernetesHelper.getBuildStatusPhase((Build)build))) || OpenshiftHelper.isCancelled((String)status)) {
                    throw new IOException("OpenShift Build " + buildName + " failed: " + KubernetesHelper.getBuildStatusReason((Build)build));
                }
                if (!OpenshiftHelper.isFinished((String)status)) {
                    this.log.warn("Could not wait for the completion of build %s. It may be  may be still running (status=%s)", new Object[]{buildName, status});
                } else {
                    this.log.info("Build %s in status %s", new Object[]{buildName, status});
                }
            }
        }
    }

    private void waitUntilPodIsReady(String podName, int nAwaitTimeout, KitLogger log) {
        final CountDownLatch readyLatch = new CountDownLatch(1);
        try (Watch watch = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.applicableOpenShiftNamespace)).withName(podName)).watch((Watcher)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod aPod) {
                if (KubernetesHelper.isPodReady((Pod)aPod)) {
                    readyLatch.countDown();
                }
            }

            public void onClose(WatcherException e) {
            }
        });){
            readyLatch.await(nAwaitTimeout, TimeUnit.SECONDS);
        }
        catch (KubernetesClientException e) {
            log.error("Could not watch pod", new Object[]{e});
        }
        catch (InterruptedException e) {
            log.error("Could not watch pod (Thread interrupted)", new Object[]{e});
            Thread.currentThread().interrupt();
        }
    }

    private void waitUntilBuildFinished(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Watcher<Build> getBuildWatcher(final CountDownLatch latch, final String buildName, final AtomicReference<Build> buildHolder) {
        return new Watcher<Build>(){
            String lastStatus = "";

            public void eventReceived(Watcher.Action action, Build build) {
                buildHolder.set(build);
                String status = KubernetesHelper.getBuildStatusPhase((Build)build);
                OpenshiftBuildService.this.log.verbose("BuildWatch: Received event %s , build status: %s", new Object[]{action, build.getStatus()});
                if (!this.lastStatus.equals(status)) {
                    this.lastStatus = status;
                    OpenshiftBuildService.this.log.verbose("Build %s status: %s", new Object[]{buildName, status});
                }
                if (OpenshiftHelper.isFinished((String)status)) {
                    latch.countDown();
                }
            }

            public void onClose(WatcherException cause) {
                if (cause != null) {
                    OpenshiftBuildService.this.log.error("Error while watching for build to finish: %s ", new Object[]{cause.getMessage()});
                }
                latch.countDown();
            }
        };
    }

    private void logBuildFailedDetails(OpenShiftClient client, String buildName) {
        try {
            BuildConfig build = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)client.buildConfigs().inNamespace(this.applicableOpenShiftNamespace)).withName(buildName)).get();
            ObjectReference ref = build.getSpec().getStrategy().getSourceStrategy().getFrom();
            String kind = ref.getKind();
            String name = ref.getName();
            if (DOCKER_IMAGE.equals(kind)) {
                this.log.error("Please, ensure that the Docker image '%s' exists and is accessible by OpenShift", new Object[]{name});
            } else if ("ImageStreamTag".equals(kind)) {
                String namespace = ref.getNamespace();
                String namespaceInfo = "current";
                String namespaceParams = "";
                if (namespace != null && !namespace.isEmpty()) {
                    namespaceInfo = "'" + namespace + "'";
                    namespaceParams = " -n " + namespace;
                }
                this.log.error("Please, ensure that the ImageStream Tag '%s' exists in the %s namespace (with 'oc get is%s')", new Object[]{name, namespaceInfo, namespaceParams});
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to get detailed information from the BuildServiceConfig: " + ex.getMessage(), new Object[0]);
        }
    }

    private void logBuildFailure(OpenShiftClient client, String buildName) throws JKubeServiceException {
        block3: {
            try {
                List builds = ((BuildList)((NonNamespaceOperation)client.builds().inNamespace(this.applicableOpenShiftNamespace)).list()).getItems();
                for (Build build : builds) {
                    if (!build.getMetadata().getName().contains(buildName)) continue;
                    this.log.error(build.getMetadata().getName() + "\t\t" + build.getStatus().getReason() + "\t" + build.getStatus().getMessage(), new Object[0]);
                    throw new JKubeServiceException("Unable to build the image using the OpenShift build service", new KubernetesClientException(build.getStatus().getReason() + " " + build.getStatus().getMessage()));
                }
                this.log.error("Also, check cluster events via `oc get events` to see what could have possibly gone wrong", new Object[0]);
            }
            catch (KubernetesClientException clientException) {
                Status status = clientException.getStatus();
                if (status == null) break block3;
                this.log.error("OpenShift Error: [%d] %s", new Object[]{status.getCode(), status.getMessage()});
            }
        }
    }

    private void addImageStreamToFile(File imageStreamFile, ImageName imageName, OpenShiftClient client) throws IOException {
        ImageStreamService imageStreamHandler = new ImageStreamService(client, this.applicableOpenShiftNamespace, this.log);
        imageStreamHandler.appendImageStreamResource(imageName, imageStreamFile);
    }

    private void createAdditionalTags(ImageConfiguration imageConfig, ImageName imageName) {
        List<String> additionalTagsToCreate = OpenShiftBuildServiceUtils.getAdditionalTagsToCreate(imageConfig);
        if (!additionalTagsToCreate.isEmpty()) {
            ImageStreamTag imageStreamTag = (ImageStreamTag)((Resource)((NonNamespaceOperation)this.client.imageStreamTags().inNamespace(this.applicableOpenShiftNamespace)).withName(ImageStreamService.resolveImageStreamTagName(imageName))).get();
            List<ImageStreamTag> imageStreamTags = OpenShiftBuildServiceUtils.createAdditionalTagsIfPresent(imageConfig, this.applicableOpenShiftNamespace, imageStreamTag);
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)this.client.resourceList((HasMetadata[])imageStreamTags.toArray(new ImageStreamTag[0])).inNamespace(this.applicableOpenShiftNamespace)).createOrReplace();
            this.log.info("Tags [%s] set to %s", new Object[]{String.join((CharSequence)",", additionalTagsToCreate), imageName.getNameWithoutTag()});
        }
    }

    private Map<String, Map<String, Quantity>> getRequestsAndLimits() {
        HashMap<String, Map<String, Quantity>> keyToQuantityMap = new HashMap<String, Map<String, Quantity>>();
        if (this.buildServiceConfig.getResourceConfig() != null && this.buildServiceConfig.getResourceConfig().getOpenshiftBuildConfig() != null) {
            Map requests;
            Map limits = KubernetesHelper.getQuantityFromString((Map)this.buildServiceConfig.getResourceConfig().getOpenshiftBuildConfig().getLimits());
            if (!limits.isEmpty()) {
                keyToQuantityMap.put(LIMITS, limits);
            }
            if (!(requests = KubernetesHelper.getQuantityFromString((Map)this.buildServiceConfig.getResourceConfig().getOpenshiftBuildConfig().getRequests())).isEmpty()) {
                keyToQuantityMap.put(REQUESTS, requests);
            }
        }
        return keyToQuantityMap;
    }
}

