/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.service.docker.DockerServiceHub;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.service.AbstractImageBuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackBuildOptions;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackCliDownloader;
import org.eclipse.jkube.kit.service.buildpacks.controller.BuildPackCliController;

public class BuildPackBuildService
extends AbstractImageBuildService {
    private static final String DEFAULT_BUILDER_IMAGE = "paketobuildpacks/builder:base";
    private static final String PACK_CONFIG_DIR = ".pack";
    private static final String PACK_CONFIG_FILE = "config.toml";
    private final BuildServiceConfig buildServiceConfig;
    private final KitLogger kitLogger;
    private final BuildPackCliDownloader buildPackCliDownloader;
    private final DockerServiceHub dockerServiceHub;

    public BuildPackBuildService(JKubeServiceHub jKubeServiceHub) {
        this(jKubeServiceHub, null);
    }

    BuildPackBuildService(JKubeServiceHub jKubeServiceHub, Properties packProperties) {
        super(jKubeServiceHub);
        this.buildServiceConfig = Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.kitLogger = Objects.requireNonNull(jKubeServiceHub.getLog());
        this.buildPackCliDownloader = packProperties == null ? new BuildPackCliDownloader(this.kitLogger) : new BuildPackCliDownloader(this.kitLogger, packProperties);
        this.dockerServiceHub = jKubeServiceHub.getDockerServiceHub();
    }

    @Override
    protected void buildSingleImage(ImageConfiguration imageConfiguration) {
        this.kitLogger.info("Delegating container image building process to BuildPacks", new Object[0]);
        File packCli = this.buildPackCliDownloader.getPackCLIIfPresentOrDownload();
        this.kitLogger.info("Using pack %s", new Object[]{packCli.getAbsolutePath()});
        Properties localPackConfig = PropertiesUtil.readProperties((Path)EnvUtil.getUserHome().toPath().resolve(PACK_CONFIG_DIR).resolve(PACK_CONFIG_FILE));
        String builderImage = localPackConfig.get("default-builder-image") != null ? StringUtils.strip((String)localPackConfig.getProperty("default-builder-image"), (String)"\"") : DEFAULT_BUILDER_IMAGE;
        new BuildPackCliController(packCli, this.kitLogger).build(BuildPackBuildOptions.builder().imageName(imageConfiguration.getName()).builderImage(builderImage).creationTime("now").build());
    }

    @Override
    protected void pushSingleImage(ImageConfiguration imageConfiguration, int retries, RegistryConfig registryConfig, boolean skipTag) throws JKubeServiceException {
        try {
            this.dockerServiceHub.getRegistryService().pushImage(imageConfiguration, retries, registryConfig, skipTag);
        }
        catch (IOException ex) {
            throw new JKubeServiceException("Error while trying to push the image: " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean isApplicable() {
        return this.buildServiceConfig.getJKubeBuildStrategy() != null && this.buildServiceConfig.getJKubeBuildStrategy().equals((Object)JKubeBuildStrategy.buildpacks);
    }

    @Override
    public void postProcess() {
    }
}

