/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.io.File;
import org.eclipse.jkube.kit.build.service.docker.ImagePullManager;
import org.eclipse.jkube.kit.build.service.docker.helper.Task;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;

public class BuildServiceConfig {
    private JKubeBuildStrategy jKubeBuildStrategy;
    private Task<KubernetesListBuilder> enricherTask;
    private String buildDirectory;
    private Attacher attacher;
    private ImagePullManager imagePullManager;
    private ResourceConfig resourceConfig;
    private File resourceDir;

    public void attachArtifact(String classifier, File destFile) {
        if (this.attacher != null) {
            this.attacher.attach(classifier, destFile);
        }
    }

    public static BuildServiceConfigBuilder builder() {
        return new BuildServiceConfigBuilder();
    }

    public BuildServiceConfigBuilder toBuilder() {
        return new BuildServiceConfigBuilder().jKubeBuildStrategy(this.jKubeBuildStrategy).enricherTask(this.enricherTask).buildDirectory(this.buildDirectory).attacher(this.attacher).imagePullManager(this.imagePullManager).resourceConfig(this.resourceConfig).resourceDir(this.resourceDir);
    }

    public BuildServiceConfig(JKubeBuildStrategy jKubeBuildStrategy, Task<KubernetesListBuilder> enricherTask, String buildDirectory, Attacher attacher, ImagePullManager imagePullManager, ResourceConfig resourceConfig, File resourceDir) {
        this.jKubeBuildStrategy = jKubeBuildStrategy;
        this.enricherTask = enricherTask;
        this.buildDirectory = buildDirectory;
        this.attacher = attacher;
        this.imagePullManager = imagePullManager;
        this.resourceConfig = resourceConfig;
        this.resourceDir = resourceDir;
    }

    public BuildServiceConfig() {
    }

    public JKubeBuildStrategy getJKubeBuildStrategy() {
        return this.jKubeBuildStrategy;
    }

    public Task<KubernetesListBuilder> getEnricherTask() {
        return this.enricherTask;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public Attacher getAttacher() {
        return this.attacher;
    }

    public ImagePullManager getImagePullManager() {
        return this.imagePullManager;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public File getResourceDir() {
        return this.resourceDir;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildServiceConfig)) {
            return false;
        }
        BuildServiceConfig other = (BuildServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JKubeBuildStrategy this$jKubeBuildStrategy = this.getJKubeBuildStrategy();
        JKubeBuildStrategy other$jKubeBuildStrategy = other.getJKubeBuildStrategy();
        if (this$jKubeBuildStrategy == null ? other$jKubeBuildStrategy != null : !this$jKubeBuildStrategy.equals(other$jKubeBuildStrategy)) {
            return false;
        }
        Task<KubernetesListBuilder> this$enricherTask = this.getEnricherTask();
        Task<KubernetesListBuilder> other$enricherTask = other.getEnricherTask();
        if (this$enricherTask == null ? other$enricherTask != null : !this$enricherTask.equals(other$enricherTask)) {
            return false;
        }
        String this$buildDirectory = this.getBuildDirectory();
        String other$buildDirectory = other.getBuildDirectory();
        if (this$buildDirectory == null ? other$buildDirectory != null : !this$buildDirectory.equals(other$buildDirectory)) {
            return false;
        }
        Attacher this$attacher = this.getAttacher();
        Attacher other$attacher = other.getAttacher();
        if (this$attacher == null ? other$attacher != null : !this$attacher.equals(other$attacher)) {
            return false;
        }
        ImagePullManager this$imagePullManager = this.getImagePullManager();
        ImagePullManager other$imagePullManager = other.getImagePullManager();
        if (this$imagePullManager == null ? other$imagePullManager != null : !this$imagePullManager.equals(other$imagePullManager)) {
            return false;
        }
        ResourceConfig this$resourceConfig = this.getResourceConfig();
        ResourceConfig other$resourceConfig = other.getResourceConfig();
        if (this$resourceConfig == null ? other$resourceConfig != null : !this$resourceConfig.equals(other$resourceConfig)) {
            return false;
        }
        File this$resourceDir = this.getResourceDir();
        File other$resourceDir = other.getResourceDir();
        return !(this$resourceDir == null ? other$resourceDir != null : !((Object)this$resourceDir).equals(other$resourceDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JKubeBuildStrategy $jKubeBuildStrategy = this.getJKubeBuildStrategy();
        result = result * 59 + ($jKubeBuildStrategy == null ? 43 : $jKubeBuildStrategy.hashCode());
        Task<KubernetesListBuilder> $enricherTask = this.getEnricherTask();
        result = result * 59 + ($enricherTask == null ? 43 : $enricherTask.hashCode());
        String $buildDirectory = this.getBuildDirectory();
        result = result * 59 + ($buildDirectory == null ? 43 : $buildDirectory.hashCode());
        Attacher $attacher = this.getAttacher();
        result = result * 59 + ($attacher == null ? 43 : $attacher.hashCode());
        ImagePullManager $imagePullManager = this.getImagePullManager();
        result = result * 59 + ($imagePullManager == null ? 43 : $imagePullManager.hashCode());
        ResourceConfig $resourceConfig = this.getResourceConfig();
        result = result * 59 + ($resourceConfig == null ? 43 : $resourceConfig.hashCode());
        File $resourceDir = this.getResourceDir();
        result = result * 59 + ($resourceDir == null ? 43 : ((Object)$resourceDir).hashCode());
        return result;
    }

    public static class BuildServiceConfigBuilder {
        private JKubeBuildStrategy jKubeBuildStrategy;
        private Task<KubernetesListBuilder> enricherTask;
        private String buildDirectory;
        private Attacher attacher;
        private ImagePullManager imagePullManager;
        private ResourceConfig resourceConfig;
        private File resourceDir;

        BuildServiceConfigBuilder() {
        }

        public BuildServiceConfigBuilder jKubeBuildStrategy(JKubeBuildStrategy jKubeBuildStrategy) {
            this.jKubeBuildStrategy = jKubeBuildStrategy;
            return this;
        }

        public BuildServiceConfigBuilder enricherTask(Task<KubernetesListBuilder> enricherTask) {
            this.enricherTask = enricherTask;
            return this;
        }

        public BuildServiceConfigBuilder buildDirectory(String buildDirectory) {
            this.buildDirectory = buildDirectory;
            return this;
        }

        public BuildServiceConfigBuilder attacher(Attacher attacher) {
            this.attacher = attacher;
            return this;
        }

        public BuildServiceConfigBuilder imagePullManager(ImagePullManager imagePullManager) {
            this.imagePullManager = imagePullManager;
            return this;
        }

        public BuildServiceConfigBuilder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public BuildServiceConfigBuilder resourceDir(File resourceDir) {
            this.resourceDir = resourceDir;
            return this;
        }

        public BuildServiceConfig build() {
            return new BuildServiceConfig(this.jKubeBuildStrategy, this.enricherTask, this.buildDirectory, this.attacher, this.imagePullManager, this.resourceConfig, this.resourceDir);
        }

        public String toString() {
            return "BuildServiceConfig.BuildServiceConfigBuilder(jKubeBuildStrategy=" + this.jKubeBuildStrategy + ", enricherTask=" + this.enricherTask + ", buildDirectory=" + this.buildDirectory + ", attacher=" + this.attacher + ", imagePullManager=" + this.imagePullManager + ", resourceConfig=" + this.resourceConfig + ", resourceDir=" + this.resourceDir + ")";
        }
    }

    public static interface Attacher {
        public void attach(String var1, File var2);
    }
}

