/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.openshift;

import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.assembly.ArchiverCustomizer;
import org.eclipse.jkube.kit.build.api.helper.BuildArgResolverUtil;
import org.eclipse.jkube.kit.build.api.helper.BuildUtil;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.util.IoUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.openshift.ImageStreamService;

public class OpenShiftBuildServiceUtils {
    private OpenShiftBuildServiceUtils() {
    }

    protected static File createBuildArchive(JKubeServiceHub jKubeServiceHub, ImageConfiguration imageConfig) throws JKubeServiceException {
        ArchiverCustomizer customizer = OpenShiftBuildServiceUtils.createS2IArchiveCustomizer(jKubeServiceHub.getBuildServiceConfig(), imageConfig);
        try {
            return jKubeServiceHub.getDockerServiceHub().getArchiveService().createDockerBuildArchive(imageConfig, jKubeServiceHub.getConfiguration(), customizer);
        }
        catch (IOException e) {
            throw new JKubeServiceException("Unable to create the build archive", e);
        }
    }

    static String computeS2IBuildName(ImageConfiguration imageConfiguration, BuildServiceConfig config, ImageName imageName) {
        StringBuilder s2IBuildName = new StringBuilder(ImageStreamService.resolveImageStreamName(imageName));
        if (!StringUtils.isEmpty((CharSequence)imageConfiguration.getBuild().getOpenshiftS2iBuildNameSuffix())) {
            s2IBuildName.append(imageConfiguration.getBuild().getOpenshiftS2iBuildNameSuffix());
        } else if (config.getJKubeBuildStrategy() == JKubeBuildStrategy.s2i) {
            s2IBuildName.append("-s2i");
        }
        return s2IBuildName.toString();
    }

    private static ArchiverCustomizer createS2IArchiveCustomizer(BuildServiceConfig buildServiceConfig, ImageConfiguration imageConfiguration) throws JKubeServiceException {
        try {
            if (imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getEnv() != null) {
                String fileName = IoUtil.sanitizeFileName((String)("s2i-env-" + imageConfiguration.getName()));
                File environmentFile = new File(buildServiceConfig.getBuildDirectory(), fileName);
                try (PrintWriter out = new PrintWriter(new FileWriter(environmentFile));){
                    for (Map.Entry e : imageConfiguration.getBuildConfiguration().getEnv().entrySet()) {
                        out.println((String)e.getKey() + "=" + (String)e.getValue());
                    }
                }
                return tarArchiver -> {
                    tarArchiver.includeFile(environmentFile, ".s2i/environment");
                    return tarArchiver;
                };
            }
            return null;
        }
        catch (IOException e) {
            throw new JKubeServiceException("Unable to add environment variables to the S2I build archive", e);
        }
    }

    protected static BuildStrategy createBuildStrategy(JKubeServiceHub jKubeServiceHub, ImageConfiguration imageConfig, String openshiftPullSecret) {
        BuildServiceConfig config = jKubeServiceHub.getBuildServiceConfig();
        JKubeBuildStrategy osBuildStrategy = config.getJKubeBuildStrategy();
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        Map fromExt = buildConfig.getFromExt();
        String fromName = buildConfig.isDockerFileMode() ? BuildUtil.extractBaseFromDockerfile((JKubeConfiguration)jKubeServiceHub.getConfiguration(), (BuildConfiguration)buildConfig) : OpenShiftBuildServiceUtils.getMapValueWithDefault((Map<String, String>)fromExt, JKubeBuildStrategy.SourceStrategy.name, buildConfig.getFrom());
        String fromKind = OpenShiftBuildServiceUtils.getMapValueWithDefault((Map<String, String>)fromExt, JKubeBuildStrategy.SourceStrategy.kind, "DockerImage");
        String fromNamespace = OpenShiftBuildServiceUtils.getMapValueWithDefault((Map<String, String>)fromExt, JKubeBuildStrategy.SourceStrategy.namespace, "ImageStreamTag".equals(fromKind) ? "openshift" : null);
        if (osBuildStrategy == JKubeBuildStrategy.docker) {
            BuildStrategy buildStrategy = ((BuildStrategyBuilder)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildStrategyFluent.DockerStrategyNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((DockerBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).withNewDockerStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).withEnv(OpenShiftBuildServiceUtils.checkForEnv(imageConfig))).withBuildArgs(BuildArgResolverUtil.mergeBuildArgsWithoutLocalDockerConfigProxySettings((ImageConfiguration)imageConfig, (JKubeConfiguration)jKubeServiceHub.getConfiguration()).entrySet().stream().map(bcArg -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)bcArg.getKey())).withValue((String)bcArg.getValue())).build()).collect(Collectors.toList()))).withNoCache(Boolean.valueOf(OpenShiftBuildServiceUtils.checkForNocache(imageConfig)))).endDockerStrategy()).build();
            if (openshiftPullSecret != null) {
                buildStrategy.getDockerStrategy().setPullSecret(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(openshiftPullSecret)).build());
            }
            return buildStrategy;
        }
        if (osBuildStrategy == JKubeBuildStrategy.s2i) {
            BuildStrategy buildStrategy = ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).withForcePull(Boolean.valueOf(imageConfig.getBuild().isOpenshiftForcePull()))).endSourceStrategy()).build();
            if (openshiftPullSecret != null) {
                buildStrategy.getSourceStrategy().setPullSecret(((LocalObjectReferenceBuilder)new LocalObjectReferenceBuilder().withName(openshiftPullSecret)).build());
            }
            return buildStrategy;
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + osBuildStrategy);
    }

    protected static BuildOutput createBuildOutput(ImageConfiguration imageConfiguration, ImageName imageName) {
        String buildOutputKind = Optional.ofNullable(imageConfiguration.getBuild().getOpenshiftBuildOutputKind()).orElse("ImageStreamTag");
        String outputImageStreamTag = ImageStreamService.resolveImageStreamName(imageName) + ":" + (imageName.getTag() != null ? imageName.getTag() : "latest");
        BuildOutputBuilder buildOutputBuilder = new BuildOutputBuilder();
        ((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)buildOutputBuilder.withNewTo().withKind(buildOutputKind)).withName(outputImageStreamTag)).endTo();
        if ("DockerImage".equals(buildOutputKind)) {
            ((BuildOutputFluent.ToNested)buildOutputBuilder.editTo().withName(imageName.getFullName())).endTo();
        }
        if (StringUtils.isNotBlank((CharSequence)imageConfiguration.getBuild().getOpenshiftPushSecret())) {
            ((BuildOutputFluent.PushSecretNested)buildOutputBuilder.withNewPushSecret().withName(imageConfiguration.getBuild().getOpenshiftPushSecret())).endPushSecret();
        }
        return buildOutputBuilder.build();
    }

    protected static BuildConfigSpec getBuildConfigSpec(BuildConfig buildConfig) {
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        return spec;
    }

    protected static List<ImageStreamTag> createAdditionalTagsIfPresent(ImageConfiguration imageConfiguration, String namespace, ImageStreamTag imageStreamTag) {
        ArrayList<ImageStreamTag> imageStreamTags = new ArrayList<ImageStreamTag>();
        ImageName imageName = new ImageName(imageConfiguration.getName());
        for (String tag : OpenShiftBuildServiceUtils.getAdditionalTagsToCreate(imageConfiguration)) {
            imageStreamTags.add(OpenShiftBuildServiceUtils.createNewImageStreamTag(ImageStreamService.resolveImageStreamName(imageName) + ":" + tag, namespace, imageStreamTag));
        }
        return imageStreamTags;
    }

    protected static List<String> getAdditionalTagsToCreate(ImageConfiguration imageConfiguration) {
        if (imageConfiguration != null && imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getTags() != null) {
            ImageName imageName = new ImageName(imageConfiguration.getName());
            return imageConfiguration.getBuildConfiguration().getTags().stream().filter(t -> !t.equals(imageName.getTag())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected static ImageStreamTag createNewImageStreamTag(String name, String namespace, ImageStreamTag orignalImageStreamTag) {
        return ((ImageStreamTagBuilder)((ImageStreamTagBuilder)((ImageStreamTagFluent.TagNested)((TagReferenceFluent.FromNested)((TagReferenceFluent.FromNested)((ImageStreamTagBuilder)((ImageStreamTagFluent.MetadataNested)((ImageStreamTagFluent.MetadataNested)((ImageStreamTagFluent.MetadataNested)((ImageStreamTagFluent.MetadataNested)new ImageStreamTagBuilder().withNewMetadata().withLabels(orignalImageStreamTag.getMetadata().getLabels())).withAnnotations(orignalImageStreamTag.getMetadata().getAnnotations())).withName(name)).withNamespace(namespace)).endMetadata()).withNewTag().withNewFrom().withKind("DockerImage")).withName(orignalImageStreamTag.getImage().getDockerImageReference())).endFrom()).endTag()).withGeneration(Long.valueOf(0L))).build();
    }

    private static String getMapValueWithDefault(Map<String, String> map, JKubeBuildStrategy.SourceStrategy strategy, String defaultValue) {
        return OpenShiftBuildServiceUtils.getMapValueWithDefault(map, strategy.key(), defaultValue);
    }

    private static String getMapValueWithDefault(Map<String, String> map, String field, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(field);
        return value != null ? value : defaultValue;
    }

    private static boolean checkForNocache(ImageConfiguration imageConfig) {
        String nocache = System.getProperty("docker.nocache");
        if (nocache != null) {
            return nocache.isEmpty() || Boolean.parseBoolean(nocache);
        }
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        return buildConfig.nocache();
    }

    private static List<EnvVar> checkForEnv(ImageConfiguration imageConfiguration) {
        BuildConfiguration buildImageConfiguration = imageConfiguration.getBuildConfiguration();
        if (buildImageConfiguration.getArgs() != null) {
            return KubernetesHelper.convertToEnvVarList((Map)buildImageConfiguration.getArgs());
        }
        return Collections.emptyList();
    }
}

