/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.jkube.kit.build.service.docker.DockerServiceHub;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.service.MigrateService;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.resource.ResourceService;
import org.eclipse.jkube.kit.config.resource.ResourceServiceConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.BuildServiceManager;
import org.eclipse.jkube.kit.config.service.DebugService;
import org.eclipse.jkube.kit.config.service.PortForwardService;
import org.eclipse.jkube.kit.config.service.UndeployService;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesUndeployService;
import org.eclipse.jkube.kit.config.service.openshift.OpenshiftUndeployService;
import org.eclipse.jkube.kit.config.service.plugins.PluginManager;
import org.eclipse.jkube.kit.resource.helm.HelmService;

public class JKubeServiceHub
implements Closeable {
    private final JKubeConfiguration configuration;
    private final KitLogger log;
    private final DockerServiceHub dockerServiceHub;
    private final BuildServiceConfig buildServiceConfig;
    private final ResourceServiceConfig resourceServiceConfig;
    private RuntimeMode platformMode;
    private LazyBuilder<JKubeServiceHub, BuildServiceManager> buildServiceManager;
    private LazyBuilder<JKubeServiceHub, PluginManager> pluginManager;
    private final LazyBuilder<JKubeServiceHub, ResourceService> resourceService;
    private LazyBuilder<JKubeServiceHub, PortForwardService> portForwardService;
    private LazyBuilder<JKubeServiceHub, ApplyService> applyService;
    private LazyBuilder<JKubeServiceHub, UndeployService> undeployService;
    private LazyBuilder<JKubeServiceHub, MigrateService> migrateService;
    private LazyBuilder<JKubeServiceHub, DebugService> debugService;
    private LazyBuilder<JKubeServiceHub, HelmService> helmService;
    private LazyBuilder<JKubeServiceHub, KubernetesClient> kubernetesClientLazyBuilder;
    private final boolean offline;

    public JKubeServiceHub(RuntimeMode platformMode, KitLogger log, DockerServiceHub dockerServiceHub, JKubeConfiguration configuration, BuildServiceConfig buildServiceConfig, ResourceServiceConfig resourceServiceConfig, LazyBuilder<JKubeServiceHub, ResourceService> resourceService, boolean offline) {
        this.platformMode = platformMode;
        this.log = log;
        this.dockerServiceHub = dockerServiceHub;
        this.configuration = configuration;
        this.buildServiceConfig = buildServiceConfig;
        this.resourceServiceConfig = resourceServiceConfig;
        this.resourceService = resourceService;
        this.offline = offline;
        this.init();
    }

    @Override
    public void close() {
        if (this.kubernetesClientLazyBuilder.hasInstance()) {
            ((KubernetesClient)this.kubernetesClientLazyBuilder.get((Object)this)).close();
        }
        Optional.ofNullable(this.dockerServiceHub).map(DockerServiceHub::getDockerAccess).ifPresent(DockerAccess::shutdown);
    }

    private void init() {
        Objects.requireNonNull(this.configuration, "JKubeConfiguration is required");
        Objects.requireNonNull(this.log, "log is a required parameter");
        Objects.requireNonNull(this.platformMode, "platformMode is a required parameter");
        this.initLazyBuilders();
    }

    private void initLazyBuilders() {
        this.kubernetesClientLazyBuilder = new LazyBuilder(hub -> this.initKubernetesClientIfNecessary());
        this.buildServiceManager = new LazyBuilder(BuildServiceManager::new);
        this.pluginManager = new LazyBuilder(PluginManager::new);
        this.applyService = new LazyBuilder(ApplyService::new);
        this.portForwardService = new LazyBuilder(hub -> {
            this.getClient();
            return new PortForwardService(this.log);
        });
        this.debugService = new LazyBuilder(hub -> new DebugService(this.log, this.getClient(), (PortForwardService)this.portForwardService.get(hub), (ApplyService)this.applyService.get(hub)));
        this.undeployService = new LazyBuilder(hub -> {
            KubernetesClient client = this.getClient();
            if (this.platformMode == RuntimeMode.OPENSHIFT && OpenshiftHelper.isOpenShift((KubernetesClient)client)) {
                return new OpenshiftUndeployService((JKubeServiceHub)hub, this.log);
            }
            return new KubernetesUndeployService((JKubeServiceHub)hub, this.log);
        });
        this.migrateService = new LazyBuilder(hub -> new MigrateService(this.getConfiguration().getBasedir(), this.log));
        this.helmService = new LazyBuilder(hub -> new HelmService(hub.getConfiguration(), hub.getResourceServiceConfig(), this.log));
    }

    private KubernetesClient initKubernetesClientIfNecessary() {
        if (this.offline) {
            throw new IllegalArgumentException("Connection to Cluster required. Please check if offline mode is set to false");
        }
        return new KubernetesClientBuilder().withConfig(this.configuration.getClusterConfiguration().getConfig()).build();
    }

    public RuntimeMode getRuntimeMode() {
        return this.platformMode;
    }

    public BuildService getBuildService() {
        return ((BuildServiceManager)this.buildServiceManager.get((Object)this)).resolveBuildService();
    }

    public PluginManager getPluginManager() {
        return (PluginManager)this.pluginManager.get((Object)this);
    }

    public ResourceService getResourceService() {
        return (ResourceService)this.resourceService.get((Object)this);
    }

    public ApplyService getApplyService() {
        return (ApplyService)this.applyService.get((Object)this);
    }

    public UndeployService getUndeployService() {
        return (UndeployService)this.undeployService.get((Object)this);
    }

    public MigrateService getMigrateService() {
        return (MigrateService)this.migrateService.get((Object)this);
    }

    public PortForwardService getPortForwardService() {
        return (PortForwardService)this.portForwardService.get((Object)this);
    }

    public DebugService getDebugService() {
        return (DebugService)this.debugService.get((Object)this);
    }

    public HelmService getHelmService() {
        return (HelmService)this.helmService.get((Object)this);
    }

    public KubernetesClient getClient() {
        return (KubernetesClient)this.kubernetesClientLazyBuilder.get((Object)this);
    }

    @Generated
    public static JKubeServiceHubBuilder builder() {
        return new JKubeServiceHubBuilder();
    }

    @Generated
    public JKubeServiceHubBuilder toBuilder() {
        return new JKubeServiceHubBuilder().platformMode(this.platformMode).log(this.log).dockerServiceHub(this.dockerServiceHub).configuration(this.configuration).buildServiceConfig(this.buildServiceConfig).resourceServiceConfig(this.resourceServiceConfig).resourceService(this.resourceService).offline(this.offline);
    }

    @Generated
    public JKubeConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public KitLogger getLog() {
        return this.log;
    }

    @Generated
    public DockerServiceHub getDockerServiceHub() {
        return this.dockerServiceHub;
    }

    @Generated
    public BuildServiceConfig getBuildServiceConfig() {
        return this.buildServiceConfig;
    }

    @Generated
    public ResourceServiceConfig getResourceServiceConfig() {
        return this.resourceServiceConfig;
    }

    @Generated
    public RuntimeMode getPlatformMode() {
        return this.platformMode;
    }

    @Generated
    public void setPlatformMode(RuntimeMode platformMode) {
        this.platformMode = platformMode;
    }

    @Generated
    public static class JKubeServiceHubBuilder {
        @Generated
        private RuntimeMode platformMode;
        @Generated
        private KitLogger log;
        @Generated
        private DockerServiceHub dockerServiceHub;
        @Generated
        private JKubeConfiguration configuration;
        @Generated
        private BuildServiceConfig buildServiceConfig;
        @Generated
        private ResourceServiceConfig resourceServiceConfig;
        @Generated
        private LazyBuilder<JKubeServiceHub, ResourceService> resourceService;
        @Generated
        private boolean offline;

        @Generated
        JKubeServiceHubBuilder() {
        }

        @Generated
        public JKubeServiceHubBuilder platformMode(RuntimeMode platformMode) {
            this.platformMode = platformMode;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder log(KitLogger log) {
            this.log = log;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder dockerServiceHub(DockerServiceHub dockerServiceHub) {
            this.dockerServiceHub = dockerServiceHub;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder configuration(JKubeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder buildServiceConfig(BuildServiceConfig buildServiceConfig) {
            this.buildServiceConfig = buildServiceConfig;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder resourceServiceConfig(ResourceServiceConfig resourceServiceConfig) {
            this.resourceServiceConfig = resourceServiceConfig;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder resourceService(LazyBuilder<JKubeServiceHub, ResourceService> resourceService) {
            this.resourceService = resourceService;
            return this;
        }

        @Generated
        public JKubeServiceHubBuilder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        @Generated
        public JKubeServiceHub build() {
            return new JKubeServiceHub(this.platformMode, this.log, this.dockerServiceHub, this.configuration, this.buildServiceConfig, this.resourceServiceConfig, this.resourceService, this.offline);
        }

        @Generated
        public String toString() {
            return "JKubeServiceHub.JKubeServiceHubBuilder(platformMode=" + this.platformMode + ", log=" + this.log + ", dockerServiceHub=" + this.dockerServiceHub + ", configuration=" + this.configuration + ", buildServiceConfig=" + this.buildServiceConfig + ", resourceServiceConfig=" + this.resourceServiceConfig + ", resourceService=" + this.resourceService + ", offline=" + this.offline + ")";
        }
    }
}

