/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.ingresscontroller;

import io.fabric8.kubernetes.api.model.networking.v1.IngressClassList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerList;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Objects;
import org.eclipse.jkube.kit.common.IngressControllerDetector;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;

public class OpenShiftIngressControllerDetector
implements IngressControllerDetector {
    private final KubernetesClient client;
    private static final String INGRESS_OPENSHIFT_NAMESPACE = "openshift-ingress-operator";

    public OpenShiftIngressControllerDetector(KubernetesClient client) {
        this.client = client;
    }

    public boolean hasIngressClass() {
        return ((IngressClassList)this.client.network().v1().ingressClasses().list()).getItems().stream().anyMatch(i -> i.getSpec().getController().equals("openshift.io/ingress-to-route"));
    }

    public boolean isIngressControllerReady() {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.client)) {
            OpenShiftClient openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
            return ((IngressControllerList)((NonNamespaceOperation)openShiftClient.operator().ingressControllers().inNamespace(INGRESS_OPENSHIFT_NAMESPACE)).list()).getItems().stream().anyMatch(o -> Objects.equals(o.getSpec().getReplicas(), o.getStatus().getAvailableReplicas()));
        }
        return false;
    }

    public boolean hasPermissions() {
        return KubernetesHelper.hasAccessForAction((KubernetesClient)this.client, null, (String)"networking.k8s.io", (String)"ingressclasses", (String)"list") && KubernetesHelper.hasAccessForAction((KubernetesClient)this.client, (String)INGRESS_OPENSHIFT_NAMESPACE, (String)"operator.openshift.io", (String)"ingresscontrollers", (String)"list");
    }
}

