/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import java.io.File;
import java.util.Objects;
import org.eclipse.jkube.kit.build.api.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.build.service.docker.auth.DockerAuthConfigFactory;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.service.AbstractImageBuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.service.jib.JibLogger;
import org.eclipse.jkube.kit.service.jib.JibService;

public class JibImageBuildService
extends AbstractImageBuildService {
    private final KitLogger kitLogger;
    private final JibLogger jibLogger;
    private final DockerAuthConfigFactory authConfigFactory;
    private final BuildServiceConfig buildServiceConfig;
    private final JKubeConfiguration configuration;

    public JibImageBuildService(JKubeServiceHub jKubeServiceHub) {
        this(jKubeServiceHub, new JibLogger(Objects.requireNonNull(jKubeServiceHub.getLog(), "Log is required")));
    }

    public JibImageBuildService(JKubeServiceHub jKubeServiceHub, JibLogger jibLogger) {
        super(jKubeServiceHub);
        this.jibLogger = jibLogger;
        this.kitLogger = jKubeServiceHub.getLog();
        this.authConfigFactory = new DockerAuthConfigFactory(this.kitLogger);
        this.buildServiceConfig = Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.configuration = Objects.requireNonNull(jKubeServiceHub.getConfiguration(), "JKubeConfiguration is required");
    }

    @Override
    public boolean isApplicable() {
        return this.buildServiceConfig.getJKubeBuildStrategy() == JKubeBuildStrategy.jib;
    }

    @Override
    public void buildSingleImage(ImageConfiguration imageConfiguration) throws JKubeServiceException {
        if (imageConfiguration.getBuildConfiguration().isDockerFileMode()) {
            throw new JKubeServiceException("Dockerfile mode is not supported with JIB build strategy");
        }
        this.kitLogger.info("[[B]]JIB[[B]] image build started", new Object[0]);
        try (JibService jibService = new JibService(this.jibLogger, (AuthConfigFactory)this.authConfigFactory, this.configuration, imageConfiguration);){
            for (File dockerTarArchive : jibService.build()) {
                this.kitLogger.info(" %s successfully built", new Object[]{dockerTarArchive.getAbsolutePath()});
            }
        }
        catch (Exception ex) {
            throw new JKubeServiceException("Error when building JIB image", ex);
        }
    }

    @Override
    protected void pushSingleImage(ImageConfiguration imageConfiguration, int retries, boolean skipTag) throws JKubeServiceException {
        try (JibService jibService = new JibService(this.jibLogger, (AuthConfigFactory)this.authConfigFactory, this.configuration, imageConfiguration);){
            this.kitLogger.info("Pushing image: %s", new Object[]{jibService.getImageName().getFullName()});
            jibService.push();
        }
        catch (Exception ex) {
            throw new JKubeServiceException("Error when pushing JIB image", ex);
        }
    }

    @Override
    public void postProcess() {
    }
}

