/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.portforward;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;

public class PortForwardMonitor
implements Watcher<Pod> {
    private final KitLogger logger;
    private final String podName;
    private final CountDownLatch podAvailableLatch;

    public void eventReceived(Watcher.Action action, Pod pod) {
        if (!this.podName.equals(pod.getMetadata().getName())) {
            return;
        }
        if (action == Watcher.Action.DELETED || pod.getMetadata().getDeletionTimestamp() != null) {
            this.logger.error("Pod %s no longer available", new Object[]{this.podName});
            this.podAvailableLatch.countDown();
        }
        if (!KubernetesHelper.isPodRunning((Pod)pod)) {
            this.logger.error("Pod %s no longer in Running state", new Object[]{this.podName});
            this.podAvailableLatch.countDown();
        }
    }

    public void onClose() {
        this.podAvailableLatch.countDown();
    }

    public void onClose(WatcherException cause) {
        this.logger.error("Error in getting Debug Pod details from Kubernetes API: %s", new Object[]{cause.getMessage()});
        this.podAvailableLatch.countDown();
    }

    @Generated
    public PortForwardMonitor(KitLogger logger, String podName, CountDownLatch podAvailableLatch) {
        this.logger = logger;
        this.podName = podName;
        this.podAvailableLatch = podAvailableLatch;
    }
}

