/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import java.util.Collection;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.service.BuildService;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;

public abstract class AbstractImageBuildService
implements BuildService {
    private final JKubeServiceHub jKubeServiceHub;

    protected AbstractImageBuildService(JKubeServiceHub jKubeServiceHub) {
        this.jKubeServiceHub = jKubeServiceHub;
    }

    protected abstract void buildSingleImage(ImageConfiguration var1) throws JKubeServiceException;

    protected abstract void pushSingleImage(ImageConfiguration var1, int var2, boolean var3) throws JKubeServiceException;

    @Override
    public final void build(ImageConfiguration ... imageConfigurations) throws JKubeServiceException {
        this.jKubeServiceHub.getPluginManager().resolvePluginService().addExtraFiles();
        this.processImage(this::buildSingleImage, "Skipped building", imageConfigurations);
    }

    @Override
    public final void push(Collection<ImageConfiguration> imageConfigs, int retries, boolean skipTag) throws JKubeServiceException {
        this.processImage(imageConfiguration -> this.pushSingleImage(imageConfiguration, retries, skipTag), "Skipped push", imageConfigs.toArray(new ImageConfiguration[0]));
    }

    private void processImage(ImageConfigurationProcessor imageConfigurationConsumer, String skipMessage, ImageConfiguration ... imageConfigurations) throws JKubeServiceException {
        if (imageConfigurations != null) {
            for (ImageConfiguration imageConfiguration : imageConfigurations) {
                if (imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getSkip().booleanValue()) {
                    this.jKubeServiceHub.getLog().info("%s : %s", new Object[]{imageConfiguration.getDescription(), skipMessage});
                    continue;
                }
                if (imageConfiguration.getBuildConfiguration() == null) {
                    this.jKubeServiceHub.getLog().info("%s : %s (Image configuration has no build settings)", new Object[]{imageConfiguration.getDescription(), skipMessage});
                    continue;
                }
                imageConfigurationConsumer.process(imageConfiguration);
            }
        }
    }

    @FunctionalInterface
    private static interface ImageConfigurationProcessor {
        public void process(ImageConfiguration var1) throws JKubeServiceException;
    }
}

