/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.UserConfigurationCompare;

public class PatchService {
    private final KubernetesClient kubernetesClient;
    private static final Map<String, EntityPatcher<? extends HasMetadata>> patchers = new HashMap<String, EntityPatcher<? extends HasMetadata>>();

    public PatchService(KubernetesClient client) {
        this.kubernetesClient = client;
    }

    public <T extends HasMetadata> T compareAndPatchEntity(String namespace, T newDto, T oldDto) {
        EntityPatcher<? extends HasMetadata> dispatcher = patchers.get(newDto.getKind());
        if (dispatcher == null) {
            throw new IllegalArgumentException("Internal: No patcher for " + newDto.getKind() + " found");
        }
        newDto.getMetadata().setResourceVersion(oldDto.getMetadata().getResourceVersion());
        return (T)dispatcher.patch(this.kubernetesClient, namespace, newDto, oldDto);
    }

    private static EntityPatcher<ReplicationController> rcPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            ReplicationControllerBuilder entity = new ReplicationControllerBuilder((ReplicationController)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).get());
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit(p -> entity.build());
        };
    }

    private static EntityPatcher<PersistentVolumeClaim> pvcPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            PersistentVolumeClaimBuilder entity = new PersistentVolumeClaimBuilder((PersistentVolumeClaim)((Resource)((NonNamespaceOperation)client.persistentVolumeClaims().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).get());
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)client.persistentVolumeClaims().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit(p -> entity.build());
        };
    }

    private static EntityPatcher<Job> jobPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            JobBuilder entity = new JobBuilder((Job)((ScalableResource)client.batch().v1().jobs().withName(oldObj.getMetadata().getName())).get());
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec().getSelector(), (Object)oldObj.getSpec().getSelector())) {
                entity.editSpec().withSelector(newObj.getSpec().getSelector());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec().getTemplate(), (Object)oldObj.getSpec().getSelector())) {
                entity.editSpec().withTemplate(newObj.getSpec().getTemplate());
            }
            return (Job)((ScalableResource)client.batch().v1().jobs().withName(oldObj.getMetadata().getName())).edit(p -> entity.build());
        };
    }

    private static EntityPatcher<BuildConfig> bcPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            OpenShiftClient openShiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)client);
            if (openShiftClient == null) {
                throw new IllegalArgumentException("BuildConfig can only be patched when connected to an OpenShift cluster");
            }
            BuildConfigBuilder entity = new BuildConfigBuilder((BuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).get());
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit(p -> entity.build());
        };
    }

    private static EntityPatcher<ImageStream> isPatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            OpenShiftClient openShiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)client);
            if (openShiftClient == null) {
                throw new IllegalArgumentException("ImageStream can only be patched when connected to an OpenShift cluster");
            }
            ImageStreamBuilder entity = new ImageStreamBuilder((ImageStream)((Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).get());
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return (ImageStream)((Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit(p -> entity.build());
        };
    }

    private static EntityPatcher<Route> routePatcher() {
        return (client, namespace, newObj, oldObj) -> {
            if (UserConfigurationCompare.configEqual((Object)newObj, (Object)oldObj)) {
                return oldObj;
            }
            OpenShiftClient openShiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)client);
            if (openShiftClient == null) {
                throw new IllegalArgumentException("Route can only be patched when connected to an OpenShift cluster");
            }
            RouteBuilder entity = new RouteBuilder((Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).get());
            if (!UserConfigurationCompare.configEqual((Object)newObj.getMetadata(), (Object)oldObj.getMetadata())) {
                entity.withMetadata(newObj.getMetadata());
            }
            if (!UserConfigurationCompare.configEqual((Object)newObj.getSpec(), (Object)oldObj.getSpec())) {
                entity.withSpec(newObj.getSpec());
            }
            return (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).withName(oldObj.getMetadata().getName())).edit(p -> entity.build());
        };
    }

    static {
        patchers.put("ReplicationController", PatchService.rcPatcher());
        patchers.put("BuildConfig", PatchService.bcPatcher());
        patchers.put("ImageStream", PatchService.isPatcher());
        patchers.put("PersistentVolumeClaim", PatchService.pvcPatcher());
        patchers.put("Job", PatchService.jobPatcher());
        patchers.put("Route", PatchService.routePatcher());
    }

    static interface EntityPatcher<T extends HasMetadata> {
        public T patch(KubernetesClient var1, String var2, T var3, T var4);
    }
}

