/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.service.portforward.PortForwardTask;

public class PortForwardService {
    private final KitLogger log;

    public PortForwardService(KitLogger log) {
        this.log = Objects.requireNonNull(log, "log");
    }

    public Closeable forwardPortAsync(final NamespacedKubernetesClient kubernetes, LabelSelector podSelector, final int containerPort, final int localPort) {
        Pod newPod;
        final ReentrantLock monitor = new ReentrantLock(true);
        final Condition podChanged = monitor.newCondition();
        final Pod[] nextForwardedPod = new Pod[1];
        Thread forwarderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                currentPod = null;
                currentPortForward = null;
                try {
                    monitor.lock();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if (PortForwardService.access$000(PortForwardService.this, currentPod, nextForwardedPod[0])) {
                            podChanged.await();
                            continue;
                        }
                        nextPod = nextForwardedPod[0];
                        try {
                            monitor.unlock();
                            if (currentPortForward != null) {
                                PortForwardService.access$100(PortForwardService.this).info("Closing port-forward from pod %s", new Object[]{KubernetesHelper.getName(currentPod)});
                                currentPortForward.close();
                                currentPortForward = null;
                            }
                            if (nextPod != null) {
                                PortForwardService.access$100(PortForwardService.this).info("Starting port-forward to pod %s", new Object[]{KubernetesHelper.getName((HasMetadata)nextPod)});
                                currentPortForward = PortForwardService.forwardPortAsync(kubernetes, KubernetesHelper.getName((HasMetadata)nextPod), containerPort, localPort);
                            } else {
                                PortForwardService.access$100(PortForwardService.this).info("Waiting for a pod to become ready before starting port-forward", new Object[0]);
                            }
                            currentPod = nextPod;
                        }
                        finally {
                            monitor.lock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    PortForwardService.access$100(PortForwardService.this).debug("Port-forwarding thread interrupted", new Object[]{e});
                    Thread.currentThread().interrupt();
                    monitor.unlock();
                    if (currentPortForward != null) {
                        try {
                            currentPortForward.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    try {
                        PortForwardService.access$100(PortForwardService.this).warn("Error while port-forwarding to pod", new Object[]{e});
                    }
                    catch (Throwable var5_9) {
                        throw var5_9;
                    }
                    finally {
                        monitor.unlock();
                        if (currentPortForward != null) {
                            try {
                                currentPortForward.close();
                            }
                            catch (Exception var3_7) {}
                        }
                    }
                }
                ** GOTO lbl-1000
            }
        };
        nextForwardedPod[0] = newPod = this.getNewestPod(kubernetes, podSelector);
        Watch watch = KubernetesHelper.withSelector((NonNamespaceOperation)kubernetes.pods(), (LabelSelector)podSelector, (KitLogger)this.log).watch((Watcher)new Watcher<Pod>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void eventReceived(Watcher.Action action, Pod pod) {
                monitor.lock();
                try {
                    List<Pod> candidatePods;
                    if (nextForwardedPod[0] != null) {
                        candidatePods = new LinkedList<Pod>();
                        candidatePods.add(nextForwardedPod[0]);
                        candidatePods.add(pod);
                    } else {
                        candidatePods = Collections.singletonList(pod);
                    }
                    Pod newPod = KubernetesHelper.getNewestPod(candidatePods);
                    if (!PortForwardService.this.podEquals(nextForwardedPod[0], newPod)) {
                        nextForwardedPod[0] = newPod;
                        podChanged.signal();
                    }
                }
                finally {
                    monitor.unlock();
                }
            }

            public void onClose(WatcherException e) {
            }
        });
        forwarderThread.start();
        Closeable handle = () -> {
            try {
                watch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                forwarderThread.interrupt();
                forwarderThread.join(15000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                handle.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        return handle;
    }

    private boolean podEquals(Pod pod1, Pod pod2) {
        if (pod1 == pod2) {
            return true;
        }
        if (pod1 == null || pod2 == null) {
            return false;
        }
        return KubernetesHelper.getName((HasMetadata)pod1).equals(KubernetesHelper.getName((HasMetadata)pod2));
    }

    private Pod getNewestPod(NamespacedKubernetesClient kubernetes, LabelSelector selector) {
        FilterWatchListDeletable pods = KubernetesHelper.withSelector((NonNamespaceOperation)kubernetes.pods(), (LabelSelector)selector, (KitLogger)this.log);
        PodList list = (PodList)pods.list();
        if (list != null) {
            List items = list.getItems();
            return KubernetesHelper.getNewestPod((Collection)items);
        }
        return null;
    }

    static LocalPortForward forwardPortAsync(NamespacedKubernetesClient kubernetes, String podName, int containerPort, int localPort) {
        return ((PodResource)kubernetes.pods().withName(podName)).portForward(containerPort, localPort);
    }

    void startPortForward(NamespacedKubernetesClient kubernetes, String pod, int containerPort, int localPort) {
        this.log.info("Starting port forwarding to port %s on pod %s", new Object[]{localPort, pod});
        LocalPortForward localPortForward = PortForwardService.forwardPortAsync(kubernetes, pod, containerPort, localPort);
        this.log.info("Port Forwarding started", new Object[0]);
        this.log.info("Now you can start a Remote debug session by using localhost and the debug port %s", new Object[]{localPort});
        this.log.info("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=%s", new Object[]{localPort});
        new PortForwardTask(kubernetes, pod, localPortForward, this.log).run();
    }

    static /* synthetic */ KitLogger access$100(PortForwardService x0) {
        return x0.log;
    }
}

