/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Scaleable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.GenericCustomResource;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.image.ImageName;

public class KubernetesClientUtil {
    private KubernetesClientUtil() {
    }

    public static void resizeApp(KubernetesClient kubernetes, String namespace, Collection<HasMetadata> entities, int replicas, KitLogger log) {
        for (HasMetadata entity : entities) {
            String name = KubernetesHelper.getName((HasMetadata)entity);
            Scaleable scalable = null;
            if (entity instanceof Deployment) {
                scalable = (Scaleable)((NonNamespaceOperation)kubernetes.apps().deployments().inNamespace(namespace)).withName(name);
            } else if (entity instanceof ReplicaSet) {
                scalable = (Scaleable)((NonNamespaceOperation)kubernetes.apps().replicaSets().inNamespace(namespace)).withName(name);
            } else if (entity instanceof ReplicationController) {
                scalable = (Scaleable)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name);
            } else if (entity instanceof DeploymentConfig) {
                OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kubernetes);
                if (openshiftClient == null) {
                    log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
                    continue;
                }
                scalable = (Scaleable)((NonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name);
            }
            if (scalable == null) continue;
            log.info("Scaling " + KubernetesHelper.getKind((HasMetadata)entity) + " " + namespace + "/" + name + " to replicas: " + replicas, new Object[0]);
            scalable.scale(replicas, true);
        }
    }

    public static void deleteEntities(KubernetesClient kubernetes, String namespace, Collection<HasMetadata> entities, KitLogger log) {
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>(entities);
        Collections.reverse(list);
        for (HasMetadata entity : list) {
            log.info("Deleting resource " + KubernetesHelper.getKind((HasMetadata)entity) + " " + namespace + "/" + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            ((CascadingDeletable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)kubernetes.resource(entity).inNamespace(namespace)).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        }
    }

    public static void deleteOpenShiftEntities(KubernetesClient kubernetes, String namespace, Collection<HasMetadata> entities, String s2iBuildNameSuffix, KitLogger log) {
        OpenShiftClient openshiftClient = OpenshiftHelper.asOpenShiftClient((KubernetesClient)kubernetes);
        if (openshiftClient == null) {
            return;
        }
        for (HasMetadata entity : entities) {
            if (!"ImageStream".equals(KubernetesHelper.getKind((HasMetadata)entity))) continue;
            ImageName imageName = new ImageName(entity.getMetadata().getName());
            String buildName = KubernetesClientUtil.getS2IBuildName(imageName, s2iBuildNameSuffix);
            log.info("Deleting resource BuildConfig %s/%s and Builds", new Object[]{namespace, buildName});
            ((FilterWatchListDeletable)((NonNamespaceOperation)openshiftClient.builds().inNamespace(namespace)).withLabel("buildconfig", buildName)).delete();
            ((BuildConfigResource)((NonNamespaceOperation)openshiftClient.buildConfigs().inNamespace(namespace)).withName(buildName)).delete();
        }
    }

    private static String getS2IBuildName(ImageName imageName, String s2iBuildNameSuffix) {
        return imageName.getSimpleName() + s2iBuildNameSuffix;
    }

    public static String getPodStatusDescription(Pod pod) {
        return KubernetesHelper.getPodPhase((Pod)pod) + " " + KubernetesClientUtil.getPodCondition(pod);
    }

    public static String getPodStatusMessagePostfix(Watcher.Action action) {
        String message = "";
        switch (action) {
            case DELETED: {
                message = ": Pod Deleted";
                break;
            }
            case ERROR: {
                message = ": Error";
            }
        }
        return message;
    }

    protected static String getPodCondition(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return "";
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return "";
        }
        for (PodCondition condition : conditions) {
            String statusText;
            String type = condition.getType();
            if (!StringUtils.isNotBlank((CharSequence)type) || !"ready".equalsIgnoreCase(type) || !StringUtils.isNotBlank((CharSequence)(statusText = condition.getStatus())) || !Boolean.parseBoolean(statusText)) continue;
            return type;
        }
        return "";
    }

    public static GenericCustomResource doGetCustomResource(KubernetesClient kubernetesClient, CustomResourceDefinitionContext crdContext, String namespace, String name) {
        try {
            return (GenericCustomResource)Serialization.jsonMapper().convertValue((Object)kubernetesClient.customResource(crdContext).inNamespace(namespace).withName(name).get(), GenericCustomResource.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void doDeleteAndWait(KubernetesClient kubernetesClient, CustomResourceDefinitionContext context, String namespace, String name, long seconds) {
        RawCustomResourceOperationsImpl crClient = kubernetesClient.customResource(context).inNamespace(namespace).withName(name);
        try {
            crClient.delete();
            Supplier<GenericCustomResource> getter = () -> KubernetesClientUtil.doGetCustomResource(kubernetesClient, context, namespace, name);
            while (seconds-- > 0L && !Objects.isNull(getter.get())) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String applicableNamespace(HasMetadata resource, String namespace, String fallbackNamespace) {
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            return namespace;
        }
        if (StringUtils.isNotBlank((CharSequence)KubernetesHelper.getNamespace((HasMetadata)resource))) {
            return KubernetesHelper.getNamespace((HasMetadata)resource);
        }
        return StringUtils.isNotBlank((CharSequence)fallbackNamespace) ? fallbackNamespace : KubernetesHelper.getDefaultNamespace();
    }
}

