/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.GenericCustomResource;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.common.util.UserConfigurationCompare;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.service.PatchService;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class ApplyService {
    private final KubernetesClient kubernetesClient;
    private final KitLogger log;
    private boolean allowCreate = true;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;
    private boolean ignoreBoundPersistentVolumeClaims = true;
    private boolean rollingUpgrade;
    private boolean processTemplatesLocally;
    private File logJsonDir;
    private File basedir;
    private boolean supportOAuthClients;
    private boolean deletePodsOnReplicationControllerUpdate = true;
    private String namespace = KubernetesHelper.getDefaultNamespace();
    private String fallbackNamespace;
    private boolean rollingUpgradePreserveScale = true;
    private boolean recreateMode;
    private PatchService patchService;
    private static final Set<String> projectsCreated = new HashSet<String>();

    public ApplyService(KubernetesClient kubernetesClient, KitLogger log) {
        this.kubernetesClient = kubernetesClient;
        this.patchService = new PatchService(kubernetesClient, log);
        this.log = log;
    }

    public void apply(Object dto, String sourceName) {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    this.log.warn("Found recursive nested object for %s of class: %s", new Object[]{dto, dto.getClass().getName()});
                    continue;
                }
                this.apply(element, sourceName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, sourceName);
        } else if (dto != null) {
            this.applyEntity(dto, sourceName);
        }
    }

    public boolean isAlreadyApplied(HasMetadata resource) {
        return ((Gettable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource(resource).inNamespace(this.namespace)).fromServer()).get() != null;
    }

    private void applyEntity(Object dto, String sourceName) {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            DeploymentConfig resource = (DeploymentConfig)dto;
            OpenShiftClient openShiftClient = this.getOpenShiftClient();
            if (openShiftClient != null) {
                this.applyResource(resource, sourceName, openShiftClient.deploymentConfigs());
            } else {
                this.log.warn("Not connected to OpenShift cluster so cannot apply entity %s", new Object[]{dto});
            }
        } else if (dto instanceof RoleBinding) {
            this.applyRoleBinding((RoleBinding)dto, sourceName);
        } else if (dto instanceof Role) {
            this.applyResource((Role)dto, sourceName, this.kubernetesClient.rbac().roles());
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else if (dto instanceof ServiceAccount) {
            this.applyServiceAccount((ServiceAccount)dto, sourceName);
        } else if (dto instanceof Secret) {
            this.applySecret((Secret)dto, sourceName);
        } else if (dto instanceof ConfigMap) {
            this.applyResource((ConfigMap)dto, sourceName, this.kubernetesClient.configMaps());
        } else if (dto instanceof DaemonSet) {
            this.applyResource((DaemonSet)dto, sourceName, this.kubernetesClient.apps().daemonSets());
        } else if (dto instanceof Deployment) {
            this.applyResource((Deployment)dto, sourceName, this.kubernetesClient.apps().deployments());
        } else if (dto instanceof ReplicaSet) {
            this.applyResource((ReplicaSet)dto, sourceName, this.kubernetesClient.apps().replicaSets());
        } else if (dto instanceof StatefulSet) {
            this.applyResource((StatefulSet)dto, sourceName, this.kubernetesClient.apps().statefulSets());
        } else if (dto instanceof Ingress) {
            this.applyResource((Ingress)dto, sourceName, this.kubernetesClient.extensions().ingresses());
        } else if (dto instanceof PersistentVolumeClaim) {
            this.applyPersistentVolumeClaim((PersistentVolumeClaim)dto, sourceName);
        } else if (dto instanceof CustomResourceDefinition) {
            this.applyCustomResourceDefinition((CustomResourceDefinition)dto, sourceName);
        } else if (dto instanceof Job) {
            this.applyJob((Job)dto, sourceName);
        } else if (dto instanceof NetworkPolicy) {
            this.applyResource((NetworkPolicy)dto, sourceName, this.kubernetesClient.network().networkPolicies());
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Project) {
            this.applyProject((Project)dto);
        } else if (dto instanceof GenericCustomResource) {
            this.applyGenericCustomResource((GenericCustomResource)dto, sourceName);
        } else if (dto instanceof HasMetadata) {
            HasMetadata entity = (HasMetadata)dto;
            try {
                this.log.info("Applying %s %s from %s", new Object[]{KubernetesHelper.getKind((HasMetadata)entity), KubernetesHelper.getName((HasMetadata)entity), sourceName});
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)this.kubernetesClient.resource(entity).inNamespace(KubernetesClientUtil.applicableNamespace((HasMetadata)dto, this.namespace, this.fallbackNamespace))).createOrReplace();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + KubernetesHelper.getKind((HasMetadata)entity) + " from " + sourceName + ". " + e, e);
            }
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyGenericCustomResource(GenericCustomResource dto, String sourceName) {
        try {
            CustomResourceDefinitionList crdList = (CustomResourceDefinitionList)this.kubernetesClient.apiextensions().v1beta1().customResourceDefinitions().list();
            CustomResourceDefinitionContext crdContext = KubernetesHelper.getCrdContext((CustomResourceDefinitionList)crdList, (GenericCustomResource)dto);
            if (crdContext == null) {
                this.onApplyError(String.format("Unable to find CustomResourceDefinition for CustomResource: %s#%s", dto.getApiVersion(), dto.getKind()), null);
            }
            this.applyCustomResource(crdContext, dto, sourceName);
        }
        catch (IOException exception) {
            this.onApplyError("Failed to apply " + KubernetesHelper.getKind((HasMetadata)dto) + " from " + sourceName + ". ", exception);
        }
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null && this.supportOAuthClients) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Only processing Services right now so ignoring OAuthClient: %s", new Object[]{id});
                return;
            }
            OAuthClient old = (OAuthClient)((Resource)openShiftClient.oAuthClients().withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (this.isIgnoreRunningOAuthClients()) {
                    this.log.info("Not updating the OAuthClient which are shared across namespaces as its already running", new Object[0]);
                    return;
                }
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                    this.log.info("OAuthClient has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    ((Resource)openShiftClient.oAuthClients().withName(id)).delete();
                    this.doCreateOAuthClient(entity, sourceName);
                } else {
                    try {
                        Object answer = ((Resource)openShiftClient.oAuthClients().withName(id)).replace((Object)entity);
                        this.log.info("Updated OAuthClient result: %s", new Object[]{answer});
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating an OAuthClient from %s name %s", new Object[]{sourceName, KubernetesHelper.getName((HasMetadata)entity)});
            } else {
                this.doCreateOAuthClient(entity, sourceName);
            }
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            try {
                openShiftClient.oAuthClients().create((Object)entity);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public Object applyTemplate(Template entity, String sourceName) {
        this.installTemplate(entity, sourceName);
        return this.processTemplate(entity, sourceName);
    }

    public void installTemplate(Template entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient == null) {
            return;
        }
        if (!this.isProcessTemplatesLocally()) {
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            Template old = (Template)((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                    this.log.info("Template has not changed so not doing anything", new Object[0]);
                } else {
                    boolean recreateMode = this.isRecreateMode();
                    recreateMode = true;
                    if (recreateMode) {
                        ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(currentNamespace)).withName(id)).delete();
                        this.doCreateTemplate(entity, currentNamespace, sourceName);
                    } else {
                        this.log.info("Updating a Template from %s", new Object[]{sourceName});
                        try {
                            Object answer = ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(currentNamespace)).withName(id)).replace((Object)entity);
                            this.log.info("Updated Template: " + answer, new Object[0]);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update Template from " + sourceName + ". " + e + ". " + entity, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a Template from %s namespace %s name %s", new Object[]{sourceName, currentNamespace, KubernetesHelper.getName((HasMetadata)entity)});
            } else {
                this.doCreateTemplate(entity, currentNamespace, sourceName);
            }
        }
    }

    public OpenShiftClient getOpenShiftClient() {
        return OpenshiftHelper.asOpenShiftClient((KubernetesClient)this.kubernetesClient);
    }

    protected void doCreateTemplate(Template entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            this.log.info("Creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            try {
                Object answer = ((NonNamespaceOperation)openShiftClient.templates().inNamespace(namespace)).create((Object)entity);
                this.logGeneratedEntity("Created Template: ", namespace, (HasMetadata)entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to Template entity from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyServiceAccount(ServiceAccount serviceAccount, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)serviceAccount, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)serviceAccount);
        Objects.requireNonNull(id, "No name for " + serviceAccount + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring ServiceAccount: " + id, new Object[0]);
            return;
        }
        ServiceAccount old = (ServiceAccount)((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)serviceAccount, (Object)old)) {
                this.log.info("ServiceAccount has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(currentNamespace)).withName(id)).delete();
                this.doCreateServiceAccount(serviceAccount, currentNamespace, sourceName);
            } else {
                this.log.info("Updating a ServiceAccount from " + sourceName, new Object[0]);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(currentNamespace)).withName(id)).replace((Object)serviceAccount);
                    this.logGeneratedEntity("Updated ServiceAccount: ", currentNamespace, (HasMetadata)serviceAccount, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a ServiceAccount from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount), new Object[0]);
        } else {
            this.doCreateServiceAccount(serviceAccount, currentNamespace, sourceName);
        }
    }

    protected void doCreateServiceAccount(ServiceAccount serviceAccount, String namespace, String sourceName) {
        this.log.info("Creating a ServiceAccount from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)serviceAccount), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)this.kubernetesClient.serviceAccounts().inNamespace(namespace)).create((Object)serviceAccount);
            this.logGeneratedEntity("Created ServiceAccount: ", namespace, (HasMetadata)serviceAccount, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ServiceAccount from " + sourceName + ". " + e + ". " + serviceAccount, e);
        }
    }

    public void applyPersistentVolumeClaim(PersistentVolumeClaim entity, String sourceName) {
        boolean alwaysRecreate = true;
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring PersistentVolumeClaim: " + id, new Object[0]);
            return;
        }
        PersistentVolumeClaim old = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                this.log.info("PersistentVolumeClaim has not changed so not doing anything", new Object[0]);
            } else if (alwaysRecreate || this.isRecreateMode()) {
                if (!this.isRecreateMode() && this.isIgnoreBoundPersistentVolumeClaims() && this.isBound(old)) {
                    this.log.warn("PersistentVolumeClaim " + id + " in namespace " + currentNamespace + " is already bound and will not be replaced with the new one from " + sourceName, new Object[0]);
                } else {
                    this.log.info("Deleting PersistentVolumeClaim from namespace " + currentNamespace + " with name " + id, new Object[0]);
                    ((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(currentNamespace)).withName(id)).delete();
                    this.log.info("Deleted PersistentVolumeClaim from namespace " + currentNamespace + " with name " + id, new Object[0]);
                    this.doCreatePersistentVolumeClaim(entity, currentNamespace, sourceName);
                }
            } else {
                this.doPatchEntity(old, entity, currentNamespace, sourceName);
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a PersistentVolumeClaim from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        } else {
            this.doCreatePersistentVolumeClaim(entity, currentNamespace, sourceName);
        }
    }

    public void applyCustomResourceDefinition(CustomResourceDefinition entity, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Custom Resource Definition: " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        CustomResourceDefinition old = (CustomResourceDefinition)((Resource)this.kubernetesClient.apiextensions().v1beta1().customResourceDefinitions().withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                this.log.info("Custom Resource Definition has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting Custom Resource Definition: " + id, new Object[0]);
                ((Resource)this.kubernetesClient.apiextensions().v1beta1().customResourceDefinitions().withName(id)).delete();
                this.doCreateCustomResourceDefinition(entity, sourceName);
            } else {
                this.doPatchEntity(old, entity, currentNamespace, sourceName);
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a Custom Resource Definition from " + sourceName + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        } else {
            this.doCreateCustomResourceDefinition(entity, sourceName);
        }
    }

    private void doCreateCustomResourceDefinition(CustomResourceDefinition entity, String sourceName) {
        this.log.info("Creating a Custom Resource Definition from " + sourceName + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        try {
            CustomResourceDefinition answer = (CustomResourceDefinition)this.kubernetesClient.apiextensions().v1beta1().customResourceDefinitions().create((Object)entity);
            this.log.info("Created Custom Resource Definition result: %s", new Object[]{answer.getMetadata().getName()});
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Custom Resource Definition from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    private void applyCustomResource(CustomResourceDefinitionContext context, GenericCustomResource genericCustomResource, String sourceName) throws IOException {
        GenericCustomResource existentCR;
        String name = genericCustomResource.getMetadata().getName();
        String applyNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)genericCustomResource, this.namespace, this.fallbackNamespace);
        String apiGroupWithKind = KubernetesHelper.getFullyQualifiedApiGroupWithKind((CustomResourceDefinitionContext)context);
        Objects.requireNonNull(name, "No name for " + genericCustomResource + " " + sourceName);
        if (this.isRecreateMode()) {
            this.log.info("Attempting to delete Custom Resource: %s %s/%s", new Object[]{apiGroupWithKind, this.namespace, name});
            KubernetesClientUtil.doDeleteAndWait(this.kubernetesClient, context, applyNamespace, name, 10L);
        }
        if ((existentCR = KubernetesClientUtil.doGetCustomResource(this.kubernetesClient, context, applyNamespace, name)) != null && StringUtils.isBlank((CharSequence)existentCR.getMetadata().getDeletionTimestamp())) {
            this.log.info("Replacing Custom Resource: %s %s/%s", new Object[]{KubernetesHelper.getFullyQualifiedApiGroupWithKind((CustomResourceDefinitionContext)context), applyNamespace, name});
            genericCustomResource.getMetadata().setResourceVersion(existentCR.getMetadata().getResourceVersion());
        }
        this.kubernetesClient.customResource(context).inNamespace(applyNamespace).withName(name).createOrReplace(Serialization.jsonMapper().writeValueAsString((Object)genericCustomResource));
        this.log.info("Created Custom Resource: %s %s/%s", new Object[]{apiGroupWithKind, applyNamespace, name});
    }

    protected boolean isBound(PersistentVolumeClaim claim) {
        return claim != null && claim.getStatus() != null && "Bound".equals(claim.getStatus().getPhase());
    }

    protected void doCreatePersistentVolumeClaim(PersistentVolumeClaim entity, String namespace, String sourceName) {
        this.log.info("Creating a PersistentVolumeClaim from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).create((Object)entity);
            this.logGeneratedEntity("Created PersistentVolumeClaim: ", namespace, (HasMetadata)entity, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create PersistentVolumeClaim from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public void applySecret(Secret secret, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)secret, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)secret);
        Objects.requireNonNull(id, "No name for " + secret + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Secrets: " + id, new Object[0]);
            return;
        }
        Secret old = (Secret)((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)secret, (Object)old)) {
                this.log.info("Secret has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(currentNamespace)).withName(id)).delete();
                this.doCreateSecret(secret, currentNamespace, sourceName);
            } else {
                this.doPatchEntity(old, secret, currentNamespace, sourceName);
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a Secret from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)secret), new Object[0]);
        } else {
            this.doCreateSecret(secret, currentNamespace, sourceName);
        }
    }

    protected void doCreateSecret(Secret secret, String namespace, String sourceName) {
        this.log.info("Creating a Secret from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)secret), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).create((Object)secret);
            this.logGeneratedEntity("Created Secret: ", namespace, (HasMetadata)secret, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Secret from " + sourceName + ". " + e + ". " + secret, e);
        }
    }

    protected void logGeneratedEntity(String message, String namespace, HasMetadata entity, Object result) {
        if (this.logJsonDir != null) {
            File namespaceDir = new File(this.logJsonDir, namespace);
            namespaceDir.mkdirs();
            String kind = KubernetesHelper.getKind((HasMetadata)entity);
            String name = KubernetesHelper.getName((HasMetadata)entity);
            if (StringUtils.isNotBlank((CharSequence)kind)) {
                name = kind.toLowerCase() + "-" + name;
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.log.warn("No name for the entity " + entity, new Object[0]);
            } else {
                String text;
                String fileName = name + ".json";
                File file = new File(namespaceDir, fileName);
                if (file.exists()) {
                    int idx = 1;
                    while ((file = new File(namespaceDir, fileName = name + "-" + idx++ + ".json")).exists()) {
                    }
                }
                if (result instanceof String) {
                    text = result.toString();
                } else {
                    try {
                        text = ResourceUtil.toJson((Object)result);
                    }
                    catch (JsonProcessingException e) {
                        this.log.warn("Cannot convert " + result + " to JSON: " + (Object)((Object)e), new Object[]{e});
                        text = result != null ? result.toString() : "null";
                    }
                }
                try {
                    String path;
                    FileUtils.writeStringToFile((File)file, (String)text, (Charset)Charset.defaultCharset());
                    Object fileLocation = file;
                    if (this.basedir != null && (path = FileUtil.getRelativePath((File)this.basedir, (File)file).getPath()) != null) {
                        fileLocation = FileUtil.stripPrefix((String)path, (String)"/");
                    }
                    this.log.info(message + fileLocation, new Object[0]);
                }
                catch (IOException e) {
                    this.log.warn("Failed to write to file " + file + ". " + e, new Object[]{e});
                }
                return;
            }
        }
        this.log.info(message + result, new Object[0]);
    }

    public Object processTemplate(Template entity, String sourceName) {
        try {
            return OpenshiftHelper.processTemplatesLocally((Template)entity, (boolean)false);
        }
        catch (IOException e) {
            this.onApplyError("Failed to process template " + sourceName + ". " + e + ". " + entity, e);
            return null;
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Ignoring Route: " + currentNamespace + ":" + id, new Object[0]);
                return;
            }
            Route route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)route)) {
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)route)) {
                    this.log.info("Route has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    this.log.info("Deleting Route: " + id, new Object[0]);
                    ((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(currentNamespace)).withName(id)).delete();
                    this.doCreateRoute(entity, currentNamespace, sourceName);
                } else {
                    this.doPatchEntity(route, entity, currentNamespace, sourceName);
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a Route from " + sourceName + " namespace " + currentNamespace + " name " + id, new Object[0]);
            } else {
                this.doCreateRoute(entity, currentNamespace, sourceName);
            }
        }
    }

    private void doCreateRoute(Route entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        String id = KubernetesHelper.getName((HasMetadata)entity);
        try {
            this.log.info("Creating Route " + namespace + ":" + id + " " + (entity.getSpec() != null ? "host: " + entity.getSpec().getHost() : "No Spec !"), new Object[0]);
            ((NonNamespaceOperation)openShiftClient.routes().inNamespace(namespace)).create((Object)entity);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Route from " + sourceName + ". " + e + ". " + entity, e);
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            this.applyNamespace(currentNamespace);
            BuildConfig old = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                    this.log.info("BuildConfig has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    this.log.info("Deleting BuildConfig: " + id, new Object[0]);
                    ((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(currentNamespace)).withName(id)).delete();
                    this.doCreateBuildConfig(entity, currentNamespace, sourceName);
                } else {
                    this.doPatchEntity(old, entity, currentNamespace, sourceName);
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating BuildConfig from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            } else {
                this.doCreateBuildConfig(entity, currentNamespace, sourceName);
            }
        }
    }

    public void doCreateBuildConfig(BuildConfig entity, String namespace, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            try {
                ((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(namespace)).create((Object)entity);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyRoleBinding(RoleBinding entity, String sourceName) {
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
        this.applyNamespace(currentNamespace);
        RoleBinding old = (RoleBinding)((Resource)((NonNamespaceOperation)this.kubernetesClient.rbac().roleBindings().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                this.log.info("RoleBinding has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting RoleBinding: " + id, new Object[0]);
                ((Resource)((NonNamespaceOperation)this.kubernetesClient.rbac().roleBindings().inNamespace(currentNamespace)).withName(id)).delete();
                this.doCreateRoleBinding(entity, currentNamespace, sourceName);
            } else {
                this.log.info("Updating RoleBinding from " + sourceName, new Object[0]);
                try {
                    String resourceVersion = KubernetesHelper.getResourceVersion((HasMetadata)old);
                    ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
                    metadata.setNamespace(currentNamespace);
                    metadata.setResourceVersion(resourceVersion);
                    Object answer = ((Resource)((NonNamespaceOperation)this.kubernetesClient.rbac().roleBindings().inNamespace(currentNamespace)).withName(id)).replace((Object)entity);
                    this.logGeneratedEntity("Updated RoleBinding: ", currentNamespace, (HasMetadata)entity, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update RoleBinding from " + sourceName + ". " + e + ". " + entity, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating RoleBinding from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
        } else {
            this.doCreateRoleBinding(entity, currentNamespace, sourceName);
        }
    }

    public void doCreateRoleBinding(RoleBinding entity, String namespace, String sourceName) {
        try {
            this.log.info("Creating RoleBinding from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            ((NonNamespaceOperation)this.kubernetesClient.rbac().roleBindings().inNamespace(namespace)).create((Object)entity);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create RoleBinding from " + sourceName + ". " + e, e);
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        OpenShiftClient openShiftClient = this.getOpenShiftClient();
        if (openShiftClient != null) {
            String kind = KubernetesHelper.getKind((HasMetadata)entity);
            String name = KubernetesHelper.getName((HasMetadata)entity);
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            try {
                Resource resource = (Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(currentNamespace)).withName(name);
                ImageStream old = (ImageStream)resource.get();
                if (old == null) {
                    this.log.info("Creating " + kind + " " + name + " from " + sourceName, new Object[0]);
                    resource.create((Object)entity);
                } else {
                    this.log.info("Updating " + kind + " " + name + " from " + sourceName, new Object[0]);
                    this.copyAllImageStreamTags(entity, old);
                    entity = this.patchService.compareAndPatchEntity(currentNamespace, entity, old);
                    ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)openShiftClient.resource((HasMetadata)entity).inNamespace(currentNamespace)).createOrReplace();
                }
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e, e);
            }
        }
    }

    protected void copyAllImageStreamTags(ImageStream from, ImageStream to) {
        List fromTags;
        ImageStreamSpec fromSpec;
        ArrayList<TagReference> toTags;
        ImageStreamSpec toSpec = to.getSpec();
        if (toSpec == null) {
            toSpec = new ImageStreamSpec();
            to.setSpec(toSpec);
        }
        if ((toTags = toSpec.getTags()) == null) {
            toTags = new ArrayList<TagReference>();
            toSpec.setTags(toTags);
        }
        if ((fromSpec = from.getSpec()) != null && (fromTags = fromSpec.getTags()) != null) {
            for (TagReference tag : fromTags) {
                this.removeTagByName(toTags, tag.getName());
            }
            for (TagReference tag : fromTags) {
                toTags.add(tag);
            }
        }
    }

    private int removeTagByName(List<TagReference> tags, String tagName) {
        ArrayList<TagReference> removeTags = new ArrayList<TagReference>();
        for (TagReference tag : tags) {
            if (!Objects.equals(tagName, tag.getName())) continue;
            removeTags.add(tag);
        }
        tags.removeAll(removeTags);
        return removeTags.size();
    }

    public void applyList(KubernetesList list, String sourceName) {
        List entities = list.getItems();
        if (entities != null) {
            for (Object entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public void applyService(Service service, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)service, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)service);
        Objects.requireNonNull(id, "No name for " + service + " " + sourceName);
        if (this.isIgnoreServiceMode()) {
            this.log.debug("Ignoring Service: " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        Service old = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)service, (Object)old)) {
                this.log.info("Service has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting Service: " + id, new Object[0]);
                ((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(currentNamespace)).withName(id)).delete();
                this.doCreateService(service, currentNamespace, sourceName);
            } else {
                this.doPatchEntity(old, service, currentNamespace, sourceName);
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a Service from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)service), new Object[0]);
        } else {
            this.doCreateService(service, currentNamespace, sourceName);
        }
    }

    public <T extends HasMetadata, L> void applyResource(T resource, String sourceName, MixedOperation<T, L, ? extends Resource<T>> resources) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace(resource, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName(resource);
        String kind = KubernetesHelper.getKind(resource);
        Objects.requireNonNull(id, "No name for " + resource + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Ignoring " + kind + ": " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        HasMetadata old = (HasMetadata)((Resource)((NonNamespaceOperation)resources.inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(resource, (Object)old)) {
                this.log.info(kind + " has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting " + kind + ": " + id, new Object[0]);
                ((Resource)((NonNamespaceOperation)resources.inNamespace(currentNamespace)).withName(id)).delete();
                this.doCreateResource(resource, currentNamespace, sourceName, resources);
            } else {
                this.log.info("Updating " + kind + " from " + sourceName, new Object[0]);
                try {
                    Object answer = ((Resource)((NonNamespaceOperation)resources.inNamespace(currentNamespace)).withName(id)).replace(resource);
                    this.logGeneratedEntity("Updated " + kind + ": ", currentNamespace, resource, answer);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
                }
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a " + kind + " from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName(resource), new Object[0]);
        } else {
            this.doCreateResource(resource, currentNamespace, sourceName, resources);
        }
    }

    protected <T extends HasMetadata, L> void doCreateResource(T resource, String namespace, String sourceName, MixedOperation<T, L, ? extends Resource<T>> resources) {
        String kind = KubernetesHelper.getKind(resource);
        this.log.info("Creating a " + kind + " from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName(resource), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)resources.inNamespace(namespace)).create(resource);
            this.logGeneratedEntity("Created " + kind + ": ", namespace, resource, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
        }
    }

    private <T extends HasMetadata> void doPatchEntity(T oldEntity, T newEntity, String namespace, String sourceName) {
        String kind = newEntity.getKind();
        this.log.info("Updating %s from %s", new Object[]{kind, sourceName});
        try {
            T answer = this.patchService.compareAndPatchEntity(namespace, newEntity, oldEntity);
            this.logGeneratedEntity("Updated " + kind + ": ", namespace, newEntity, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + newEntity, e);
        }
    }

    protected void doCreateService(Service service, String namespace, String sourceName) {
        this.log.info("Creating a Service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)service), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).create((Object)service);
            this.logGeneratedEntity("Created Service: ", namespace, (HasMetadata)service, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Service from " + sourceName + ". " + e + ". " + service, e);
        }
    }

    public boolean checkNamespace(String namespaceName) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return false;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient != null) {
            List projects = ((ProjectList)openshiftClient.projects().list()).getItems();
            for (Project project : projects) {
                if (!namespaceName.equals(project.getMetadata().getName())) continue;
                return true;
            }
            return false;
        }
        return ((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).get() != null;
    }

    public boolean deleteNamespace(String namespaceName) {
        if (!this.checkNamespace(namespaceName)) {
            return false;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient != null) {
            return ((Resource)openshiftClient.projects().withName(namespaceName)).delete();
        }
        return ((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).delete();
    }

    public void applyNamespace(String namespaceName) {
        this.applyNamespace(namespaceName, null);
    }

    public void applyNamespace(String namespaceName, Map<String, String> labels) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return;
        }
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient != null) {
            ProjectRequest entity = new ProjectRequest();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
            metadata.setName(namespaceName);
            String kubernetesClientNamespace = this.kubernetesClient.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)kubernetesClientNamespace)) {
                Map entityLabels = KubernetesHelper.getOrCreateLabels((HasMetadata)entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", kubernetesClientNamespace);
                }
            }
            this.applyProjectRequest(entity);
        } else {
            Namespace entity = new Namespace();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
            metadata.setName(namespaceName);
            String kubernetesClientNamespace = this.kubernetesClient.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)kubernetesClientNamespace)) {
                Map entityLabels = KubernetesHelper.getOrCreateLabels((HasMetadata)entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", kubernetesClientNamespace);
                }
            }
            this.applyNamespace(entity);
        }
    }

    public boolean applyNamespace(Namespace entity) {
        String currentNamespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        this.log.info("Creating currentNamespace: " + currentNamespace, new Object[0]);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(name, "No name for " + entity);
        Namespace old = (Namespace)((Resource)this.kubernetesClient.namespaces().withName(name)).get();
        if (!this.isRunning((HasMetadata)old)) {
            try {
                Object answer = this.kubernetesClient.namespaces().create((Object)entity);
                this.logGeneratedEntity("Created Namespace: ", currentNamespace, (HasMetadata)entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create Namespace: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public boolean applyProject(Project project) {
        return this.applyProjectRequest(((ProjectRequestBuilder)((ProjectRequestBuilder)new ProjectRequestBuilder().withDisplayName(project.getMetadata().getName())).withMetadata(project.getMetadata())).build());
    }

    public boolean applyProjectRequest(ProjectRequest entity) {
        if (projectsCreated.contains(KubernetesHelper.getName((HasMetadata)entity))) {
            return false;
        }
        String currentNamespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        this.log.info("Creating project: " + currentNamespace, new Object[0]);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(name, "No name for " + entity);
        OpenShiftClient openshiftClient = this.getOpenShiftClient();
        if (openshiftClient == null) {
            this.log.warn("Cannot check for Project " + currentNamespace + " as not running against OpenShift!", new Object[0]);
            return false;
        }
        boolean exists = this.checkNamespace(name);
        if (!exists) {
            try {
                Object answer = openshiftClient.projectrequests().create((Object)entity);
                projectsCreated.add(name);
                this.logGeneratedEntity("Created ProjectRequest: ", currentNamespace, (HasMetadata)entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create ProjectRequest: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) {
        block15: {
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)replicationController, this.namespace, this.fallbackNamespace);
            String id = KubernetesHelper.getName((HasMetadata)replicationController);
            Objects.requireNonNull(id, "No name for " + replicationController + " " + sourceName);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Only processing Services right now so ignoring ReplicationController: " + currentNamespace + ":" + id, new Object[0]);
                return;
            }
            ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual((Object)replicationController, (Object)old)) {
                    this.log.info("ReplicationController has not changed so not doing anything", new Object[0]);
                } else {
                    ReplicationControllerSpec newSpec = replicationController.getSpec();
                    ReplicationControllerSpec oldSpec = old.getSpec();
                    if (this.rollingUpgrade) {
                        Integer replicas;
                        this.log.info("Rolling upgrade of the ReplicationController: " + currentNamespace + "/" + id, new Object[0]);
                        if (this.rollingUpgradePreserveScale && newSpec != null && oldSpec != null && (replicas = oldSpec.getReplicas()) != null) {
                            newSpec.setReplicas(replicas);
                        }
                        this.log.info("rollingUpgradePreserveScale " + this.rollingUpgradePreserveScale + " new replicas is " + (newSpec != null ? newSpec.getReplicas() : "<null>"), new Object[0]);
                        ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(currentNamespace)).withName(id)).rolling()).replace((Object)replicationController);
                    } else if (this.isRecreateMode()) {
                        this.log.info("Deleting ReplicationController: " + id, new Object[0]);
                        ((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(currentNamespace)).withName(id)).delete();
                        this.doCreateReplicationController(replicationController, currentNamespace, sourceName);
                    } else {
                        this.log.info("Updating ReplicationController from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
                        try {
                            ReplicationController answer = this.patchService.compareAndPatchEntity(currentNamespace, replicationController, old);
                            this.logGeneratedEntity("Updated replicationController: ", currentNamespace, (HasMetadata)replicationController, answer);
                            if (this.deletePodsOnReplicationControllerUpdate) {
                                ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(currentNamespace)).withLabels(newSpec.getSelector())).delete();
                                this.log.info("Deleting any pods for the replication controller to ensure they use the new configuration", new Object[0]);
                                break block15;
                            }
                            this.log.info("Warning not deleted any pods so they could well be running with the old configuration!", new Object[0]);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a ReplicationController from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
            } else {
                this.doCreateReplicationController(replicationController, currentNamespace, sourceName);
            }
        }
    }

    protected void doCreateReplicationController(ReplicationController replicationController, String namespace, String sourceName) {
        this.log.info("Creating a ReplicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(namespace)).create((Object)replicationController);
            this.logGeneratedEntity("Created ReplicationController: ", namespace, (HasMetadata)replicationController, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
        }
    }

    public void applyPod(Pod pod, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)pod, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)pod);
        Objects.requireNonNull(id, "No name for " + pod + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Pod: " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        Pod old = (Pod)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)pod, (Object)old)) {
                this.log.info("Pod has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting Pod: " + id, new Object[0]);
                ((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(currentNamespace)).withName(id)).delete();
                this.doCreatePod(pod, currentNamespace, sourceName);
            } else {
                this.doPatchEntity(old, pod, currentNamespace, sourceName);
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a pod from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)pod), new Object[0]);
        } else {
            this.doCreatePod(pod, currentNamespace, sourceName);
        }
    }

    protected void doCreatePod(Pod pod, String namespace, String sourceName) {
        this.log.info("Creating a Pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)pod), new Object[0]);
        try {
            Object answer = ((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).create((Object)pod);
            this.log.info("Created Pod result: " + answer, new Object[0]);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create Pod from " + sourceName + ". " + e + ". " + pod, e);
        }
    }

    protected void applyJob(Job job, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)job, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)job);
        Objects.requireNonNull(id, "No name for " + job + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Job: " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        try {
            this.doCreateJob(job, currentNamespace, sourceName);
        }
        catch (KubernetesClientException exception) {
            if (exception.getStatus().getCode().equals(409)) {
                Job old = (Job)((ScalableResource)((NonNamespaceOperation)this.kubernetesClient.batch().v1().jobs().inNamespace(currentNamespace)).withName(id)).get();
                Job updatedJob = this.patchService.compareAndPatchEntity(currentNamespace, job, old);
                this.log.info("Updated Job: " + updatedJob.getMetadata().getName(), new Object[0]);
                return;
            }
            this.onApplyError("Failed to apply Job from " + job.getMetadata().getName(), (Exception)((Object)exception));
        }
    }

    public void doCreateJob(Job job, String namespace, String sourceName) {
        ((NonNamespaceOperation)this.kubernetesClient.batch().v1().jobs().inNamespace(namespace)).create((Object)job);
        this.log.info("Creating a Job from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)job), new Object[0]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFallbackNamespace() {
        return this.fallbackNamespace;
    }

    protected String getNamespace(HasMetadata entity) {
        String answer = KubernetesHelper.getNamespace((HasMetadata)entity);
        if (StringUtils.isBlank((CharSequence)answer)) {
            answer = this.getNamespace();
        }
        this.applyNamespace(answer);
        return answer;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFallbackNamespace(String namespace) {
        this.fallbackNamespace = namespace;
    }

    public boolean isProcessTemplatesLocally() {
        return this.processTemplatesLocally;
    }

    public void setProcessTemplatesLocally(boolean processTemplatesLocally) {
        this.processTemplatesLocally = processTemplatesLocally;
    }

    public void setDeletePodsOnReplicationControllerUpdate(boolean deletePodsOnReplicationControllerUpdate) {
        this.deletePodsOnReplicationControllerUpdate = deletePodsOnReplicationControllerUpdate;
    }

    public void setLogJsonDir(File logJsonDir) {
        this.logJsonDir = logJsonDir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected boolean isRunning(HasMetadata entity) {
        return entity != null;
    }

    protected void onApplyError(String message, Exception e) {
        this.log.error(message, new Object[]{e});
        throw new RuntimeException(message, e);
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }

    public boolean isIgnoreBoundPersistentVolumeClaims() {
        return this.ignoreBoundPersistentVolumeClaims;
    }

    public void setIgnoreBoundPersistentVolumeClaims(boolean ignoreBoundPersistentVolumeClaims) {
        this.ignoreBoundPersistentVolumeClaims = ignoreBoundPersistentVolumeClaims;
    }

    public void setSupportOAuthClients(boolean supportOAuthClients) {
        this.supportOAuthClients = supportOAuthClients;
    }

    public void setRollingUpgrade(boolean rollingUpgrade) {
        this.rollingUpgrade = rollingUpgrade;
    }

    public void setRollingUpgradePreserveScale(boolean rollingUpgradePreserveScale) {
        this.rollingUpgradePreserveScale = rollingUpgradePreserveScale;
    }

    public void applyEntities(String fileName, Collection<HasMetadata> entities, KitLogger serviceLogger, long serviceUrlWaitTimeSeconds) throws InterruptedException {
        this.applyStandardEntities(fileName, ApplyService.getK8sListWithNamespaceFirst(entities));
        this.logExposeServiceUrl(entities, serviceLogger, serviceUrlWaitTimeSeconds);
    }

    private void logExposeServiceUrl(Collection<HasMetadata> entities, KitLogger serviceLogger, long serviceUrlWaitTimeSeconds) throws InterruptedException {
        String url = KubernetesHelper.getServiceExposeUrl((KubernetesClient)this.kubernetesClient, entities, (long)serviceUrlWaitTimeSeconds, (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value());
        if (url != null) {
            serviceLogger.info("ExposeController Service URL: %s", new Object[]{url});
        }
    }

    private void applyStandardEntities(String fileName, List<HasMetadata> entities) {
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                this.applyPod(pod, fileName);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                this.applyService(service, fileName);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                this.applyReplicationController(replicationController, fileName);
                continue;
            }
            if (entity == null) continue;
            this.apply(entity, fileName);
        }
    }

    public static List<HasMetadata> getK8sListWithNamespaceFirst(Collection<HasMetadata> k8sList) {
        return k8sList.stream().sorted((k1, k2) -> {
            if (ApplyService.isNamespaceOrProject(k1)) {
                return -1;
            }
            if (ApplyService.isNamespaceOrProject(k2)) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    private static boolean isNamespaceOrProject(HasMetadata h) {
        return h instanceof Namespace || h instanceof Project;
    }
}

