/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesUndeployService;

public class OpenshiftUndeployService
extends KubernetesUndeployService {
    public OpenshiftUndeployService(JKubeServiceHub jKubeServiceHub, KitLogger logger) {
        super(jKubeServiceHub, logger);
    }

    @Override
    protected Consumer<HasMetadata> resourceDeleter(String namespace, String fallbackNamespace) {
        Consumer<HasMetadata> standardDeleter = super.resourceDeleter(namespace, fallbackNamespace);
        OpenShiftClient oc = OpenshiftHelper.asOpenShiftClient((KubernetesClient)this.getjKubeServiceHub().getClient());
        return entity -> {
            List<String> isTags = this.imageStreamTags((HasMetadata)entity);
            if (oc != null && !isTags.isEmpty()) {
                for (String isTag : isTags) {
                    ((BuildList)((NonNamespaceOperation)oc.builds().inNamespace(namespace)).list()).getItems().stream().filter(this.labelMatcherFilter((HasMetadata)entity)).filter(bc -> Objects.equals(bc.getSpec().getOutput().getTo().getName(), isTag)).forEach(standardDeleter);
                    ((BuildConfigList)((NonNamespaceOperation)oc.buildConfigs().inNamespace(namespace)).list()).getItems().stream().filter(this.labelMatcherFilter((HasMetadata)entity)).filter(bc -> Objects.equals(bc.getSpec().getOutput().getTo().getName(), isTag)).forEach(standardDeleter);
                }
            }
            standardDeleter.accept((HasMetadata)entity);
        };
    }

    private Predicate<HasMetadata> labelMatcherFilter(HasMetadata originalEntity) {
        return toFilter -> {
            String originalEntityProvider = OpenshiftUndeployService.providerLabel(originalEntity);
            if (StringUtils.isNotBlank((CharSequence)originalEntityProvider)) {
                return originalEntityProvider.equals(OpenshiftUndeployService.providerLabel(toFilter));
            }
            return true;
        };
    }

    private static String providerLabel(HasMetadata entity) {
        return Optional.ofNullable(entity).map(HasMetadata::getMetadata).map(ObjectMeta::getLabels).map(labels -> (String)labels.get("provider")).orElse(null);
    }

    private List<String> imageStreamTags(HasMetadata entity) {
        if (entity instanceof ImageStream) {
            ImageStream is = (ImageStream)entity;
            this.getLogger().info("ImageStream %s found, deleting related builds and build configs", new Object[]{is.getMetadata().getName()});
            return is.getSpec().getTags().stream().map(tr -> String.format("%s:%s", is.getMetadata().getName(), tr.getName())).collect(Collectors.toList());
        }
        if (entity instanceof DeploymentConfig) {
            DeploymentConfig dc = (DeploymentConfig)entity;
            this.getLogger().info("DeploymentConfig %s found, deleting related builds and build configs", new Object[]{dc.getMetadata().getName()});
            return Optional.ofNullable(dc.getSpec()).map(DeploymentConfigSpec::getTriggers).orElse(Collections.emptyList()).stream().filter(t -> t.getType().equalsIgnoreCase("ImageChange")).map(DeploymentTriggerPolicy::getImageChangeParams).map(DeploymentTriggerImageChangeParams::getFrom).filter(or -> or.getKind().equalsIgnoreCase("ImageStreamTag")).map(ObjectReference::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

