/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.portforward;

import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.service.portforward.PortForwardMonitor;

public class PortForwardTask
implements Runnable,
AutoCloseable {
    private final NamespacedKubernetesClient kubernetesClient;
    private final String podName;
    private final LocalPortForward localPortForward;
    private final KitLogger logger;
    private final CountDownLatch podAvailableLatch = new CountDownLatch(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!this.closed.get()) {
                this.logger.info("Shutting down", new Object[0]);
                this.close();
            }
        }));
        try (Watch ignore = this.kubernetesClient.pods().watch((Watcher)new PortForwardMonitor(this.logger, this.podName, this.podAvailableLatch));){
            this.podAvailableLatch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            this.logger.warn("Not able to port forward: %s", new Object[]{exception.getMessage()});
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            this.logger.info("Closing port forward for Debug Session ...", new Object[0]);
            this.localPortForward.close();
            this.closed.set(true);
        }
        catch (IOException exception) {
            this.logger.warn("Not able to close Port forward gracefully : %s", new Object[]{exception.getMessage()});
        }
    }

    public PortForwardTask(NamespacedKubernetesClient kubernetesClient, String podName, LocalPortForward localPortForward, KitLogger logger) {
        this.kubernetesClient = kubernetesClient;
        this.podName = podName;
        this.localPortForward = localPortForward;
        this.logger = logger;
    }
}

