/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.RegistryServerConfiguration;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.ProjectClassLoaders;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.model.Configuration;

public class JKubeEnricherContext
implements EnricherContext {
    private Configuration configuration;
    private List<RegistryServerConfiguration> settings;
    private Map<String, String> processingInstruction;
    private JavaProject project;
    private KitLogger log;

    public JKubeEnricherContext(List<RegistryServerConfiguration> settings, Map<String, String> processingInstructions, JavaProject project, KitLogger log, ResourceConfig resources, List<ImageConfiguration> images, ProcessorConfig processorConfig) {
        this.settings = settings;
        this.processingInstruction = processingInstructions;
        this.project = project;
        this.log = log;
        this.configuration = Configuration.builder().images(images).resource(resources).processorConfig(processorConfig).pluginConfigLookup((system, id) -> {
            if (!"maven".equals(system)) {
                return Optional.empty();
            }
            Plugin plugin = JKubeProjectUtil.getPlugin((JavaProject)this.project, (String)id);
            if (plugin == null) {
                return Optional.empty();
            }
            return Optional.of(plugin.getConfiguration());
        }).secretConfigLookup(id -> {
            if (this.settings == null || StringUtils.isBlank((CharSequence)id)) {
                return Optional.empty();
            }
            RegistryServerConfiguration server = RegistryServerConfiguration.getServer(this.settings, (String)id);
            if (server == null) {
                return Optional.empty();
            }
            Map config = server.getConfiguration();
            config.put("id", server.getId());
            config.put("username", server.getUsername());
            config.put("password", server.getPassword());
            return Optional.of(config);
        }).build();
    }

    @Override
    public Map<String, String> getProcessingInstructions() {
        return this.processingInstruction;
    }

    @Override
    public void setProcessingInstructions(Map<String, String> instruction) {
        this.processingInstruction = instruction;
    }

    @Override
    public GroupArtifactVersion getGav() {
        return new GroupArtifactVersion(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    @Override
    public File getProjectDirectory() {
        return this.getProject().getBaseDirectory();
    }

    @Override
    public List<Dependency> getDependencies(boolean transitive) {
        return transitive ? this.getProject().getDependenciesWithTransitive() : this.getProject().getDependencies();
    }

    @Override
    public boolean hasPlugin(String groupId, String artifactId) {
        if (groupId != null) {
            return JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)groupId, (String)artifactId);
        }
        return JKubeProjectUtil.getPlugin((JavaProject)this.getProject(), (String)artifactId) != null;
    }

    @Override
    public ProjectClassLoaders getProjectClassLoaders() {
        return new ProjectClassLoaders(ClassUtil.createClassLoader((List)this.getProject().getCompileClassPathElements(), (String[])new String[]{this.getProject().getOutputDirectory().getAbsolutePath()}));
    }

    @Override
    public Properties getProperties() {
        return this.project.getProperties();
    }

    @Override
    public String getProperty(String key) {
        return this.project.getProperties() != null ? this.project.getProperties().getProperty(key) : null;
    }

    public String getDockerJsonConfigString(List<RegistryServerConfiguration> settings, String serverId) {
        RegistryServerConfiguration server = RegistryServerConfiguration.getServer(settings, (String)serverId);
        if (server == null) {
            return "";
        }
        JsonObject auth = new JsonObject();
        auth.add("username", (JsonElement)new JsonPrimitive(server.getUsername()));
        auth.add("password", (JsonElement)new JsonPrimitive(server.getPassword()));
        String mail = this.getConfigurationValue(server, "email");
        if (!StringUtils.isBlank((CharSequence)mail)) {
            auth.add("email", (JsonElement)new JsonPrimitive(mail));
        }
        JsonObject json = new JsonObject();
        json.add(serverId, (JsonElement)auth);
        return json.toString();
    }

    private String getConfigurationValue(RegistryServerConfiguration server, String key) {
        return Optional.ofNullable(server.getConfiguration()).filter(c -> c.containsKey(key)).map(c -> c.get(key).toString()).orElse(null);
    }

    public static JKubeEnricherContextBuilder builder() {
        return new JKubeEnricherContextBuilder();
    }

    public JKubeEnricherContext(Configuration configuration, List<RegistryServerConfiguration> settings, Map<String, String> processingInstruction, JavaProject project, KitLogger log) {
        this.configuration = configuration;
        this.settings = settings;
        this.processingInstruction = processingInstruction;
        this.project = project;
        this.log = log;
    }

    private JKubeEnricherContext() {
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<RegistryServerConfiguration> getSettings() {
        return this.settings;
    }

    public Map<String, String> getProcessingInstruction() {
        return this.processingInstruction;
    }

    @Override
    public JavaProject getProject() {
        return this.project;
    }

    @Override
    public KitLogger getLog() {
        return this.log;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JKubeEnricherContext)) {
            return false;
        }
        JKubeEnricherContext other = (JKubeEnricherContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<RegistryServerConfiguration> this$settings = this.getSettings();
        List<RegistryServerConfiguration> other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        Map<String, String> this$processingInstruction = this.getProcessingInstruction();
        Map<String, String> other$processingInstruction = other.getProcessingInstruction();
        if (this$processingInstruction == null ? other$processingInstruction != null : !((Object)this$processingInstruction).equals(other$processingInstruction)) {
            return false;
        }
        JavaProject this$project = this.getProject();
        JavaProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        KitLogger this$log = this.getLog();
        KitLogger other$log = other.getLog();
        return !(this$log == null ? other$log != null : !this$log.equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JKubeEnricherContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<RegistryServerConfiguration> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        Map<String, String> $processingInstruction = this.getProcessingInstruction();
        result = result * 59 + ($processingInstruction == null ? 43 : ((Object)$processingInstruction).hashCode());
        JavaProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        KitLogger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        return result;
    }

    public static class JKubeEnricherContextBuilder {
        private ArrayList<RegistryServerConfiguration> settings;
        private ArrayList<String> processingInstructions$key;
        private ArrayList<String> processingInstructions$value;
        private JavaProject project;
        private KitLogger log;
        private ResourceConfig resources;
        private ArrayList<ImageConfiguration> images;
        private ProcessorConfig processorConfig;

        JKubeEnricherContextBuilder() {
        }

        public JKubeEnricherContextBuilder setting(RegistryServerConfiguration setting) {
            if (this.settings == null) {
                this.settings = new ArrayList();
            }
            this.settings.add(setting);
            return this;
        }

        public JKubeEnricherContextBuilder settings(Collection<? extends RegistryServerConfiguration> settings) {
            if (settings == null) {
                throw new NullPointerException("settings cannot be null");
            }
            if (this.settings == null) {
                this.settings = new ArrayList();
            }
            this.settings.addAll(settings);
            return this;
        }

        public JKubeEnricherContextBuilder clearSettings() {
            if (this.settings != null) {
                this.settings.clear();
            }
            return this;
        }

        public JKubeEnricherContextBuilder processingInstruction(String processingInstructionKey, String processingInstructionValue) {
            if (this.processingInstructions$key == null) {
                this.processingInstructions$key = new ArrayList();
                this.processingInstructions$value = new ArrayList();
            }
            this.processingInstructions$key.add(processingInstructionKey);
            this.processingInstructions$value.add(processingInstructionValue);
            return this;
        }

        public JKubeEnricherContextBuilder processingInstructions(Map<? extends String, ? extends String> processingInstructions) {
            if (processingInstructions == null) {
                throw new NullPointerException("processingInstructions cannot be null");
            }
            if (this.processingInstructions$key == null) {
                this.processingInstructions$key = new ArrayList();
                this.processingInstructions$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : processingInstructions.entrySet()) {
                this.processingInstructions$key.add($lombokEntry.getKey());
                this.processingInstructions$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public JKubeEnricherContextBuilder clearProcessingInstructions() {
            if (this.processingInstructions$key != null) {
                this.processingInstructions$key.clear();
                this.processingInstructions$value.clear();
            }
            return this;
        }

        public JKubeEnricherContextBuilder project(JavaProject project) {
            this.project = project;
            return this;
        }

        public JKubeEnricherContextBuilder log(KitLogger log) {
            this.log = log;
            return this;
        }

        public JKubeEnricherContextBuilder resources(ResourceConfig resources) {
            this.resources = resources;
            return this;
        }

        public JKubeEnricherContextBuilder image(ImageConfiguration image) {
            if (this.images == null) {
                this.images = new ArrayList();
            }
            this.images.add(image);
            return this;
        }

        public JKubeEnricherContextBuilder images(Collection<? extends ImageConfiguration> images) {
            if (images == null) {
                throw new NullPointerException("images cannot be null");
            }
            if (this.images == null) {
                this.images = new ArrayList();
            }
            this.images.addAll(images);
            return this;
        }

        public JKubeEnricherContextBuilder clearImages() {
            if (this.images != null) {
                this.images.clear();
            }
            return this;
        }

        public JKubeEnricherContextBuilder processorConfig(ProcessorConfig processorConfig) {
            this.processorConfig = processorConfig;
            return this;
        }

        public JKubeEnricherContext build() {
            List<ImageConfiguration> images;
            Map<String, String> processingInstructions;
            List<RegistryServerConfiguration> settings;
            switch (this.settings == null ? 0 : this.settings.size()) {
                case 0: {
                    settings = Collections.emptyList();
                    break;
                }
                case 1: {
                    settings = Collections.singletonList(this.settings.get(0));
                    break;
                }
                default: {
                    settings = Collections.unmodifiableList(new ArrayList<RegistryServerConfiguration>(this.settings));
                }
            }
            switch (this.processingInstructions$key == null ? 0 : this.processingInstructions$key.size()) {
                case 0: {
                    processingInstructions = Collections.emptyMap();
                    break;
                }
                case 1: {
                    processingInstructions = Collections.singletonMap(this.processingInstructions$key.get(0), this.processingInstructions$value.get(0));
                    break;
                }
                default: {
                    processingInstructions = new LinkedHashMap(this.processingInstructions$key.size() < 0x40000000 ? 1 + this.processingInstructions$key.size() + (this.processingInstructions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.processingInstructions$key.size(); ++$i) {
                        processingInstructions.put(this.processingInstructions$key.get($i), this.processingInstructions$value.get($i));
                    }
                    processingInstructions = Collections.unmodifiableMap(processingInstructions);
                }
            }
            switch (this.images == null ? 0 : this.images.size()) {
                case 0: {
                    images = Collections.emptyList();
                    break;
                }
                case 1: {
                    images = Collections.singletonList(this.images.get(0));
                    break;
                }
                default: {
                    images = Collections.unmodifiableList(new ArrayList<ImageConfiguration>(this.images));
                }
            }
            return new JKubeEnricherContext(settings, processingInstructions, this.project, this.log, this.resources, images, this.processorConfig);
        }

        public String toString() {
            return "JKubeEnricherContext.JKubeEnricherContextBuilder(settings=" + this.settings + ", processingInstructions$key=" + this.processingInstructions$key + ", processingInstructions$value=" + this.processingInstructions$value + ", project=" + this.project + ", log=" + this.log + ", resources=" + this.resources + ", images=" + this.images + ", processorConfig=" + this.processorConfig + ")";
        }
    }
}

