/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;
import org.eclipse.jkube.kit.config.resource.VolumeType;
import org.eclipse.jkube.kit.enricher.handler.ContainerHandler;

public class PodTemplateHandler {
    private final ContainerHandler containerHandler;

    public PodTemplateHandler(ContainerHandler containerHandler) {
        this.containerHandler = containerHandler;
    }

    public PodTemplateSpec getPodTemplate(ResourceConfig config, List<ImageConfiguration> images) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(this.createPodMetaData(config))).withSpec(this.createPodSpec(config, images))).build();
    }

    private ObjectMeta createPodMetaData(ResourceConfig config) {
        return new ObjectMetaBuilder().build();
    }

    private PodSpec createPodSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withServiceAccountName(config.getServiceAccount())).withContainers(this.containerHandler.getContainers(config, images))).withVolumes(this.getVolumes(config))).build();
    }

    private List<Volume> getVolumes(ResourceConfig config) {
        List volumeConfigs = config.getVolumes();
        ArrayList<Volume> ret = new ArrayList<Volume>();
        if (volumeConfigs != null) {
            for (VolumeConfig volumeConfig : volumeConfigs) {
                VolumeType type = VolumeType.typeFor((String)volumeConfig.getType());
                if (type == null) continue;
                ret.add(type.fromConfig(volumeConfig));
            }
        }
        return ret;
    }
}

