/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class ReplicaSetHandler {
    private final PodTemplateHandler podTemplateHandler;

    ReplicaSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public ReplicaSet getReplicaSet(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetBuilder)((ReplicaSetBuilder)new ReplicaSetBuilder().withMetadata(this.createRsMetaData(config))).withSpec(this.createRsSpec(config, images))).build();
    }

    private ObjectMeta createRsMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private ReplicaSetSpec createRsSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetSpecBuilder)((ReplicaSetSpecBuilder)new ReplicaSetSpecBuilder().withReplicas(config.getReplicas())).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

