/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class ReplicationControllerHandler {
    private final PodTemplateHandler podTemplateHandler;

    ReplicationControllerHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public ReplicationController getReplicationController(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicationControllerBuilder)((ReplicationControllerBuilder)new ReplicationControllerBuilder().withMetadata(this.createRcMetaData(config))).withSpec(this.createRcSpec(config, images))).build();
    }

    private ObjectMeta createRcMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"replication controller name"))).build();
    }

    private ReplicationControllerSpec createRcSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicationControllerSpecBuilder)((ReplicationControllerSpecBuilder)new ReplicationControllerSpecBuilder().withReplicas(config.getReplicas())).withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

