/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.resource.ServiceConfig;

public class ServiceHandler {
    public List<Service> getServices(List<ServiceConfig> services) {
        ArrayList<Service> ret = new ArrayList<Service>();
        for (ServiceConfig service : services) {
            ServiceBuilder serviceBuilder = (ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(service.getName())).withAnnotations(this.getAnnotations(service))).withLabels(this.getLabels(service))).endMetadata();
            ServiceFluent.SpecNested serviceSpecBuilder = serviceBuilder.withNewSpec();
            ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
            for (ServiceConfig.Port port : Optional.ofNullable(service.getPorts()).orElse(Collections.emptyList())) {
                ServicePort servicePort = ((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(port.getName())).withProtocol(port.getProtocol() != null ? port.getProtocol().name() : "TCP")).withTargetPort(new IntOrString(Integer.valueOf(port.getTargetPort())))).withPort(Integer.valueOf(port.getPort()))).withNodePort(port.getNodePort())).build();
                servicePorts.add(servicePort);
            }
            if (!servicePorts.isEmpty()) {
                serviceSpecBuilder.withPorts(servicePorts);
            }
            if (service.isHeadless()) {
                serviceSpecBuilder.withClusterIP("None");
            }
            if (StringUtils.isNotBlank((CharSequence)service.getType())) {
                serviceSpecBuilder.withType(service.getType());
            }
            serviceSpecBuilder.endSpec();
            if (!service.isHeadless() && servicePorts.isEmpty()) continue;
            ret.add(serviceBuilder.build());
        }
        return ret;
    }

    private Map<String, String> getAnnotations(ServiceConfig service) {
        return new HashMap<String, String>();
    }

    private Map<String, String> getLabels(ServiceConfig service) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (service.isExpose()) {
            MapUtil.putIfAbsent(labels, (String)"expose", (String)"true");
        }
        return labels;
    }
}

