/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.openshift.api.model.DeploymentConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.jkube.kit.common.util.LazyBuilder;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.handler.ContainerHandler;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandlerLazyBuilder;
import org.eclipse.jkube.kit.enricher.handler.DaemonSetHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentConfigHandler;
import org.eclipse.jkube.kit.enricher.handler.DeploymentHandler;
import org.eclipse.jkube.kit.enricher.handler.JobHandler;
import org.eclipse.jkube.kit.enricher.handler.NamespaceHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;
import org.eclipse.jkube.kit.enricher.handler.ProbeHandler;
import org.eclipse.jkube.kit.enricher.handler.ProjectHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicaSetHandler;
import org.eclipse.jkube.kit.enricher.handler.ReplicationControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.ServiceHandler;
import org.eclipse.jkube.kit.enricher.handler.StatefulSetHandler;

public class HandlerHub {
    private final PodTemplateHandler podTemplateHandler;
    private final List<ControllerHandlerLazyBuilder<? extends HasMetadata>> controllerHandlers;
    private final LazyBuilder<NamespaceHandler> namespaceHandler;
    private final LazyBuilder<ProjectHandler> projectHandler;
    private final LazyBuilder<ServiceHandler> serviceHandler;

    public HandlerHub(GroupArtifactVersion groupArtifactVersion, Properties configuration) {
        ProbeHandler probeHandler = new ProbeHandler();
        ContainerHandler containerHandler = new ContainerHandler(configuration, groupArtifactVersion, probeHandler);
        this.podTemplateHandler = new PodTemplateHandler(containerHandler);
        this.controllerHandlers = Arrays.asList(new ControllerHandlerLazyBuilder<Deployment>(Deployment.class, () -> new DeploymentHandler(this.podTemplateHandler)), new ControllerHandlerLazyBuilder<DeploymentConfig>(DeploymentConfig.class, () -> new DeploymentConfigHandler(this.podTemplateHandler)), new ControllerHandlerLazyBuilder<ReplicaSet>(ReplicaSet.class, () -> new ReplicaSetHandler(this.podTemplateHandler)), new ControllerHandlerLazyBuilder<ReplicationController>(ReplicationController.class, () -> new ReplicationControllerHandler(this.podTemplateHandler)), new ControllerHandlerLazyBuilder<StatefulSet>(StatefulSet.class, () -> new StatefulSetHandler(this.podTemplateHandler)), new ControllerHandlerLazyBuilder<DaemonSet>(DaemonSet.class, () -> new DaemonSetHandler(this.podTemplateHandler)), new ControllerHandlerLazyBuilder<Job>(Job.class, () -> new JobHandler(this.podTemplateHandler)));
        this.namespaceHandler = new LazyBuilder(NamespaceHandler::new);
        this.projectHandler = new LazyBuilder(ProjectHandler::new);
        this.serviceHandler = new LazyBuilder(ServiceHandler::new);
    }

    public NamespaceHandler getNamespaceHandler() {
        return (NamespaceHandler)this.namespaceHandler.get();
    }

    public ProjectHandler getProjectHandler() {
        return (ProjectHandler)this.projectHandler.get();
    }

    public ServiceHandler getServiceHandler() {
        return (ServiceHandler)this.serviceHandler.get();
    }

    public <T extends HasMetadata> ControllerHandler<T> getHandlerFor(T item) {
        if (item == null) {
            return null;
        }
        return this.getHandlerFor(item.getClass());
    }

    public <T extends HasMetadata> ControllerHandler<T> getHandlerFor(Class<T> controllerType) {
        return this.controllerHandlers.stream().filter(handler -> handler.getControllerHandlerType().isAssignableFrom(controllerType)).findAny().map(LazyBuilder::get).orElse(null);
    }

    public List<ControllerHandlerLazyBuilder<? extends HasMetadata>> getControllerHandlers() {
        return this.controllerHandlers;
    }
}

