/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jkube.kit.enricher.api.Enricher;

public interface ServiceExposer
extends Enricher {
    public static final String EXPOSE_LABEL = "expose";

    default public Set<Integer> getPorts(ServiceBuilder serviceBuilder) {
        final HashSet<Integer> ret = new HashSet<Integer>();
        if (serviceBuilder != null) {
            serviceBuilder.accept(new Visitor[]{new Visitor<ServicePortBuilder>(){

                public void visit(ServicePortBuilder element) {
                    if (element.getPort() != null) {
                        ret.add(element.getPort());
                    }
                }
            }});
        }
        return ret;
    }

    default public boolean hasWebPorts(ServiceBuilder serviceBuilder) {
        for (int port : this.getPorts(serviceBuilder)) {
            if (!Util.WEB_PORTS.contains(port)) continue;
            return true;
        }
        return false;
    }

    default public boolean canExposeService(ServiceBuilder serviceBuilder) {
        String serviceName = serviceBuilder.editOrNewMetadata().getName();
        if (Util.exposeLabel(serviceBuilder).equals("false")) {
            this.getContext().getLog().debug("Service %s can't be exposed, it has en expose: false annotation", new Object[]{serviceName});
            return false;
        }
        if (Objects.equals(serviceName, "kubernetes") || Objects.equals(serviceName, "kubernetes-ro")) {
            this.getContext().getLog().debug("Service %s can't be exposed, Kubernetes System services cannot be exposed automatically", new Object[]{serviceName});
            return false;
        }
        Set<Integer> ports = this.getPorts(serviceBuilder);
        if (ports.size() != 1) {
            this.getContext().getLog().info("Service %s can't be exposed, only single port services are supported. Has ports: %s", new Object[]{serviceName, ports});
            return false;
        }
        return true;
    }

    default public boolean isExposedWithLabel(ServiceBuilder serviceBuilder) {
        return Util.exposeLabel(serviceBuilder).equals("true");
    }

    public static final class Util {
        private static final Set<Integer> WEB_PORTS = new HashSet<Integer>(Arrays.asList(80, 443, 8443, 8080, 9080, 9090, 9443));

        private Util() {
        }

        private static String exposeLabel(ServiceBuilder serviceBuilder) {
            return serviceBuilder.editOrNewMetadata().getLabels().getOrDefault(ServiceExposer.EXPOSE_LABEL, "").toLowerCase(Locale.ROOT);
        }
    }
}

