/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ProjectClassLoaders;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.enricher.api.model.Configuration;

public interface EnricherContext {
    public GroupArtifactVersion getGav();

    public KitLogger getLog();

    public Configuration getConfiguration();

    public Map<String, String> getProcessingInstructions();

    public void setProcessingInstructions(Map<String, String> var1);

    public File getProjectDirectory();

    public ProjectClassLoaders getProjectClassLoaders();

    public boolean hasPlugin(String var1, String var2);

    public List<Dependency> getDependencies(boolean var1);

    default public boolean hasDependency(String groupId, String artifactId) {
        return this.getDependencyVersion(groupId, artifactId).isPresent();
    }

    default public Optional<String> getDependencyVersion(String groupId, String artifactId) {
        for (Dependency dep : this.getDependencies(true)) {
            String scope = dep.getScope();
            if ("test".equals(scope) || artifactId != null && !artifactId.equals(dep.getArtifactId()) || !dep.getGroupId().equals(groupId)) continue;
            return Optional.of(dep.getVersion());
        }
        return Optional.empty();
    }

    public Properties getProperties();

    public String getProperty(String var1);

    public JavaProject getProject();
}

