/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.model.PortMapping;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.resource.VolumeConfig;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.ProbeHandler;

public class ContainerHandler {
    private final ProbeHandler probeHandler;
    private final Properties configurationProperties;
    private final GroupArtifactVersion groupArtifactVersion;

    public ContainerHandler(Properties configurationProperties, GroupArtifactVersion groupArtifactVersion, ProbeHandler probeHandler) {
        this.probeHandler = probeHandler;
        this.configurationProperties = configurationProperties;
        this.groupArtifactVersion = groupArtifactVersion;
    }

    List<Container> getContainers(ResourceConfig config, List<ImageConfiguration> images) {
        ArrayList<Container> ret = new ArrayList<Container>();
        for (ImageConfiguration imageConfig : images) {
            if (imageConfig.getBuildConfiguration() == null) continue;
            Probe livenessProbe = this.probeHandler.getProbe(config.getLiveness());
            Probe readinessProbe = this.probeHandler.getProbe(config.getReadiness());
            Probe startupProbe = this.probeHandler.getProbe(config.getStartup());
            Container container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(KubernetesResourceUtil.extractContainerName(this.groupArtifactVersion, imageConfig))).withImage(this.getImageName(imageConfig))).withImagePullPolicy(this.getImagePullPolicy(config))).withEnv(this.getEnvVars(config))).withSecurityContext(this.createSecurityContext(config))).withPorts(this.getContainerPorts(imageConfig))).withVolumeMounts(this.getVolumeMounts(config))).withLivenessProbe(livenessProbe)).withReadinessProbe(readinessProbe)).withStartupProbe(startupProbe)).build();
            ret.add(container);
        }
        return ret;
    }

    private List<EnvVar> getEnvVars(ResourceConfig config) {
        List envVars = KubernetesHelper.convertToEnvVarList((Map)config.getEnv());
        envVars.removeIf(obj -> obj.getName().equals("KUBERNETES_NAMESPACE"));
        envVars.add(0, ((EnvVarBuilder)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((EnvVarBuilder)new EnvVarBuilder().withName("KUBERNETES_NAMESPACE")).withNewValueFrom().withNewFieldRef().withFieldPath("metadata.namespace")).endFieldRef()).endValueFrom()).build());
        return envVars;
    }

    private String getImagePullPolicy(ResourceConfig config) {
        String pullPolicy = config.getImagePullPolicy();
        if (StringUtils.isBlank((CharSequence)pullPolicy) && this.groupArtifactVersion.isSnapshot()) {
            return "PullAlways";
        }
        return pullPolicy;
    }

    private String getImageName(ImageConfiguration imageConfiguration) {
        if (StringUtils.isBlank((CharSequence)imageConfiguration.getName())) {
            return null;
        }
        Properties props = this.getPropertiesWithSystemOverrides(this.configurationProperties);
        String configuredRegistry = EnvUtil.firstRegistryOf((String[])new String[]{imageConfiguration.getRegistry(), props.getProperty("jkube.docker.pull.registry"), props.getProperty("jkube.docker.registry")});
        return new ImageName(imageConfiguration.getName()).getFullName(configuredRegistry);
    }

    private Properties getPropertiesWithSystemOverrides(Properties configurationProperties) {
        if (configurationProperties == null) {
            configurationProperties = new Properties();
        }
        configurationProperties.putAll((Map<?, ?>)System.getProperties());
        return configurationProperties;
    }

    private SecurityContext createSecurityContext(ResourceConfig config) {
        return ((SecurityContextBuilder)new SecurityContextBuilder().withPrivileged(Boolean.valueOf(config.isContainerPrivileged()))).build();
    }

    private List<VolumeMount> getVolumeMounts(ResourceConfig config) {
        List volumeConfigs = config.getVolumes();
        ArrayList<VolumeMount> ret = new ArrayList<VolumeMount>();
        if (volumeConfigs != null) {
            for (VolumeConfig volumeConfig : volumeConfigs) {
                List mounts = volumeConfig.getMounts();
                if (mounts == null) continue;
                for (String mount : mounts) {
                    ret.add(((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volumeConfig.getName())).withMountPath(mount)).withReadOnly(Boolean.valueOf(false))).build());
                }
            }
        }
        return ret;
    }

    private List<ContainerPort> getContainerPorts(ImageConfiguration imageConfig) {
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        List ports = buildConfig.getPorts();
        if (!ports.isEmpty()) {
            ArrayList<ContainerPort> ret = new ArrayList<ContainerPort>();
            PortMapping portMapping = new PortMapping(ports, this.configurationProperties);
            JsonArray portSpecs = portMapping.toJson();
            for (int i = 0; i < portSpecs.size(); ++i) {
                JsonObject portSpec = portSpecs.get(i).getAsJsonObject();
                ret.add(this.extractContainerPort(portSpec));
            }
            return ret;
        }
        return null;
    }

    private ContainerPort extractContainerPort(JsonObject portSpec) {
        ContainerPortBuilder portBuilder = (ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(Integer.valueOf(portSpec.get("containerPort").getAsInt()));
        if (portSpec.has("hostPort")) {
            portBuilder.withHostPort(Integer.valueOf(portSpec.get("hostPort").getAsInt()));
        }
        if (portSpec.has("protocol")) {
            portBuilder.withProtocol(portSpec.get("protocol").getAsString().toUpperCase());
        }
        if (portSpec.has("hostIP")) {
            portBuilder.withHostIP(portSpec.get("hostIP").getAsString());
        }
        return portBuilder.build();
    }
}

