/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.handler;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecBuilder;
import java.util.List;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.handler.ControllerHandler;
import org.eclipse.jkube.kit.enricher.handler.PodTemplateHandler;

public class ReplicaSetHandler
implements ControllerHandler<ReplicaSet> {
    private final PodTemplateHandler podTemplateHandler;

    ReplicaSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    @Override
    public ReplicaSet get(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetBuilder)((ReplicaSetBuilder)new ReplicaSetBuilder().withMetadata(this.createRsMetaData(config))).withSpec(this.createSpec(config, images))).build();
    }

    @Override
    public PodTemplateSpec getPodTemplateSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return this.get(config, images).getSpec().getTemplate();
    }

    @Override
    public PodTemplateSpec getPodTemplate(ReplicaSet controller) {
        return controller.getSpec().getTemplate();
    }

    @Override
    public void overrideReplicas(KubernetesListBuilder resources, final int replicas) {
        resources.accept(new Visitor[]{new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.SpecNested)builder.editOrNewSpec().withReplicas(Integer.valueOf(replicas))).endSpec();
            }
        }});
    }

    private ObjectMeta createRsMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private ReplicaSetSpec createSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((ReplicaSetSpecBuilder)((ReplicaSetSpecBuilder)new ReplicaSetSpecBuilder().withReplicas(config.getReplicas())).withTemplate(this.podTemplateHandler.getPodTemplate(config, config.getRestartPolicy(), images))).build();
    }
}

