/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.kit.enricher.handler.HandlerHub;

public class DefaultNamespaceEnricher
extends BaseEnricher {
    private static final String NAMESPACE = "namespace";
    protected static final String[] NAMESPACE_KINDS = new String[]{"Project", "Namespace"};
    protected static final List<String> NAMESPACE_KINDS_LIST = Arrays.asList(NAMESPACE_KINDS);
    private final HandlerHub handlerHub;
    private final ResourceConfig config = Optional.ofNullable(this.getConfiguration().getResource()).orElse(ResourceConfig.builder().build());

    public DefaultNamespaceEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-namespace");
        this.handlerHub = new HandlerHub(this.getContext().getGav(), this.getContext().getProperties());
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        String type;
        String ns = DefaultNamespaceEnricher.getNamespace((ResourceConfig)this.config, (String)this.getConfig(Config.NAMESPACE));
        if (ns == null || ns.isEmpty()) {
            return;
        }
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])NAMESPACE_KINDS) && ("project".equalsIgnoreCase(type = this.getConfig(Config.TYPE)) || NAMESPACE.equalsIgnoreCase(type))) {
            if (platformMode == PlatformMode.kubernetes) {
                this.log.info("Adding a default Namespace: %s", new Object[]{ns});
                Namespace namespace = this.handlerHub.getNamespaceHandler().getNamespace(ns);
                builder.addToNamespaceItems(new Namespace[]{namespace});
            } else {
                this.log.info("Adding a default Project %s", new Object[]{ns});
                Project project = this.handlerHub.getProjectHandler().getProject(ns);
                builder.addToItems(new HasMetadata[]{project});
            }
        }
    }

    public void enrich(PlatformMode platformMode, final KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

            private String getNamespaceName() {
                String defaultValue = builder.buildItems().stream().filter(item -> NAMESPACE_KINDS_LIST.contains(item.getKind())).map(HasMetadata::getMetadata).map(ObjectMeta::getName).findFirst().orElse(null);
                return BaseEnricher.getNamespace((ResourceConfig)DefaultNamespaceEnricher.this.config, (String)DefaultNamespaceEnricher.this.getConfig(Config.NAMESPACE, defaultValue));
            }

            public void visit(ObjectMetaBuilder metaBuilder) {
                if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])NAMESPACE_KINDS)) {
                    return;
                }
                String name = this.getNamespaceName();
                if (name == null || name.isEmpty()) {
                    return;
                }
                ((ObjectMetaBuilder)metaBuilder.withNamespace(name)).build();
            }
        });
        builder.accept((Visitor)new TypedVisitor<NamespaceBuilder>(){

            public void visit(NamespaceBuilder builder) {
                if (builder.buildStatus().getPhase().equals("active")) {
                    ((NamespaceBuilder)builder.editOrNewStatus().endStatus()).build();
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<ProjectBuilder>(){

            public void visit(ProjectBuilder builder) {
                if (builder.buildStatus().getPhase().equals("active")) {
                    ((ProjectBuilder)builder.editOrNewStatus().endStatus()).build();
                }
            }
        });
    }

    private static enum Config implements Configs.Config
    {
        NAMESPACE("namespace", null),
        TYPE("type", "namespace");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

