/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.resource.GroupArtifactVersion;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class ProjectLabelEnricher
extends BaseEnricher {
    public ProjectLabelEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-project-label");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                HashMap selectors = new HashMap();
                if (serviceBuilder.buildSpec() != null && serviceBuilder.buildSpec().getSelector() != null) {
                    selectors.putAll(serviceBuilder.buildSpec().getSelector());
                }
                MapUtil.mergeIfAbsent(selectors, (Map)ProjectLabelEnricher.this.createLabels(true));
                ((ServiceFluent.SpecNested)serviceBuilder.editOrNewSpec().addToSelector(selectors)).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                HashMap selectors = new HashMap();
                if (builder.buildSpec() != null && builder.buildSpec().getSelector() != null && builder.buildSpec().getSelector().getMatchLabels() != null) {
                    selectors.putAll(builder.buildSpec().getSelector().getMatchLabels());
                }
                MapUtil.mergeIfAbsent(selectors, (Map)ProjectLabelEnricher.this.createLabels(true));
                ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                HashMap selectors = new HashMap();
                if (builder.buildSpec() != null && builder.buildSpec().getSelector() != null) {
                    selectors.putAll(builder.buildSpec().getSelector());
                }
                MapUtil.mergeIfAbsent(selectors, (Map)ProjectLabelEnricher.this.createLabels(true));
                ((DeploymentConfigFluent.SpecNested)builder.editOrNewSpec().addToSelector(selectors)).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                HashMap selectors = new HashMap();
                if (builder.buildSpec() != null && builder.buildSpec().getSelector() != null && builder.buildSpec().getSelector().getMatchLabels() != null) {
                    selectors.putAll(builder.buildSpec().getSelector().getMatchLabels());
                }
                MapUtil.mergeIfAbsent(selectors, (Map)ProjectLabelEnricher.this.createLabels());
                ((DaemonSetFluent.SpecNested)((DaemonSetSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                HashMap selectors = new HashMap();
                if (builder.buildSpec() != null && builder.buildSpec().getSelector() != null && builder.buildSpec().getSelector().getMatchLabels() != null) {
                    selectors.putAll(builder.buildSpec().getSelector().getMatchLabels());
                }
                MapUtil.mergeIfAbsent(selectors, (Map)ProjectLabelEnricher.this.createLabels());
                ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        });
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder element) {
                if (element.getLabels() != null) {
                    Map labels = element.getLabels();
                    MapUtil.mergeIfAbsent((Map)labels, (Map)ProjectLabelEnricher.this.createLabels());
                } else {
                    HashMap newLabels = new HashMap();
                    MapUtil.mergeIfAbsent(newLabels, (Map)ProjectLabelEnricher.this.createLabels());
                    element.withLabels(newLabels);
                }
            }
        });
    }

    private Map<String, String> createLabels() {
        return this.createLabels(false);
    }

    private Map<String, String> createLabels(boolean withoutVersion) {
        HashMap<String, String> ret = new HashMap<String, String>();
        boolean enableProjectLabel = Configs.asBoolean((String)this.getConfig(Config.USE_PROJECT_LABEL));
        GroupArtifactVersion groupArtifactVersion = this.getContext().getGav();
        if (enableProjectLabel) {
            ret.put("project", groupArtifactVersion.getArtifactId());
        } else {
            ret.put("app", groupArtifactVersion.getArtifactId());
        }
        ret.put("group", groupArtifactVersion.getGroupId());
        ret.put("provider", "jkube");
        if (!withoutVersion) {
            ret.put("version", groupArtifactVersion.getVersion());
        }
        return ret;
    }

    private static enum Config implements Configs.Config
    {
        USE_PROJECT_LABEL("useProjectLabel", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

