/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class DebugEnricher
extends BaseEnricher {
    private static final String ENABLE_DEBUG_PROPERTY = "jkube.debug.enabled";

    public DebugEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-debug");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (this.isDebugEnabled()) {
            int count = 0;
            List items = builder.buildItems();
            if (items != null) {
                for (HasMetadata item : items) {
                    if (!this.enableDebug(item)) continue;
                    ++count;
                }
            }
            if (count > 0) {
                builder.withItems(items);
            }
            this.log.verbose("Enabled debugging on " + count + " resource(s) thanks to the " + ENABLE_DEBUG_PROPERTY + " property", new Object[0]);
        } else {
            this.log.verbose("Debugging not enabled. To enable try setting the jkube.debug.enabled maven or system property to 'true'", new Object[0]);
        }
    }

    private boolean isDebugEnabled() {
        return Configs.asBoolean((String)this.getConfigWithFallback(Config.ENABLED, ENABLE_DEBUG_PROPERTY, null));
    }

    private boolean enableDebug(HasMetadata entity) {
        DeploymentConfig resource;
        DeploymentConfigSpec spec;
        if (entity instanceof Deployment) {
            Deployment resource2 = (Deployment)entity;
            DeploymentSpec spec2 = resource2.getSpec();
            if (spec2 != null) {
                return this.enableDebugging(entity, spec2.getTemplate());
            }
        } else if (entity instanceof ReplicaSet) {
            ReplicaSet resource3 = (ReplicaSet)entity;
            ReplicaSetSpec spec3 = resource3.getSpec();
            if (spec3 != null) {
                return this.enableDebugging(entity, spec3.getTemplate());
            }
        } else if (entity instanceof ReplicationController) {
            ReplicationController resource4 = (ReplicationController)entity;
            ReplicationControllerSpec spec4 = resource4.getSpec();
            if (spec4 != null) {
                return this.enableDebugging(entity, spec4.getTemplate());
            }
        } else if (entity instanceof DeploymentConfig && (spec = (resource = (DeploymentConfig)entity).getSpec()) != null) {
            return this.enableDebugging(entity, spec.getTemplate());
        }
        return false;
    }

    private boolean enableDebugging(HasMetadata entity, PodTemplateSpec template) {
        List containers;
        PodSpec podSpec;
        if (template != null && (podSpec = template.getSpec()) != null && !(containers = podSpec.getContainers()).isEmpty()) {
            ArrayList ports;
            Container container = (Container)containers.get(0);
            ArrayList env = container.getEnv();
            if (env == null) {
                env = new ArrayList();
            }
            String remoteDebugPort = KubernetesHelper.getEnvVar(env, (String)"JAVA_DEBUG_PORT", (String)"5005");
            boolean enabled = false;
            if (KubernetesHelper.setEnvVar(env, (String)"JAVA_ENABLE_DEBUG", (String)"true")) {
                container.setEnv(env);
                enabled = true;
            }
            if ((ports = container.getPorts()) == null) {
                ports = new ArrayList();
            }
            if (KubernetesResourceUtil.addPort(ports, (String)remoteDebugPort, (String)"debug", (KitLogger)this.log)) {
                container.setPorts(ports);
                enabled = true;
            }
            if (enabled) {
                this.log.info("Enabling debug on " + KubernetesHelper.getKind((HasMetadata)entity) + " " + KubernetesHelper.getName((HasMetadata)entity) + " due to the property: " + ENABLE_DEBUG_PROPERTY, new Object[0]);
                return true;
            }
        }
        return false;
    }

    private static enum Config implements Configs.Config
    {
        ENABLED("enabled", "false");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

