/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class IngressEnricher
extends BaseEnricher {
    public static final String EXPOSE_LABEL = "expose";

    public IngressEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-ingress");
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        final ResourceConfig resourceConfig = this.getConfiguration().getResource();
        Boolean shouldCreateIngress = this.getValueFromConfig("jkube.createExternalUrls", false);
        if (shouldCreateIngress.equals(Boolean.FALSE)) {
            return;
        }
        if (platformMode == PlatformMode.kubernetes) {
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    Ingress ingress = IngressEnricher.addIngress(listBuilder, serviceBuilder, IngressEnricher.this.getRouteDomain(resourceConfig), IngressEnricher.this.log);
                    if (ingress != null) {
                        listBuilder.addToItems(new HasMetadata[]{ingress});
                    }
                }
            });
        }
    }

    protected static Ingress addIngress(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder, String routeDomainPostfix, KitLogger log) {
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata == null) {
            log.info("No Metadata for service! ", new Object[0]);
        }
        if (IngressEnricher.isExposedService(serviceMetadata) && IngressEnricher.shouldCreateExternalURLForService(serviceBuilder, log)) {
            Integer servicePort;
            Objects.requireNonNull(serviceMetadata);
            String serviceName = serviceMetadata.getName();
            if (!IngressEnricher.hasIngress(listBuilder, serviceName) && (servicePort = IngressEnricher.getServicePort(serviceBuilder)) != null) {
                IngressBuilder ingressBuilder = (IngressBuilder)((IngressBuilder)new IngressBuilder().withMetadata(serviceMetadata)).withNewSpec().endSpec();
                KubernetesResourceUtil.removeLabel((ObjectMeta)ingressBuilder.buildMetadata(), (String)EXPOSE_LABEL, (String)"true");
                KubernetesResourceUtil.removeLabel((ObjectMeta)ingressBuilder.buildMetadata(), (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value(), (String)"true");
                ingressBuilder.withNewMetadataLike(ingressBuilder.buildMetadata());
                if (StringUtils.isNotBlank((CharSequence)routeDomainPostfix)) {
                    routeDomainPostfix = serviceName + "." + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
                    ingressBuilder = (IngressBuilder)ingressBuilder.withSpec(((IngressSpecBuilder)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)new IngressSpecBuilder().addNewRule().withHost(routeDomainPostfix)).withNewHttp().withPaths(new HTTPIngressPath[]{((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)IngressEnricher.getServicePort(serviceBuilder)))).endBackend()).build()})).endHttp()).endRule()).build());
                } else {
                    ingressBuilder.withSpec(((IngressSpecBuilder)new IngressSpecBuilder().withBackend(((IngressBackendBuilder)((IngressBackendBuilder)new IngressBackendBuilder().withNewServiceName(serviceName)).withNewServicePort(IngressEnricher.getServicePort(serviceBuilder))).build())).build());
                }
                return ingressBuilder.build();
            }
        }
        return null;
    }

    private static Integer getServicePort(ServiceBuilder serviceBuilder) {
        List ports;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null && !ports.isEmpty()) {
            for (ServicePort port : ports) {
                if (!port.getName().equals("http") && !port.getProtocol().equals("http")) continue;
                return port.getPort();
            }
            ServicePort servicePort = (ServicePort)ports.get(0);
            if (servicePort != null) {
                return servicePort.getPort();
            }
        }
        return 0;
    }

    private static boolean hasIngress(KubernetesListBuilder listBuilder, final String name) {
        final AtomicBoolean answer = new AtomicBoolean(false);
        listBuilder.accept((Visitor)new TypedVisitor<IngressBuilder>(){

            public void visit(IngressBuilder builder) {
                ObjectMeta metadata = builder.buildMetadata();
                if (metadata != null && name.equals(metadata.getName())) {
                    answer.set(true);
                }
            }
        });
        return answer.get();
    }

    private static boolean shouldCreateExternalURLForService(ServiceBuilder service, KitLogger log) {
        String serviceName = service.buildMetadata().getName();
        ServiceSpec spec = service.buildSpec();
        if (spec != null && !IngressEnricher.isKuberentesSystemService(serviceName)) {
            List ports = spec.getPorts();
            log.debug("Service " + serviceName + " has ports: " + ports, new Object[0]);
            if (ports.size() == 1) {
                String type = spec.getType();
                if (Objects.equals(type, "LoadBalancer")) {
                    return true;
                }
                log.info("Not generating Ingress for service " + serviceName + " type is not LoadBalancer: " + type, new Object[0]);
            } else {
                log.info("Not generating Ingress for service " + serviceName + " as only single port services are supported. Has ports: " + ports, new Object[0]);
            }
        }
        return false;
    }

    private static boolean isKuberentesSystemService(String serviceName) {
        return "kubernetes".equals(serviceName) || "kubernetes-ro".equals(serviceName);
    }

    private String getRouteDomain(ResourceConfig resourceConfig) {
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            return resourceConfig.getRouteDomain();
        }
        String routeDomainFromProperties = this.getValueFromConfig("jkube.domain", "");
        if (StringUtils.isNotEmpty((CharSequence)routeDomainFromProperties)) {
            return routeDomainFromProperties;
        }
        return null;
    }

    private static boolean isExposedService(ObjectMeta objectMeta) {
        return KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)objectMeta, (String)EXPOSE_LABEL, (String)"true") || KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)objectMeta, (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value(), (String)"true");
    }
}

