/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.openshift.api.model.ImageChangeTrigger;
import io.fabric8.openshift.api.model.ImageChangeTriggerBuilder;
import io.fabric8.openshift.api.model.ImageChangeTriggerFluent;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class TriggersAnnotationEnricher
extends BaseEnricher {
    private static final String TRIGGERS_ANNOTATION = "image.openshift.io/triggers";

    public TriggersAnnotationEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-triggers-annotation");
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder o) {
                StatefulSet s = o.build();
                if (TriggersAnnotationEnricher.this.canWriteTriggers((HasMetadata)s)) {
                    o.withMetadata(TriggersAnnotationEnricher.this.getMetaEnrichedWithTriggers(s.getMetadata(), (VisitableBuilder<?, ?>)o));
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder o) {
                ReplicaSet s = o.build();
                if (TriggersAnnotationEnricher.this.canWriteTriggers((HasMetadata)s)) {
                    o.withMetadata(TriggersAnnotationEnricher.this.getMetaEnrichedWithTriggers(s.getMetadata(), (VisitableBuilder<?, ?>)o));
                }
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder o) {
                DaemonSet s = o.build();
                if (TriggersAnnotationEnricher.this.canWriteTriggers((HasMetadata)s)) {
                    o.withMetadata(TriggersAnnotationEnricher.this.getMetaEnrichedWithTriggers(s.getMetadata(), (VisitableBuilder<?, ?>)o));
                }
            }
        });
    }

    protected ObjectMeta getMetaEnrichedWithTriggers(ObjectMeta meta, VisitableBuilder<?, ?> o) {
        ObjectMetaBuilder metaBuilder = meta != null ? new ObjectMetaBuilder(meta) : new ObjectMetaBuilder();
        return ((ObjectMetaBuilder)metaBuilder.addToAnnotations(TRIGGERS_ANNOTATION, this.createAnnotation((Visitable<?>)o))).build();
    }

    protected boolean canWriteTriggers(HasMetadata res) {
        return res.getMetadata() == null || res.getMetadata().getAnnotations() == null || !res.getMetadata().getAnnotations().containsKey(TRIGGERS_ANNOTATION);
    }

    protected String createAnnotation(Visitable<?> builder) {
        final ArrayList triggerList = new ArrayList();
        builder.accept((Visitor)new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder cb) {
                Container container = cb.build();
                String containerName = container.getName();
                String containerImage = container.getImage();
                ImageName image = new ImageName(containerImage);
                if (TriggersAnnotationEnricher.this.isContainerAllowed(containerName) && image.getRegistry() == null && image.getUser() == null) {
                    String tag = image.getTag() != null ? image.getTag() : "latest";
                    ImageChangeTrigger trigger = ((ImageChangeTriggerBuilder)((ImageChangeTriggerFluent.FromNested)((ImageChangeTriggerFluent.FromNested)new ImageChangeTriggerBuilder().withNewFrom().withKind("ImageStreamTag")).withName(image.getSimpleName() + ":" + tag)).endFrom()).build();
                    trigger.setAdditionalProperty("fieldPath", (Object)("spec.template.spec.containers[?(@.name==\"" + containerName + "\")].image"));
                    triggerList.add(trigger);
                }
            }
        });
        try {
            return ResourceUtil.toJson(triggerList);
        }
        catch (JsonProcessingException e) {
            this.getLog().error("Error while creating ImageStreamTag triggers for Kubernetes resources: %s", new Object[]{e});
            return "[]";
        }
    }

    protected boolean isContainerAllowed(String containerName) {
        String namesStr = this.getConfig(Config.CONTAINERS);
        HashSet<String> allowedNames = new HashSet<String>();
        if (namesStr != null) {
            for (String name : namesStr.split(",")) {
                allowedNames.add(name.trim());
            }
        }
        return allowedNames.isEmpty() || allowedNames.contains(containerName);
    }

    private static enum Config implements Configs.Config
    {
        CONTAINERS("containers");

        protected String key;

        private Config(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

