/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jkube.kit.common.util.Base64Util;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class FileDataSecretEnricher
extends BaseEnricher {
    protected static final String PREFIX_ANNOTATION = "maven.jkube.io/secret/";

    public FileDataSecretEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-secret-file");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.addAnnotations(builder);
    }

    private void addAnnotations(KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<SecretBuilder>(){

            public void visit(SecretBuilder element) {
                Map annotations = element.buildMetadata().getAnnotations();
                try {
                    if (annotations != null && !annotations.isEmpty()) {
                        Map secretAnnotations = FileDataSecretEnricher.this.createSecretFromAnnotations(annotations);
                        element.addToData(secretAnnotations);
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }});
    }

    private Map<String, String> createSecretFromAnnotations(Map<String, String> annotations) throws IOException {
        Set<Map.Entry<String, String>> entries = annotations.entrySet();
        HashMap<String, String> secretFileLocations = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(PREFIX_ANNOTATION)) continue;
            byte[] bytes = this.readContent(entry.getValue());
            secretFileLocations.put(this.getOutput(key), Base64Util.encodeToString((byte[])bytes));
            it.remove();
        }
        return secretFileLocations;
    }

    private byte[] readContent(String location) throws IOException {
        return Files.readAllBytes(Paths.get(location, new String[0]));
    }

    private String getOutput(String key) {
        return key.substring(PREFIX_ANNOTATION.length());
    }
}

